/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.api;

import com.intellij.psi.PsiElement;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;

public final class RubyContainerSymbolAncestor
implements Comparable<RubyContainerSymbolAncestor> {
    public static final Comparator<RubyContainerSymbolAncestor> PROCESSING_ORDER_COMPARATOR = Comparator.comparing(it -> it.myGroup, ProcessingGroup.PROCESSING_ORDER_COMPARATOR).thenComparing(it -> it.myElement, Comparator.nullsFirst(RubyPsiUtil.getRelativePositionComparator().reversed())).thenComparingInt(it -> it.myOrdinal);
    private static final Comparator<RubyContainerSymbolAncestor> NATURAL_ORDER_COMPARATOR = Comparator.comparing(it -> it.myGroup).thenComparing(it -> it.myElement, Comparator.nullsLast(RubyPsiUtil.getRelativePositionComparator())).thenComparingInt(it -> -it.myOrdinal);
    private final ProcessingGroup myGroup;
    @Nullable
    private final PsiElement myElement;
    private final int myOrdinal;
    private final Function<Stream<? extends RubyContainerSymbol>, @Nullable RubyContainerSymbol> myResolveFun;

    public RubyContainerSymbolAncestor(@NotNull ProcessingGroup group, @NotNull RubyContainerSymbol ancestor) {
        if (group == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(0);
        }
        if (ancestor == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(1);
        }
        this(group, null, 0, __ -> ancestor);
    }

    public RubyContainerSymbolAncestor(@NotNull ProcessingGroup group, @NotNull Function<Stream<? extends RubyContainerSymbol>, @Nullable RubyContainerSymbol> resolveFun) {
        if (group == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(2);
        }
        if (resolveFun == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(3);
        }
        this(group, null, 0, resolveFun);
    }

    public RubyContainerSymbolAncestor(@NotNull ProcessingGroup group, int ordinal, @NotNull RubyContainerSymbol ancestor) {
        if (group == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(4);
        }
        if (ancestor == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(5);
        }
        this(group, null, ordinal, __ -> ancestor);
    }

    public RubyContainerSymbolAncestor(@NotNull ProcessingGroup group, @Nullable PsiElement element, int ordinal, @NotNull Function<Stream<? extends RubyContainerSymbol>, @Nullable RubyContainerSymbol> resolveFun) {
        if (group == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(6);
        }
        if (resolveFun == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(7);
        }
        this.myGroup = group;
        this.myElement = element;
        this.myOrdinal = ordinal;
        this.myResolveFun = resolveFun;
    }

    @Override
    public int compareTo(@NotNull RubyContainerSymbolAncestor other) {
        if (other == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(8);
        }
        return NATURAL_ORDER_COMPARATOR.compare(this, other);
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public ProcessingGroup getProcessingGroup() {
        ProcessingGroup processingGroup = this.myGroup;
        if (processingGroup == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(9);
        }
        return processingGroup;
    }

    @Nullable
    public RubyContainerSymbol resolve(@NotNull Stream<? extends RubyContainerSymbol> ancestors) {
        if (ancestors == null) {
            RubyContainerSymbolAncestor.$$$reportNull$$$0(10);
        }
        return this.myResolveFun.apply(ancestors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveFun";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/api/RubyContainerSymbolAncestor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/api/RubyContainerSymbolAncestor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    public static enum ProcessingGroup {
        PREPEND,
        SELF(-1),
        INCLUDE,
        EXTEND,
        SUPERCLASS(-2);

        private static final Comparator<ProcessingGroup> PROCESSING_ORDER_COMPARATOR;
        private final int myProcessingOrdinal;

        private ProcessingGroup() {
            this.myProcessingOrdinal = this.ordinal();
        }

        private ProcessingGroup(int processingOrdinal) {
            this.myProcessingOrdinal = processingOrdinal;
        }

        static {
            PROCESSING_ORDER_COMPARATOR = Comparator.comparingInt(it -> it.myProcessingOrdinal);
        }
    }
}

