/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.api;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolAncestor;
import org.jetbrains.plugins.ruby.ruby.model.cache.RubySymbolsCache;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubySingletonSymbol;

final class RubyContainerSymbolAllAncestorsSpliterator
extends Spliterators.AbstractSpliterator<RubyContainerSymbol> {
    private final Project myProject;
    private final SearchScope mySearchScope;
    @Nullable
    private final RubyContainerSymbol mySymbol;
    @Nullable
    private final RecursionGuard.StackStamp myStamp;
    private final MultiMap<RubyContainerSymbolAncestor.ProcessingGroup, RubyContainerSymbol> myQueue;
    private final List<RubyContainerSymbol> myAllAncestors;
    private int myIndex;

    RubyContainerSymbolAllAncestorsSpliterator(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyContainerSymbol symbol, @NotNull RecursionGuard.StackStamp stamp) {
        if (project == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(2);
        }
        if (stamp == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(3);
        }
        super(Long.MAX_VALUE, 1296);
        this.myQueue = new MultiMap();
        this.myAllAncestors = new ArrayList<RubyContainerSymbol>();
        this.myIndex = 0;
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.mySymbol = symbol;
        this.myStamp = stamp;
    }

    RubyContainerSymbolAllAncestorsSpliterator(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull MultiMap<RubyContainerSymbolAncestor.ProcessingGroup, RubyContainerSymbol> queue) {
        if (project == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(5);
        }
        if (queue == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(6);
        }
        super(Long.MAX_VALUE, 1296);
        this.myQueue = new MultiMap();
        this.myAllAncestors = new ArrayList<RubyContainerSymbol>();
        this.myIndex = 0;
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.mySymbol = null;
        this.myStamp = null;
        this.myQueue.putAllValues(queue);
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super RubyContainerSymbol> action) {
        if (action == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(7);
        }
        if (!this.tryAdvance(action)) {
            return;
        }
        while (this.myIndex < this.myAllAncestors.size()) {
            ProgressManager.checkCanceled();
            action.accept(this.myAllAncestors.get(this.myIndex++));
        }
        this.forEachRemaining(action);
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.myQueue.isEmpty() && !this.myAllAncestors.isEmpty() ? (long)(this.myAllAncestors.size() - this.myIndex) : -1L;
    }

    @Override
    public boolean tryAdvance(@NotNull Consumer<? super RubyContainerSymbol> action) {
        RubyContainerSymbol ancestor;
        if (action == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        if (this.myIndex < this.myAllAncestors.size()) {
            RubyContainerSymbol ancestor2 = this.myAllAncestors.get(this.myIndex++);
            action.accept(ancestor2);
            return true;
        }
        if (this.myQueue.isEmpty()) {
            if (this.mySymbol == null) {
                return false;
            }
            if (this.myAllAncestors.isEmpty()) {
                this.initializeQueue();
                return this.tryAdvance(action);
            }
            if (this.myStamp != null && this.myStamp.mayCacheNow()) {
                RubySymbolsCache.getInstance(this.myProject, this.mySearchScope).getAllAncestors().put((Object)this.mySymbol, List.copyOf(this.myAllAncestors));
            }
            return false;
        }
        Collection prependGroup = (Collection)ObjectUtils.coalesce((Object)this.myQueue.remove((Object)RubyContainerSymbolAncestor.ProcessingGroup.PREPEND), Collections.emptyList());
        if (!prependGroup.isEmpty()) {
            this.myAllAncestors.addAll(this.processGroup(prependGroup));
            return this.tryAdvance(action);
        }
        Collection selfGroup = (Collection)ObjectUtils.coalesce((Object)this.myQueue.remove((Object)RubyContainerSymbolAncestor.ProcessingGroup.SELF), Collections.emptyList());
        if (!selfGroup.isEmpty()) {
            this.myAllAncestors.addAll(selfGroup);
            return this.tryAdvance(action);
        }
        ArrayList includeExtendGroup = new ArrayList((Collection)ObjectUtils.coalesce((Object)this.myQueue.remove((Object)RubyContainerSymbolAncestor.ProcessingGroup.INCLUDE), Collections.emptyList()));
        includeExtendGroup.addAll((Collection)ObjectUtils.coalesce((Object)this.myQueue.remove((Object)RubyContainerSymbolAncestor.ProcessingGroup.EXTEND), Collections.emptyList()));
        Collection superclassGroup = (Collection)ObjectUtils.coalesce((Object)this.myQueue.remove((Object)RubyContainerSymbolAncestor.ProcessingGroup.SUPERCLASS), Collections.emptyList());
        List superclassAncestors = ContainerUtil.flatMap((Iterable)superclassGroup, superclass -> (List)ObjectUtils.coalesce((Object)((List)RecursionManager.doPreventingRecursion(List.of(this.myProject, this.mySearchScope, superclass), (boolean)false, () -> superclass.allAncestors(this.myProject, this.mySearchScope).toList())), Collections.emptyList()));
        this.myAllAncestors.addAll(this.processGroup(includeExtendGroup, it -> !this.myAllAncestors.contains(it) && !superclassAncestors.contains(it)));
        Iterator iterator = superclassAncestors.iterator();
        while (iterator.hasNext() && !(ancestor = (RubyContainerSymbol)iterator.next()).equals(this.mySymbol)) {
            this.myAllAncestors.add(ancestor);
        }
        return this.tryAdvance(action);
    }

    private void initializeQueue() {
        Ref groupRef = new Ref((Object)RubyContainerSymbolAncestor.ProcessingGroup.PREPEND);
        Objects.requireNonNull(this.mySymbol).ancestors(this.myProject, this.mySearchScope).forEach(ancestor -> {
            if (ancestor.equals(this.mySymbol)) {
                this.myQueue.putValue((Object)RubyContainerSymbolAncestor.ProcessingGroup.SELF, ancestor);
                groupRef.set((Object)RubyContainerSymbolAncestor.ProcessingGroup.INCLUDE);
            } else if (ancestor instanceof RubyClassSymbol || ancestor instanceof RubySingletonSymbol) {
                this.myQueue.putValue((Object)RubyContainerSymbolAncestor.ProcessingGroup.SUPERCLASS, ancestor);
            } else {
                this.myQueue.putValue((Object)((RubyContainerSymbolAncestor.ProcessingGroup)((Object)((Object)groupRef.get()))), ancestor);
            }
        });
    }

    @NotNull
    private List<? extends RubyContainerSymbol> processGroup(@NotNull Collection<? extends RubyContainerSymbol> group) {
        if (group == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(9);
        }
        return this.processGroup(group, it -> true);
    }

    @NotNull
    private List<? extends RubyContainerSymbol> processGroup(@NotNull Collection<? extends RubyContainerSymbol> group, @NotNull Predicate<? super RubyContainerSymbol> filter) {
        if (group == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(11);
        }
        LinkedList allAncestors = new LinkedList();
        LinkedList queue = new LinkedList(ContainerUtil.filter(group, filter::test));
        while (!queue.isEmpty()) {
            RubyContainerSymbol next;
            RubyContainerSymbol ancestor = (RubyContainerSymbol)queue.pollLast();
            List ancestors = (List)ObjectUtils.coalesce((Object)((List)RecursionManager.doPreventingRecursion(List.of(this.myProject, this.mySearchScope, ancestor), (boolean)false, () -> ancestor.allAncestors(this.myProject, this.mySearchScope).filter(filter).collect(Collectors.toList()))), Collections.emptyList());
            Iterator it = ancestors.iterator();
            int insertionIndex = 0;
            while (it.hasNext() && !(next = (RubyContainerSymbol)it.next()).equals(ancestor)) {
                int index = allAncestors.indexOf(next);
                if (index == -1) continue;
                insertionIndex = Math.max(insertionIndex, index + 1);
                it.remove();
            }
            while (it.hasNext()) {
                if (!allAncestors.contains(it.next())) continue;
                it.remove();
            }
            allAncestors.addAll(insertionIndex, ancestors);
        }
        LinkedList linkedList = allAncestors;
        if (linkedList == null) {
            RubyContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(12);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stamp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/api/RubyContainerSymbolAllAncestorsSpliterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/api/RubyContainerSymbolAllAncestorsSpliterator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forEachRemaining";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryAdvance";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processGroup";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

