/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.api;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.model.Pointer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolAllAncestorsSpliterator;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolAncestor;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolDataProvider;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.cache.RubySymbolsCache;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.util.AssertionsKt;
import org.jetbrains.plugins.ruby.ruby.model.util.RubySymbols;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public interface RubyContainerSymbol
extends RubyQualifiedNameSymbol {
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends RubyContainerSymbol> allAncestors(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyContainerSymbol.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyContainerSymbol.$$$reportNull$$$0(1);
        }
        AssertionsKt.assertBackgroundThreadIfEnabled();
        Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> cache = RubySymbolsCache.getInstance(project, searchScope).getAllAncestors();
        List cachedAncestors = (List)cache.getIfPresent((Object)this);
        if (cachedAncestors != null) {
            Stream<RubyContainerSymbol> stream = cachedAncestors.stream().peek(__ -> ProgressManager.checkCanceled());
            if (stream == null) {
                RubyContainerSymbol.$$$reportNull$$$0(2);
            }
            return stream;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Stream<RubyContainerSymbol> stream = StreamSupport.stream(new RubyContainerSymbolAllAncestorsSpliterator(project, searchScope, this, stamp), false);
        if (stream == null) {
            RubyContainerSymbol.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends RubyContainerSymbol> ancestors(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyContainerSymbol.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RubyContainerSymbol.$$$reportNull$$$0(5);
        }
        AssertionsKt.assertBackgroundThreadIfEnabled();
        Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> cache = RubySymbolsCache.getInstance(project, searchScope).getAncestors();
        List cachedAncestors = (List)cache.getIfPresent((Object)this);
        if (cachedAncestors != null) {
            Stream<RubyContainerSymbol> stream = cachedAncestors.stream().peek(__ -> ProgressManager.checkCanceled());
            if (stream == null) {
                RubyContainerSymbol.$$$reportNull$$$0(6);
            }
            return stream;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        List result = (List)RecursionManager.doPreventingRecursion(List.of(project, searchScope, this), (boolean)false, () -> {
            SortedList ancestors = new SortedList(RubyContainerSymbolAncestor.PROCESSING_ORDER_COMPARATOR);
            for (RubyContainerSymbolDataProvider provider : RubyContainerSymbolDataProvider.EP.getExtensionList()) {
                ProgressManager.checkCanceled();
                ancestors.addAll(provider.ancestors(project, searchScope, this));
            }
            @Nullable SortedList resolvedAncestors = new SortedList(Pair.comparingByFirst());
            for (RubyContainerSymbolAncestor ancestor : ancestors) {
                ProgressManager.checkCanceled();
                MultiMap queue = new MultiMap();
                for (Pair pair : resolvedAncestors) {
                    RubyContainerSymbol resolvedAncestor;
                    PsiElement element = ancestor.getElement();
                    if (element != null && element.equals((Object)((RubyContainerSymbolAncestor)pair.getFirst()).getElement()) || (resolvedAncestor = (RubyContainerSymbol)pair.getSecond()) == null || resolvedAncestor.equals(this)) continue;
                    queue.putValue((Object)((RubyContainerSymbolAncestor)pair.getFirst()).getProcessingGroup(), (Object)resolvedAncestor);
                }
                if (this instanceof RubyModuleSymbol) {
                    queue.putValue((Object)RubyContainerSymbolAncestor.ProcessingGroup.SUPERCLASS, (Object)RubySymbols.OBJECT_SYMBOL);
                }
                Stream<RubyContainerSymbol> allAncestors = StreamSupport.stream(new RubyContainerSymbolAllAncestorsSpliterator(project, searchScope, (MultiMap<RubyContainerSymbolAncestor.ProcessingGroup, RubyContainerSymbol>)queue), false);
                resolvedAncestors.add(new Pair((Object)ancestor, (Object)ancestor.resolve(allAncestors)));
            }
            return ContainerUtil.mapNotNull((Collection)resolvedAncestors, it -> (RubyContainerSymbol)it.getSecond());
        });
        List ancestors = (List)ObjectUtils.coalesce((Object)result, List.of(this));
        if (stamp.mayCacheNow()) {
            cache.put((Object)this, (Object)ancestors);
        }
        Stream<RubyContainerSymbol> stream = ancestors.stream().peek(__ -> ProgressManager.checkCanceled());
        if (stream == null) {
            RubyContainerSymbol.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends RubyQualifiedNameSymbol> constants(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyContainerSymbol.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RubyContainerSymbol.$$$reportNull$$$0(9);
        }
        AssertionsKt.assertBackgroundThreadIfEnabled();
        Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyQualifiedNameSymbol>> cache = RubySymbolsCache.getInstance(project, searchScope).getConstants();
        List cachedConstants = (List)cache.getIfPresent((Object)this);
        if (cachedConstants != null) {
            Stream stream = cachedConstants.stream();
            if (stream == null) {
                RubyContainerSymbol.$$$reportNull$$$0(10);
            }
            return stream;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        ArrayList<? extends RubyQualifiedNameSymbol> constants = new ArrayList<RubyQualifiedNameSymbol>();
        for (RubyContainerSymbolDataProvider provider : RubyContainerSymbolDataProvider.EP.getExtensionList()) {
            constants.addAll(provider.constants(project, searchScope, this));
        }
        if (stamp.mayCacheNow()) {
            cache.put((Object)this, constants);
        }
        Stream stream = constants.stream();
        if (stream == null) {
            RubyContainerSymbol.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    public Pointer<? extends RubyContainerSymbol> createPointer();

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<? extends RubyContainerSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull FQN fqn) {
        if (project == null) {
            RubyContainerSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RubyContainerSymbol.$$$reportNull$$$0(13);
        }
        if (fqn == null) {
            RubyContainerSymbol.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.softAssertReadAccess();
        AssertionsKt.assertBackgroundThreadIfEnabled();
        if (fqn == FQN.INVALID) {
            Stream stream = Stream.empty();
            if (stream == null) {
                RubyContainerSymbol.$$$reportNull$$$0(15);
            }
            return stream;
        }
        FQN normalizedFqn = fqn.normalize();
        Stream stream = StreamUtil.concatLazy(() -> RubyClassSymbol.find(project, searchScope, normalizedFqn), (Supplier[])new Supplier[]{() -> RubyModuleSymbol.find(project, searchScope, normalizedFqn)});
        if (stream == null) {
            RubyContainerSymbol.$$$reportNull$$$0(16);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 10, 11, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/api/RubyContainerSymbol";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/api/RubyContainerSymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "allAncestors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "constants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "allAncestors";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ancestors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "constants";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 10, 11, 15, 16 -> new IllegalStateException(string);
        };
    }
}

