/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.surround;

import com.intellij.lang.Language;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RSpecSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyBEGINSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyBeginEndSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyBraceSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyENDSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyIfSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyUnlessSurrounder;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubyWhileSurrounder;

public final class RubySurroundDescriptor
implements SurroundDescriptor {
    public PsiElement @NotNull [] getElementsToSurround(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement context;
        Pair<PsiElement, PsiElement> surroundCandidates;
        if (file == null) {
            RubySurroundDescriptor.$$$reportNull$$$0(0);
        }
        if ((surroundCandidates = RubySurroundDescriptor.findSurroundCandidates(file, startOffset, endOffset, (Language)RubyLanguage.INSTANCE)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                RubySurroundDescriptor.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement first = (PsiElement)surroundCandidates.first;
        PsiElement last = (PsiElement)surroundCandidates.second;
        PsiElement psiElement = context = first != last ? PsiTreeUtil.findCommonContext((PsiElement)first, (PsiElement)last) : first.getParent();
        if (context instanceof RCompoundStatement) {
            ArrayList list = new ArrayList();
            while (first.getParent() != context) {
                first = first.getParent();
            }
            while (last.getParent() != context) {
                last = last.getParent();
            }
            while (true) {
                ContainerUtil.addIfNotNull(list, (Object)first);
                if (first == null || first == last) {
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(list);
                    if (psiElementArray == null) {
                        RubySurroundDescriptor.$$$reportNull$$$0(2);
                    }
                    return psiElementArray;
                }
                first = first.getNextSibling();
            }
        }
        if (context instanceof RExpression) {
            PsiElement[] psiElementArray = new PsiElement[]{context};
            if (psiElementArray == null) {
                RubySurroundDescriptor.$$$reportNull$$$0(3);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            RubySurroundDescriptor.$$$reportNull$$$0(4);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> findSurroundCandidates(PsiFile file, int startOffset, int endOffset, Language language) {
        PsiElement element;
        PsiElement first = file.getViewProvider().findElementAt(startOffset, language);
        PsiElement last = file.getViewProvider().findElementAt(endOffset - 1, language);
        if (first == null || last == null) {
            return null;
        }
        while (RubySpaceUtil.isAnySpace((PsiElement)first) && (element = file.findElementAt(startOffset = first.getTextRange().getEndOffset())) != null) {
            first = element;
        }
        while (RubySpaceUtil.isAnySpace((PsiElement)last) && (endOffset = last.getTextRange().getStartOffset()) > 0 && (element = file.findElementAt(endOffset - 1)) != null) {
            last = element;
        }
        return Pair.create((Object)first, (Object)last);
    }

    public Surrounder @NotNull [] getSurrounders() {
        Surrounder[] surrounderArray = new Surrounder[]{new RubyBraceSurrounder(), new RubyBEGINSurrounder(), new RubyENDSurrounder(), new RubyIfSurrounder(), new RubyWhileSurrounder(), new RubyUnlessSurrounder(), new RubyBeginEndSurrounder(), new RSpecSurrounder()};
        if (surrounderArray == null) {
            RubySurroundDescriptor.$$$reportNull$$$0(5);
        }
        return surrounderArray;
    }

    public boolean isExclusive() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/surround/RubySurroundDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/surround/RubySurroundDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSurround";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

