/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navigationToolbar.StructureAwareNavBarModelExtension;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.symbol.DelegatingPsiElementWithSymbolPointer;
import com.intellij.ide.structureView.symbol.PsiSymbolTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.presentation.SymbolDeclarationPresentation;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DataSnapshot;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewFactory;
import org.jetbrains.plugins.ruby.tasks.rake.RakeIcons;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.structure.RakeStructureViewElement;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworkDetector;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.structure.RSpecStructureViewPresentationUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RubyNavBarStructureViewModel
extends StructureAwareNavBarModelExtension {
    @NotNull
    protected Language getLanguage() {
        RubyLanguage rubyLanguage = RubyLanguage.INSTANCE;
        if (rubyLanguage == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(0);
        }
        return rubyLanguage;
    }

    @Nullable
    public String getPresentableText(Object object) {
        return this.getPresentableText(object, false);
    }

    @Nullable
    @Nls
    public String getPresentableText(Object object, boolean forPopup) {
        SymbolDeclarationPresentation presentation;
        if (object instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)object;
            if (psiElement instanceof RClass) {
                if (psiElement instanceof RObjectClass) {
                    return ((RObjectClass)psiElement).getPresentableName();
                }
                return ((RClass)psiElement).getName();
            }
            if (psiElement instanceof RMethod) {
                if (psiElement instanceof RSingletonMethod) {
                    return ((RSingletonMethod)psiElement).getPresentableName(false);
                }
                return ((RMethod)psiElement).getPresentableName(false);
            }
            if (psiElement instanceof RModule) {
                return ((RModule)psiElement).getName();
            }
            if (psiElement instanceof RAliasStatement) {
                return ((RAliasStatement)psiElement).getName();
            }
            if (psiElement instanceof RField) {
                return ((RField)psiElement).getName();
            }
            if (psiElement instanceof RConstant && !(psiElement.getParent() instanceof RName)) {
                return ((RConstant)psiElement).getName();
            }
            if (psiElement instanceof RPossibleCall) {
                RPossibleCall possibleCall = (RPossibleCall)psiElement;
                if (RakeUtil.isRakeTaskCall(possibleCall)) {
                    String string;
                    RPsiElement argument = (RPsiElement)ContainerUtil.getFirstItem((List)possibleCall.getArguments());
                    if (argument instanceof RAssoc) {
                        RAssoc assoc = (RAssoc)argument;
                        string = assoc.getKeyText();
                    } else {
                        string = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
                    }
                    @NlsSafe String text = string;
                    return (String)ObjectUtils.coalesce((Object)text, (Object)RBundle.message((String)"ruby.presentation.unknown"));
                }
                if (RakeUtil.isRakeNamespaceCall(possibleCall)) {
                    @NlsSafe String text = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)possibleCall.getArguments()));
                    return (String)ObjectUtils.coalesce((Object)text, (Object)RBundle.message((String)"ruby.presentation.unknown"));
                }
                if (RSpecUtil.isFileWithRSpecTestFileName(psiElement.getContainingFile().getVirtualFile())) {
                    return RSpecStructureViewPresentationUtil.getNodePresentationInTreeMode(possibleCall).getPresentableText();
                }
                if (TestUnitUtil.isMinitestExampleGroupCall(possibleCall) || TestUnitUtil.isMinitestExampleBlockCall((RPsiElement)possibleCall) || TestUnitUtil.isMinitestBeforeAfterBlockCall((RPsiElement)possibleCall)) {
                    return (String)ObjectUtils.doIfNotNull((Object)((RPsiElement)ContainerUtil.getFirstItem((List)possibleCall.getArguments())), element -> RubyPsiUtilCore.getElementText((PsiElement)element));
                }
                if (psiElement instanceof RBlockCall) {
                    return ((RBlockCall)psiElement).getCall().getText();
                }
                if (psiElement instanceof RCall) {
                    return psiElement.getText();
                }
            }
            if (psiElement instanceof ArgumentFakePsiElement) {
                return ((ArgumentFakePsiElement)psiElement).getCall().getText();
            }
        }
        if ((presentation = RubyNavBarStructureViewModel.getSymbolDeclarationPresentation(object)) != null) {
            return presentation.getPresentableText();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(Object object) {
        RMethod rMethod;
        if (object instanceof RPossibleCall) {
            RPossibleCall possibleCall = (RPossibleCall)object;
            if (RakeUtil.isRakeTaskCall(possibleCall) || RakeStructureViewElement.canBeTaskDefinedUsingTaskClassInstantiation((PsiElement)possibleCall)) {
                return RakeIcons.RAKE_TASK_ICON;
            }
            if (RakeUtil.isRakeNamespaceCall(possibleCall)) {
                return RakeIcons.RAKE_NAMESPACE_ICON;
            }
            if (RubyTestFrameworkDetector.detectFrameworkForFile((RFile)possibleCall.getContainingFile()) == RubyTestFrameworkDetector.Result.RSPEC) {
                return RSpecStructureViewPresentationUtil.getNodePresentationInTreeMode(possibleCall).getIcon(true);
            }
            if (TestUnitUtil.isMinitestExampleGroupCall(possibleCall)) {
                return AllIcons.Nodes.TestGroup;
            }
            if (TestUnitUtil.isTestClosureCall(possibleCall) || TestUnitUtil.isMinitestExampleBlockCall((RPsiElement)possibleCall)) {
                return AllIcons.Nodes.Test;
            }
            if (TestUnitUtil.isTestClosureSetupTeardownCall(possibleCall) || TestUnitUtil.isMinitestBeforeAfterBlockCall((RPsiElement)possibleCall)) {
                return AllIcons.Nodes.Method;
            }
        }
        if (object instanceof RMethod && TestUnitUtil.isUnitTestMethod(rMethod = (RMethod)object) && rMethod.getVisibility() == Visibility.PUBLIC) {
            return AllIcons.Nodes.Test;
        }
        if (object instanceof ArgumentFakePsiElement) {
            return ((ArgumentFakePsiElement)object).getCall().getIcon(0);
        }
        SymbolDeclarationPresentation presentation = RubyNavBarStructureViewModel.getSymbolDeclarationPresentation(object);
        if (presentation != null) {
            return presentation.getIcon(false);
        }
        return null;
    }

    @Nullable
    protected PsiElement findParentInModel(@NotNull StructureViewTreeElement root, @NotNull PsiElement psiElement) {
        if (root == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(2);
        }
        PsiManager manager = psiElement.getManager();
        for (TreeElement child : this.childrenFromNodeAndProviders(root)) {
            PsiElement value = (PsiElement)ObjectUtils.tryCast((Object)((StructureViewTreeElement)child).getValue(), PsiElement.class);
            if (manager.areElementsEquivalent(value, psiElement) || value instanceof ArgumentFakePsiElement && ((ArgumentFakePsiElement)value).getCall() == psiElement || value instanceof RBlockCall && ((RBlockCall)value).getCall() == psiElement) {
                return root.getValue() instanceof PsiElement ? (PsiElement)root.getValue() : null;
            }
            PsiElement result = this.findParentInModel((StructureViewTreeElement)child, psiElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    protected StructureViewModel createModel(@NotNull PsiFile file, @Nullable Editor editor) {
        StructureViewBuilder builder2;
        if (file == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(3);
        }
        if (file instanceof RFile && (builder2 = new RubyStructureViewFactory().getStructureViewBuilder(file)) instanceof TreeBasedStructureViewBuilder) {
            StructureViewModel structureViewModel = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(editor);
            if (structureViewModel == null) {
                RubyNavBarStructureViewModel.$$$reportNull$$$0(4);
            }
            return structureViewModel;
        }
        StructureViewModel structureViewModel = super.createModel(file, editor);
        if (structureViewModel == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(5);
        }
        return structureViewModel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull DataSnapshot snapshot) {
        if (sink == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(6);
        }
        if (snapshot == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(7);
        }
        sink.lazyValue(CommonDataKeys.NAVIGATABLE, map -> {
            PsiElement psi = (PsiElement)map.get(CommonDataKeys.PSI_ELEMENT);
            if (psi instanceof DelegatingPsiElementWithSymbolPointer) {
                DelegatingPsiElementWithSymbolPointer o = (DelegatingPsiElementWithSymbolPointer)psi;
                return PsiSymbolTreeElement.getNavigatable((PsiSymbolDeclaration)RubyNavBarStructureViewModel.getSymbolDeclaration(o.getDelegate(), (Symbol)o.getSymbolPointer().dereference()));
            }
            return null;
        });
    }

    @Nullable
    public PsiElement getParent(@Nullable PsiElement psiElement) {
        if (this.isAcceptableLanguage(psiElement) && psiElement instanceof PsiFile) {
            return null;
        }
        return super.getParent(psiElement);
    }

    @Nullable
    private static PsiSymbolDeclaration getSymbolDeclaration(@Nullable PsiElement declaringElement, @Nullable Symbol declaredSymbol) {
        if (declaringElement == null || declaredSymbol == null) {
            return null;
        }
        return (PsiSymbolDeclaration)ContainerUtil.find((Iterable)PsiSymbolDeclarationService.getInstance().getDeclarations(declaringElement), it -> declaredSymbol.equals((Object)it.getSymbol()));
    }

    @Nullable
    private static SymbolDeclarationPresentation getSymbolDeclarationPresentation(@NotNull Object object) {
        if (object == null) {
            RubyNavBarStructureViewModel.$$$reportNull$$$0(8);
        }
        if (!(object instanceof DelegatingPsiElementWithSymbolPointer)) {
            return null;
        }
        DelegatingPsiElementWithSymbolPointer delegate = (DelegatingPsiElementWithSymbolPointer)object;
        Collection declarations = PsiSymbolDeclarationService.getInstance().getDeclarations(delegate.getDelegate());
        return !declarations.isEmpty() ? SymbolDeclarationPresentation.getFor((PsiSymbolDeclaration)((PsiSymbolDeclaration)ContainerUtil.getFirstItem((Collection)declarations))) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/structure/RubyNavBarStructureViewModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/structure/RubyNavBarStructureViewModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findParentInModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolDeclarationPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

