/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.structure;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.structure.StructureCallNavigationOffsetProvider;

public final class RubyMethodNavigationOffsetProvider
implements MethodNavigationOffsetProvider {
    public int[] getMethodNavigationOffsets(PsiFile file, int caretOffset) {
        if (file instanceof RFile) {
            ArrayList<PsiElement> array = new ArrayList<PsiElement>();
            RubyMethodNavigationOffsetProvider.addNavigationElements(array, (PsiElement)file);
            return MethodUpDownUtil.offsetsFromElements(array);
        }
        return null;
    }

    private static void addNavigationElements(ArrayList<PsiElement> array, PsiElement psiElement) {
        if (psiElement instanceof RMethod) {
            array.add(psiElement);
        } else if (psiElement instanceof RPossibleCall) {
            for (StructureCallNavigationOffsetProvider provider : (StructureCallNavigationOffsetProvider[])StructureCallNavigationOffsetProvider.EP_NAME.getExtensions()) {
                if (!provider.isStructureCall((RPossibleCall)psiElement)) continue;
                array.add(psiElement);
                break;
            }
        } else if (psiElement instanceof RClass || psiElement instanceof RModule) {
            array.add(psiElement);
            PsiElement last = psiElement.getLastChild();
            if (last.getNode().getElementType() == RubyTokenTypes.kEND) {
                array.add(last);
            }
        }
        List children = null;
        if (psiElement instanceof RContainer) {
            children = ((RContainer)psiElement).getStatements();
        } else if (psiElement instanceof RBlockCall) {
            for (StructureCallNavigationOffsetProvider provider : (StructureCallNavigationOffsetProvider[])StructureCallNavigationOffsetProvider.EP_NAME.getExtensions()) {
                if (!provider.processChildren((RBlockCall)psiElement)) continue;
                children = ((RBlockCall)psiElement).getBlock().getCompoundStatement().getStatements();
            }
        }
        if (children == null) {
            return;
        }
        for (PsiElement child : children) {
            if (!(child instanceof RContainer) && !(child instanceof RCall) && !(child instanceof RBlockCall)) continue;
            RubyMethodNavigationOffsetProvider.addNavigationElements(array, child);
        }
    }
}

