/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.rename;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.WriteAccess;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;

public class RubyInplaceRenamer
extends VariableInplaceRenamer {
    public RubyInplaceRenamer(PsiNamedElement elementToRename, Editor editor) {
        super(elementToRename, editor);
    }

    public void finish(boolean success) {
        super.finish(success);
        if (((TemplateManagerImpl)TemplateManager.getInstance((Project)this.myProject)).shouldSkipInTests()) {
            return;
        }
        if (success && this.hasDuplicatedVariables()) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)RBundle.message((String)"rename.already.existing.variable", (Object[])new Object[]{this.myInsertedName}), (String)"", null);
        }
    }

    private boolean hasDuplicatedVariables() {
        Instruction[] instructions;
        PsiElement psiElement = this.myScope;
        if (!(psiElement instanceof ScopeHolder)) {
            return false;
        }
        ScopeHolder holder = (ScopeHolder)psiElement;
        RControlFlow flow = holder.getControlFlow();
        for (Instruction instruction : instructions = flow.getInstructions()) {
            String name;
            if (!(instruction instanceof ReadWriteInstruction) || !(((ReadWriteInstruction)instruction).getAccess() instanceof WriteAccess) || !(name = ((ReadWriteInstruction)instruction).getName()).equals(this.myInsertedName) || this.isElementEditing(instruction)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementEditing(@NotNull Instruction instruction) {
        if (instruction == null) {
            RubyInplaceRenamer.$$$reportNull$$$0(0);
        }
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        assert (templateState != null);
        PsiElement element = instruction.getElement();
        if (element == null) {
            return true;
        }
        boolean isElementEditing = false;
        for (int i = 0; i < templateState.getSegmentsCount() && !(isElementEditing = instruction.getElement().getTextRange().equals((Object)templateState.getSegmentRange(i))); ++i) {
        }
        return isElementEditing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/ruby/ruby/lang/rename/RubyInplaceRenamer", "isElementEditing"));
    }
}

