/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.references;

import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;

final class RubyStringWebReferenceProvider
extends PsiReferenceProvider {
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("\\b(((ht|f)tp(s?))://)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");

    RubyStringWebReferenceProvider() {
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            RubyStringWebReferenceProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            RubyStringWebReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RubyStringWebReferenceProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof RStringLiteral)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                RubyStringWebReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        return RubyStringWebReferenceProvider.collectWebReferences((RStringLiteral)element);
    }

    private static PsiReference @NotNull [] collectWebReferences(@NotNull RStringLiteral stringLiteral) {
        if (stringLiteral == null) {
            RubyStringWebReferenceProvider.$$$reportNull$$$0(4);
        }
        if (!stringLiteral.textContains(':')) {
            if (PsiReference.EMPTY_ARRAY == null) {
                RubyStringWebReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = stringLiteral.getText();
        ArrayList<WebReference> references = new ArrayList<WebReference>();
        for (TextRange range : stringLiteral.getContentRanges()) {
            String contentValue = range.substring(text);
            Matcher m = HTTP_URL_PATTERN.matcher(contentValue);
            while (m.find()) {
                references.add(new WebReference((PsiElement)stringLiteral, TextRange.create((int)m.start(), (int)m.end()).shiftRight(range.getStartOffset()), m.group()));
            }
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            RubyStringWebReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/references/RubyStringWebReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/references/RubyStringWebReferenceProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectWebReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

