/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.references;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefMutableReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAliasCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallTypeImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/references/RSymbolReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "getReferencesInner", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/RSymbolImpl;", "(Lorg/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/RSymbolImpl;)[Lcom/intellij/psi/PsiReference;", "isDeclarationAt", "", "intellij.ruby.backend"})
public final class RSymbolReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(element instanceof RSymbolImpl)) {
            throw new IllegalArgumentException("Element must be instance of RSymbolImpl. Actual: " + element.getClass().getName());
        }
        Project project = ((RSymbolImpl)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        return this.getReferencesInner((RSymbolImpl)element);
    }

    private final PsiReference[] getReferencesInner(RSymbolImpl element) {
        if (I18nProvider.isLocaleFile(element.getContainingFile())) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (RAliasStatementNavigator.getAliasByName((PsiElement)((PsiElement)element), (boolean)false) != null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        RCall rCall = RCallNavigator.getByRArgument((PsiElement)((PsiElement)element));
        if (RubyPsiUtil.isCallOfType((PsiElement)rCall, RSymbolReferenceProvider::getReferencesInner$lambda$0)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (this.isDeclarationAt(element)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new ParamDefReference((PsiElement)element, new PsiReference[0])};
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[1];
        PsiReference[] psiReferenceArray2 = new PsiReference[]{new RSymbolReference.Fallback((RSymbol)element)};
        psiReferenceArray[0] = new ParamDefMutableReference((PsiElement)element, psiReferenceArray2);
        return psiReferenceArray;
    }

    private final boolean isDeclarationAt(RSymbolImpl element) {
        CollectConsumer consumer = new CollectConsumer();
        for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
            searcher.findDeclarationsAt((PsiElement)element, 0, (Consumer)consumer);
            if (consumer.getResult().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static final boolean getReferencesInner$lambda$0(RubyCallType callType) {
        return callType instanceof RubyAliasCallType || callType instanceof RubyVisibilityCallTypeImpl || callType instanceof I18nTranslateCallType;
    }
}

