/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RObjectClassImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RDocSymbolsStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RDocSymbolsStubHelper;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RubyStubSerializingElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RContainerStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RObjectClassStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.containers.RObjectClassStubImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00122\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/types/RObjectClassStubSerializingFactory;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RubyStubSerializingElementFactory;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/containers/RObjectClassStub;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/classes/RObjectClass;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "createPsi", "stub", "serialize", "", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.ruby.backend"})
public final class RObjectClassStubSerializingFactory
extends RubyStubSerializingElementFactory<RObjectClassStub, RObjectClass> {
    public RObjectClassStubSerializingFactory() {
        String string = RubyElementTypes.OBJECT_CLASS.getDebugName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
        super(string);
    }

    @NotNull
    public RObjectClassStub createStub(@NotNull RObjectClass psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        RClassObject rClassObject = psi.getObject();
        FQN classObject = rClassObject != null ? psi.getFQN() : FQN.INVALID;
        return (RObjectClassStub)new RObjectClassStubImpl(parentStub, classObject, psi.getDocumentationSymbols());
    }

    @NotNull
    public RObjectClass createPsi(@NotNull RObjectClassStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        return (RObjectClass)new RObjectClassImpl(stub);
    }

    public void serialize(@NotNull RObjectClassStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        FQN.Serialization.serialize((FQN)stub.getFQN(), (StubOutputStream)dataStream);
        RDocSymbolsStubHelper.writeSymbols((RDocSymbolsStub)stub, dataStream);
    }

    @NotNull
    public RObjectClassStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        FQN fQN = FQN.Serialization.deserialize((StubInputStream)dataStream);
        Intrinsics.checkNotNullExpressionValue((Object)fQN, (String)"deserialize(...)");
        FQN classObject = fQN;
        StubElement<?> stubElement = parentStub;
        Intrinsics.checkNotNull(stubElement);
        return (RObjectClassStub)new RObjectClassStubImpl(parentStub, classObject, RDocSymbolsStubHelper.readSymbols(stubElement, dataStream));
    }

    public void indexStub(@NotNull RObjectClassStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!Intrinsics.areEqual((Object)stub.getFQN(), (Object)FQN.INVALID)) {
            RubyResolutionIndex.sinkDocumentation((RContainerStub)((RContainerStub)stub), (IndexSink)sink);
        }
    }
}

