/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBraceBlockCallImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RDoBlockCallImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyAnonymousDefiningCallIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyIncludedExtendedFQNIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypeIndexer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RDocSymbolsStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RDocSymbolsStubHelper;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubNamespaceElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RubyStubSerializingElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.RBlockCallStubImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00032\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/types/RBlockCallStubSerializingElementFactory;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RubyStubSerializingElementFactory;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/calls/RBlockCallStub;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/iterators/RBlockCall;", "isDoBlock", "", "<init>", "(Z)V", "()Z", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getElementType", "()Lcom/intellij/psi/tree/IElementType;", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "createPsi", "stub", "serialize", "", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "shouldCreateStub", "node", "Lcom/intellij/lang/ASTNode;", "Companion", "intellij.ruby.backend"})
public final class RBlockCallStubSerializingElementFactory
extends RubyStubSerializingElementFactory<RBlockCallStub, RBlockCall> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isDoBlock;

    public RBlockCallStubSerializingElementFactory(boolean isDoBlock) {
        super(RBlockCallStubSerializingElementFactory.Companion.debugName(isDoBlock));
        this.isDoBlock = isDoBlock;
    }

    public final boolean isDoBlock() {
        return this.isDoBlock;
    }

    private final IElementType getElementType() {
        return RBlockCallStubSerializingElementFactory.Companion.elementType(this.isDoBlock);
    }

    @NotNull
    public RBlockCallStub createStub(@NotNull RBlockCall psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        RDotReference rDotReference;
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        RPossibleCall rPossibleCall = psi.getCall();
        return (RBlockCallStub)new RBlockCallStubImpl(parentStub, this.getElementType(), RubyCallTypeBase.Data.createData((RPossibleCall)((RPossibleCall)psi)), psi.getCommand(), (rDotReference = rPossibleCall instanceof RDotReference ? (RDotReference)rPossibleCall : null) != null && (rDotReference = rDotReference.getReceiver()) != null ? rDotReference.getText() : null, psi.getDocumentationSymbols());
    }

    @NotNull
    public RBlockCall createPsi(@NotNull RBlockCallStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        return this.isDoBlock ? (RBlockCall)new RDoBlockCallImpl(stub) : (RBlockCall)new RBraceBlockCallImpl(stub);
    }

    public void serialize(@NotNull RBlockCallStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        RubyCallTypeBase.Data data = stub.getCallData();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"getCallData(...)");
        RubyCallTypeBase.Data data2 = data;
        RubyCallType rubyCallType = data2.getCallType();
        Intrinsics.checkNotNullExpressionValue((Object)rubyCallType, (String)"getCallType(...)");
        RubyCallType type = rubyCallType;
        String command = stub.getCommandName();
        String id = type.getUniqueName();
        dataStream.writeName(id);
        dataStream.writeName(command);
        data2.writeStub(dataStream);
        boolean hasReceiver = stub.getReferenceReceiver() != null;
        dataStream.writeBoolean(hasReceiver);
        if (hasReceiver) {
            dataStream.writeName(stub.getReferenceReceiver());
        }
        RDocSymbolsStubHelper.writeSymbols((RDocSymbolsStub)stub, dataStream);
    }

    @NotNull
    public RBlockCallStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        RubyCallType rubyCallType;
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        String id = dataStream.readNameString();
        RubyCallTypeRegistry callTypeRegistry = RubyCallTypeRegistry.getInstance();
        if (callTypeRegistry.isPersistentId(id)) {
            String string = id;
            Intrinsics.checkNotNull((Object)string);
            RubyCallType rubyCallType2 = callTypeRegistry.findByPersistentId(string, this.getElementType());
            rubyCallType = rubyCallType2;
            Intrinsics.checkNotNullExpressionValue((Object)rubyCallType2, (String)"findByPersistentId(...)");
        } else {
            rubyCallType = UnknownRubyCallType.INSTANCE;
        }
        RubyCallType type = rubyCallType;
        String command = dataStream.readNameString();
        RubyCallTypeBase.Data data = RubyCallTypeBase.Data.readStub((RubyCallType)type, (StubInputStream)dataStream);
        boolean hasReceiver = dataStream.readBoolean();
        String receiver = hasReceiver ? dataStream.readNameString() : null;
        StubElement<?> stubElement = parentStub;
        Intrinsics.checkNotNull(stubElement);
        Map<String, DocumentationSymbol<?>> map = RDocSymbolsStubHelper.readSymbols(stubElement, dataStream);
        Intrinsics.checkNotNullExpressionValue(map, (String)"readSymbols(...)");
        Map<String, DocumentationSymbol<?>> documentationSymbols = map;
        return (RBlockCallStub)new RBlockCallStubImpl(parentStub, this.getElementType(), data, command, receiver, documentationSymbols);
    }

    public void indexStub(@NotNull RBlockCallStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        RubyCallType rubyCallType = stub.getCallData().getCallType();
        Intrinsics.checkNotNullExpressionValue((Object)rubyCallType, (String)"getCallType(...)");
        RubyCallType callType = rubyCallType;
        if (callType instanceof AnonymousDefiningCallType) {
            if (((AnonymousDefiningCallType)callType).shouldIndex(stub)) {
                Object blockCallCommand = stub.getReferenceReceiver() == null ? stub.getCommandName() : stub.getReferenceReceiver() + "." + stub.getCommandName();
                FQN receiver = RubyIncludeExtendCallTypeIndexer.getReceiverFromContainingMethod((RStubElement)stub, (String)blockCallCommand);
                if (receiver == null) {
                    RStubElement rStubElement = (RStubElement)stub;
                    String string = stub.getReferenceReceiver() == null ? "" : stub.getReferenceReceiver();
                    Intrinsics.checkNotNull((Object)string);
                    receiver = RStubNamespaceElement.getFQNForStub((RStubElement)rStubElement, (String)string);
                }
                if (Intrinsics.areEqual((Object)receiver.getCallerFQN().getShortName(), (Object)"$$HOOK$$")) {
                    RubyIncludedExtendedFQNIndex.sink((FQN)receiver, (IndexSink)sink);
                } else {
                    sink.occurrence(RubyAnonymousDefiningCallIndex.KEY, (Object)receiver.getFullPath());
                }
            }
            sink.occurrence(RubyAnonymousDefiningCallIndex.KEY, (Object)stub.getFQNWithNesting().getFullPath());
        }
        if (stub.isValidNamespace()) {
            RubyResolutionIndex.sinkDocumentation((RBlockCallStub)stub, (IndexSink)sink);
        }
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall");
        return Companion.shouldCreateStubForBlockCall((RBlockCall)psiElement);
    }

    @JvmStatic
    public static final boolean shouldCreateStubForBlockCall(@Nullable RBlockCall call) {
        return Companion.shouldCreateStubForBlockCall(call);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/types/RBlockCallStubSerializingElementFactory$Companion;", "", "<init>", "()V", "debugName", "", "isDoBlock", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "shouldCreateStubForBlockCall", "call", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/iterators/RBlockCall;", "intellij.ruby.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final String debugName(boolean isDoBlock) {
            String string = this.elementType(isDoBlock).getDebugName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
            return string;
        }

        private final IElementType elementType(boolean isDoBlock) {
            IElementType iElementType;
            if (isDoBlock) {
                RubyElementType rubyElementType = RubyElementTypes.DO_BLOCK_CALL;
                Intrinsics.checkNotNullExpressionValue((Object)rubyElementType, (String)"DO_BLOCK_CALL");
                iElementType = (IElementType)rubyElementType;
            } else {
                RubyElementType rubyElementType = RubyElementTypes.BRACE_BLOCK_CALL;
                Intrinsics.checkNotNullExpressionValue((Object)rubyElementType, (String)"BRACE_BLOCK_CALL");
                iElementType = (IElementType)rubyElementType;
            }
            return iElementType;
        }

        @JvmStatic
        public final boolean shouldCreateStubForBlockCall(@Nullable RBlockCall call) {
            if (call == null) {
                return false;
            }
            RPossibleCall rPossibleCall = call.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)rPossibleCall, (String)"getCall(...)");
            RPossibleCall possibleCall = rPossibleCall;
            if (possibleCall.getCallType().isPersistent()) {
                return true;
            }
            return RContainerUtil.isContextChangingBlockCall(call);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

