/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.AccessType;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMember;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMethodImpl;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMethodSymbolArguments;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElementSerializationHelper;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElementSerializationHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.AnnotationsHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RDocSymbolsStub;

public final class RDocSymbolsStubHelper {
    public static void writeSymbols(@NotNull RDocSymbolsStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(0);
        }
        if (dataStream == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(1);
        }
        Collection symbols = stub.getDocumentationSymbols().values();
        dataStream.writeVarInt(symbols.size());
        for (DocumentationSymbol symbol : symbols) {
            RDocSymbolsStubHelper.writeSymbol(symbol, dataStream);
        }
    }

    @NotNull
    public static Map<String, DocumentationSymbol<?>> readSymbols(@NotNull StubElement parentStub, @NotNull StubInputStream dataStream) throws IOException {
        int size;
        if (parentStub == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(3);
        }
        if ((size = dataStream.readVarInt()) == 0) {
            Map<String, DocumentationSymbol<?>> map = Collections.emptyMap();
            if (map == null) {
                RDocSymbolsStubHelper.$$$reportNull$$$0(4);
            }
            return map;
        }
        LinkedHashMap result = new LinkedHashMap();
        for (int i = 0; i < size; ++i) {
            DocumentationSymbol symbol = RDocSymbolsStubHelper.readSymbol(parentStub, dataStream);
            result.put(symbol.getName(), symbol);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    private static void writeSymbol(@NotNull DocumentationSymbol documentationSymbol, @NotNull StubOutputStream dataStream) throws IOException {
        if (documentationSymbol == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(6);
        }
        if (dataStream == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(7);
        }
        for (DocumentationSymbolType type : DocumentationSymbolType.values()) {
            if (documentationSymbol.getClass() != type.getClazz()) continue;
            dataStream.writeByte(type.getId());
            type.getSerializationHelper().serialize(documentationSymbol, dataStream);
        }
    }

    @NotNull
    private static DocumentationSymbol readSymbol(@NotNull StubElement parentStub, @NotNull StubInputStream dataStream) throws IOException {
        if (parentStub == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(8);
        }
        if (dataStream == null) {
            RDocSymbolsStubHelper.$$$reportNull$$$0(9);
        }
        byte typeId = dataStream.readByte();
        for (DocumentationSymbolType symbolType : DocumentationSymbolType.values()) {
            if (typeId != symbolType.getId()) continue;
            DocumentationSymbol documentationSymbol = symbolType.getSerializationHelper().deSerialize(parentStub, dataStream);
            if (documentationSymbol == null) {
                RDocSymbolsStubHelper.$$$reportNull$$$0(10);
            }
            return documentationSymbol;
        }
        throw new AssertionError((Object)"could not find id for this DocumentationSymbol");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readSymbols";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSymbols";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSymbols";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeSymbol";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10 -> new IllegalStateException(string);
        };
    }

    private static enum DocumentationSymbolType {
        DOCUMENTATION_MEMBER(0, DocumentationMember.class, new DocumentationMemberSerializationHelper()),
        DOCUMENTATION_METHOD(1, DocumentationMethodImpl.class, new DocumentationMethodSerializationHelper());

        private final int myId;
        @NotNull
        private final Class<? extends DocumentationSymbol> myClass;
        @NotNull
        private final DocumentationSymbolSerializationHelper<? extends DocumentationSymbol> mySerializationHelper;

        private DocumentationSymbolType(@NotNull int id, Class<? extends DocumentationSymbol> clazz, DocumentationSymbolSerializationHelper<? extends DocumentationSymbol> serializationHelper) {
            if (clazz == null) {
                DocumentationSymbolType.$$$reportNull$$$0(0);
            }
            if (serializationHelper == null) {
                DocumentationSymbolType.$$$reportNull$$$0(1);
            }
            this.myId = id;
            this.myClass = clazz;
            this.mySerializationHelper = serializationHelper;
        }

        public int getId() {
            return this.myId;
        }

        @NotNull
        public Class<? extends DocumentationSymbol> getClazz() {
            Class<? extends DocumentationSymbol> clazz = this.myClass;
            if (clazz == null) {
                DocumentationSymbolType.$$$reportNull$$$0(2);
            }
            return clazz;
        }

        @NotNull
        public DocumentationSymbolSerializationHelper<?> getSerializationHelper() {
            DocumentationSymbolSerializationHelper<? extends DocumentationSymbol> documentationSymbolSerializationHelper = this.mySerializationHelper;
            if (documentationSymbolSerializationHelper == null) {
                DocumentationSymbolType.$$$reportNull$$$0(3);
            }
            return documentationSymbolSerializationHelper;
        }

        private static int getSymbolType(@NotNull Type type) {
            if (type == null) {
                DocumentationSymbolType.$$$reportNull$$$0(4);
            }
            if (type == Type.INSTANCE_METHOD) {
                return 0;
            }
            if (type == Type.CLASS_METHOD) {
                return 1;
            }
            if (type == Type.FIELD_READER) {
                return 2;
            }
            if (type == Type.FIELD_WRITER) {
                return 3;
            }
            throw new IllegalArgumentException("Unsupported serialization type: " + String.valueOf(type));
        }

        @NotNull
        private static Type getSymbolType(int type) {
            Type type2 = switch (type) {
                case 0 -> Type.INSTANCE_METHOD;
                case 1 -> Type.CLASS_METHOD;
                case 2 -> Type.FIELD_READER;
                case 3 -> Type.FIELD_WRITER;
                default -> throw new IllegalArgumentException("Unsupported deserialization type: " + type);
            };
            if (type2 == null) {
                DocumentationSymbolType.$$$reportNull$$$0(5);
            }
            return type2;
        }

        @NotNull
        private static AccessType getAccessType(@Nullable String type) {
            if (type == null) {
                Logger.getInstance(DocumentationSymbolType.class).warn((Throwable)new IllegalStateException("corrupted stub"));
                AccessType accessType = AccessType.ACCESSOR;
                if (accessType == null) {
                    DocumentationSymbolType.$$$reportNull$$$0(6);
                }
                return accessType;
            }
            AccessType accessType = AccessType.valueOf((String)type);
            if (accessType == null) {
                DocumentationSymbolType.$$$reportNull$$$0(7);
            }
            return accessType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serializationHelper";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper$DocumentationSymbolType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper$DocumentationSymbolType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClazz";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSerializationHelper";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbolType";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSymbolType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 6, 7 -> new IllegalStateException(string);
            };
        }

        private static class DocumentationMemberSerializationHelper
        extends DocumentationSymbolSerializationHelper<DocumentationMember> {
            private DocumentationMemberSerializationHelper() {
            }

            @Override
            public void doSerialize(@NotNull DocumentationMember symbol, @NotNull StubOutputStream dataStream) throws IOException {
                if (symbol == null) {
                    DocumentationMemberSerializationHelper.$$$reportNull$$$0(0);
                }
                if (dataStream == null) {
                    DocumentationMemberSerializationHelper.$$$reportNull$$$0(1);
                }
                RangeInDocumentFakePsiElementSerializationHelper.INSTANCE.doSerializeNullable(symbol.getPsiElement(), dataStream);
                dataStream.writeName(symbol.getName());
                dataStream.writeByte(DocumentationSymbolType.getSymbolType(symbol.getType()));
                SerializableTypeUtil.serialize((StubOutputStream)dataStream, (SerializableType)symbol.getReturnType());
                dataStream.writeName(symbol.getAccessType().name());
            }

            @Override
            @NotNull
            public DocumentationMember doDeSerialize(@NotNull StubElement parentStub, @NotNull StubInputStream dataStream) throws IOException {
                if (parentStub == null) {
                    DocumentationMemberSerializationHelper.$$$reportNull$$$0(2);
                }
                if (dataStream == null) {
                    DocumentationMemberSerializationHelper.$$$reportNull$$$0(3);
                }
                RangeInDocumentFakePsiElement psiElement = RangeInDocumentFakePsiElementSerializationHelper.INSTANCE.doDeSerializeNullable(parentStub, dataStream);
                String name = Objects.requireNonNull(dataStream.readNameString());
                Type type = DocumentationSymbolType.getSymbolType(dataStream.readByte());
                SerializableType returnType = SerializableTypeUtil.deserialize((StubInputStream)dataStream);
                AccessType accessType = DocumentationSymbolType.getAccessType(dataStream.readNameString());
                return new DocumentationMember(psiElement, name, type, returnType, accessType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataStream";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentStub";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper$DocumentationSymbolType$DocumentationMemberSerializationHelper";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doSerialize";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doDeSerialize";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class DocumentationMethodSerializationHelper
        extends DocumentationSymbolSerializationHelper<DocumentationMethodImpl> {
            private DocumentationMethodSerializationHelper() {
            }

            @Override
            public void doSerialize(@NotNull DocumentationMethodImpl symbol, @NotNull StubOutputStream dataStream) throws IOException {
                if (symbol == null) {
                    DocumentationMethodSerializationHelper.$$$reportNull$$$0(0);
                }
                if (dataStream == null) {
                    DocumentationMethodSerializationHelper.$$$reportNull$$$0(1);
                }
                RangeInDocumentFakePsiElementSerializationHelper.INSTANCE.doSerializeNullable(symbol.getPsiElement(), dataStream);
                MethodNameFakePsiElementSerializationHelper.INSTANCE.doSerializeNullable((PsiElement)symbol.getNameElement(), dataStream);
                dataStream.writeUTFFast(symbol.getName());
                dataStream.writeByte(DocumentationSymbolType.getSymbolType(symbol.getType()));
                DocumentationMethodSymbolArguments arguments = symbol.getArguments();
                int size = arguments.getArgumentInfos().size();
                dataStream.writeVarInt(size);
                for (ArgumentInfo argumentInfo : arguments.getArgumentInfos()) {
                    argumentInfo.serialize(dataStream);
                }
                if (arguments.getArgumentElements() == null) {
                    dataStream.writeVarInt(0);
                } else {
                    dataStream.writeVarInt(arguments.getArgumentElements().size());
                    for (RangeInDocumentFakePsiElement element : arguments.getArgumentElements()) {
                        RangeInDocumentFakePsiElementSerializationHelper.INSTANCE.doSerialize((PsiElement)element, dataStream);
                    }
                }
                AnnotationsHelper.serialize(symbol.getAnnotationData(), dataStream);
            }

            @Override
            @NotNull
            public DocumentationMethodImpl doDeSerialize(@NotNull StubElement parentStub, @NotNull StubInputStream dataStream) throws IOException {
                if (parentStub == null) {
                    DocumentationMethodSerializationHelper.$$$reportNull$$$0(2);
                }
                if (dataStream == null) {
                    DocumentationMethodSerializationHelper.$$$reportNull$$$0(3);
                }
                RangeInDocumentFakePsiElement psiElement = RangeInDocumentFakePsiElementSerializationHelper.INSTANCE.doDeSerializeNullable(parentStub, dataStream);
                MethodNameFakePsiElement nameElement = MethodNameFakePsiElementSerializationHelper.INSTANCE.doDeSerializeNullable(parentStub, dataStream);
                String name = dataStream.readUTFFast();
                Type type = DocumentationSymbolType.getSymbolType(dataStream.readByte());
                ArrayList<ArgumentInfo> arguments = new ArrayList<ArgumentInfo>();
                int size = dataStream.readVarInt();
                for (int i = 0; i < size; ++i) {
                    arguments.add(ArgumentInfo.deserialize((StubInputStream)dataStream));
                }
                ArrayList<RangeInDocumentFakePsiElement> argumentElements = new ArrayList<RangeInDocumentFakePsiElement>();
                int elementsSize = dataStream.readVarInt();
                for (int i = 0; i < elementsSize; ++i) {
                    argumentElements.add(RangeInDocumentFakePsiElementSerializationHelper.INSTANCE.doDeSerialize(parentStub, dataStream));
                }
                MethodAnnotationData annotationData = AnnotationsHelper.deserialize(parentStub, dataStream);
                return new DocumentationMethodImpl(psiElement, nameElement, name, type, new DocumentationMethodSymbolArguments(arguments, argumentElements), annotationData);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataStream";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentStub";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper$DocumentationSymbolType$DocumentationMethodSerializationHelper";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doSerialize";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doDeSerialize";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static abstract class DocumentationSymbolSerializationHelper<T extends DocumentationSymbol> {
        private DocumentationSymbolSerializationHelper() {
        }

        public void serialize(@NotNull DocumentationSymbol symbol, @NotNull StubOutputStream dataStream) throws IOException {
            if (symbol == null) {
                DocumentationSymbolSerializationHelper.$$$reportNull$$$0(0);
            }
            if (dataStream == null) {
                DocumentationSymbolSerializationHelper.$$$reportNull$$$0(1);
            }
            this.doSerialize(symbol, dataStream);
        }

        @NotNull
        public DocumentationSymbol deSerialize(@NotNull StubElement parentStub, @NotNull StubInputStream dataStream) throws IOException {
            if (parentStub == null) {
                DocumentationSymbolSerializationHelper.$$$reportNull$$$0(2);
            }
            if (dataStream == null) {
                DocumentationSymbolSerializationHelper.$$$reportNull$$$0(3);
            }
            T t = this.doDeSerialize(parentStub, dataStream);
            if (t == null) {
                DocumentationSymbolSerializationHelper.$$$reportNull$$$0(4);
            }
            return t;
        }

        public abstract void doSerialize(@NotNull T var1, @NotNull StubOutputStream var2) throws IOException;

        public abstract T doDeSerialize(@NotNull StubElement var1, @NotNull StubInputStream var2) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataStream";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentStub";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper$DocumentationSymbolSerializationHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RDocSymbolsStubHelper$DocumentationSymbolSerializationHelper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deSerialize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "serialize";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deSerialize";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

