/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;

final class RequireArgumentsEvaluator {
    private RequireArgumentsEvaluator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String evaluateRequireArg(@Nullable VirtualFile file, @Nullable PsiElement element) {
        String evaluatedFirstArg;
        RPsiElement toEvaluate;
        String cmdText;
        RBinaryExpression binaryExpression;
        if (element == null) {
            return null;
        }
        if (RequireArgumentsEvaluator.isSimpleString(element)) {
            return ((RBaseString)element).getContent().trim();
        }
        if (element instanceof RIntegerConstant) {
            return element.getText();
        }
        if (element instanceof RPseudoConstant && "__FILE__".equals(element.getText())) {
            if (file == null) return null;
            String string = file.getPath();
            return string;
        }
        if (RequireArgumentsEvaluator.isFileDIRNAME(element)) {
            return RequireArgumentsEvaluator.getFileParentDirPath(file);
        }
        if (element instanceof RBinaryExpression && (binaryExpression = (RBinaryExpression)element).getOperationType() == RubyTokenTypes.tPLUS) {
            String left = RequireArgumentsEvaluator.evaluateRequireArg(file, (PsiElement)binaryExpression.getLeftOperand());
            if (left == null) return null;
            String right = RequireArgumentsEvaluator.evaluateRequireArg(file, (PsiElement)binaryExpression.getRightOperand());
            if (right == null) return null;
            return left + right;
        }
        if (element instanceof RCall && ("File.join".equals(cmdText = ((RCall)element).getCommand().trim()) || "File.expand_path".equals(cmdText) || "File.absolute_path".equals(cmdText))) {
            ArrayList<String> pathComponents = new ArrayList<String>();
            for (RPsiElement arg : ((RCall)element).getArguments()) {
                String s = RequireArgumentsEvaluator.evaluateRequireArg(file, (PsiElement)arg);
                if (s == null) {
                    return null;
                }
                pathComponents.add(s);
            }
            if (!"File.expand_path".equals(cmdText)) {
                if (!"File.absolute_path".equals(cmdText)) return StringUtil.join(pathComponents, (String)"/");
            }
            if (pathComponents.size() > 2) {
                return null;
            }
            Collections.reverse(pathComponents);
            return StringUtil.join(pathComponents, (String)"/");
        }
        if (!(element instanceof RStringLiteral)) return null;
        RStringLiteral stringRequirement = (RStringLiteral)element;
        List substitutions = stringRequirement.getExpressionSubstitutions();
        if (substitutions.size() != 1) return null;
        RExpressionSubstitution firstSubstitution = (RExpressionSubstitution)substitutions.get(0);
        RCompoundStatement statement = firstSubstitution.getCompoundStatement();
        List statements = statement != null ? statement.getStatements() : null;
        RPsiElement rPsiElement = toEvaluate = statements == null || statements.isEmpty() ? null : (RPsiElement)statements.get(statements.size() - 1);
        if (toEvaluate instanceof RIdentifier) {
            RIdentifier identifier = (RIdentifier)toEvaluate;
            if (!identifier.isLocalVariable()) return null;
            evaluatedFirstArg = RequireArgumentsEvaluator.evalSubstitution(stringRequirement, (RPsiElement)identifier);
        } else if (toEvaluate instanceof RConstant) {
            evaluatedFirstArg = RequireArgumentsEvaluator.evalSubstitution(stringRequirement, toEvaluate);
        } else if (toEvaluate instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)toEvaluate;
            evaluatedFirstArg = RequireArgumentsEvaluator.evaluateRequireArg(file, (PsiElement)assignment.getValue());
        } else {
            evaluatedFirstArg = RequireArgumentsEvaluator.evaluateRequireArg(file, (PsiElement)toEvaluate);
        }
        if (evaluatedFirstArg == null) return null;
        List content = stringRequirement.getPsiContent();
        StringBuilder buff = new StringBuilder();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            PsiElement psiElement = (PsiElement)iterator.next();
            if (psiElement == firstSubstitution) {
                buff.append(evaluatedFirstArg);
                continue;
            }
            buff.append(psiElement.getText());
        }
        return buff.toString();
    }

    public static boolean startOffsetOutOfScopeBounds(@NotNull PsiElement psiElement, int scopeEndBound) {
        if (psiElement == null) {
            RequireArgumentsEvaluator.$$$reportNull$$$0(0);
        }
        return scopeEndBound != -1 && psiElement.getTextRange().getStartOffset() >= scopeEndBound;
    }

    public static boolean endOffsetOutOfScopeBounds(@NotNull PsiElement psiElement, int scopeEndBound) {
        if (psiElement == null) {
            RequireArgumentsEvaluator.$$$reportNull$$$0(1);
        }
        return scopeEndBound != -1 && psiElement.getTextRange().getEndOffset() >= scopeEndBound;
    }

    @Nullable
    public static String evalSubstitution(@NotNull RStringLiteral stringRequirement, @NotNull RPsiElement localVariableOrConstant) {
        RContainer scopeHolder;
        if (stringRequirement == null) {
            RequireArgumentsEvaluator.$$$reportNull$$$0(2);
        }
        if (localVariableOrConstant == null) {
            RequireArgumentsEvaluator.$$$reportNull$$$0(3);
        }
        if ((scopeHolder = localVariableOrConstant.getParentContainer()) == null) {
            return null;
        }
        int localVariableOffset = localVariableOrConstant.getTextRange().getStartOffset();
        String name = localVariableOrConstant.getName();
        assert (name != null);
        List elements = scopeHolder.getStatements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            RPsiElement currentElement = (RPsiElement)elements.get(i);
            Ref<String> evaluatedValue = RequireArgumentsEvaluator.findEndEvaluateAssignmentIn((PsiElement)currentElement, name, localVariableOffset, stringRequirement);
            if (evaluatedValue == null) continue;
            return (String)evaluatedValue.get();
        }
        return null;
    }

    @Nullable
    public static Ref<String> findEndEvaluateAssignmentIn(PsiElement currentElement, String name, int scopeEndBound, RStringLiteral stringRequirement) {
        if (!(currentElement instanceof RPsiElement) || currentElement instanceof RBlockCall || currentElement instanceof RCompoundStatement) {
            return null;
        }
        if (RequireArgumentsEvaluator.startOffsetOutOfScopeBounds(currentElement, scopeEndBound)) {
            return null;
        }
        if (currentElement instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)currentElement;
            if (RequireArgumentsEvaluator.endOffsetOutOfScopeBounds((PsiElement)assignment, scopeEndBound)) {
                return null;
            }
            RPsiElement assignmentObject = assignment.getObject();
            if ((assignmentObject instanceof RConstant || assignmentObject instanceof RIdentifier) && name.equals(assignmentObject.getName())) {
                RPsiElement target = assignment.getValue();
                if (target == null) {
                    return null;
                }
                VirtualFile file = stringRequirement.getContainingFile().getVirtualFile();
                String targetStringValue = RequireArgumentsEvaluator.evaluateRequireArg(file, (PsiElement)target);
                return new Ref((Object)targetStringValue);
            }
        }
        PsiElement[] children = currentElement.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            PsiElement child = children[i];
            Ref<String> result = RequireArgumentsEvaluator.findEndEvaluateAssignmentIn(child, name, scopeEndBound, stringRequirement);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static String getFileParentDirPath(VirtualFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile parentDir = file.getParent();
        return parentDir == null ? null : parentDir.getPath();
    }

    public static boolean isFileDIRNAME(PsiElement requirement) {
        return "File.dirname(__FILE__)".equals(requirement.getText().replace(" ", ""));
    }

    public static boolean isSimpleString(PsiElement requirement) {
        return requirement instanceof RBaseString && ((RBaseString)requirement).getExpressionSubstitutions().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringRequirement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariableOrConstant";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RequireArgumentsEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startOffsetOutOfScopeBounds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "endOffsetOutOfScopeBounds";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "evalSubstitution";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

