/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbFileImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FileRequireCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RequiresIndexExtension;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.lang.CommonTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiFileBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RStubBasedPsiElementBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RStubBasedContainerBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RequireArgumentsEvaluator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RPossibleCallImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyFileCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RCodeBlockStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class RFileUtil {
    private static final Logger LOG = Logger.getInstance(RFileUtil.class);
    private static final boolean EVALUATE_ALL_REQUIRES = RubyVMOptions.evaluateAllRequires();
    private static final int FILES_TO_PROBE_CACHE_SIZE_THRESHOLD = 5;
    private static final Key<Trinity<String, String, List<String>>> FILE_REQUIRE_PATH_KEY = Key.create((String)"ruby.file.require.path.key");

    private RFileUtil() {
    }

    @NotNull
    public static Object2IntMap<VirtualFile> createMapByLoadpath(@NotNull Collection<? extends VirtualFile> loadPath) {
        if (loadPath == null) {
            RFileUtil.$$$reportNull$$$0(0);
        }
        Object2IntOpenHashMap myLoadPath = new Object2IntOpenHashMap();
        int i = 1;
        for (VirtualFile virtualFile : loadPath) {
            myLoadPath.put((Object)virtualFile, i++);
        }
        Object2IntOpenHashMap object2IntOpenHashMap = myLoadPath;
        if (object2IntOpenHashMap == null) {
            RFileUtil.$$$reportNull$$$0(1);
        }
        return object2IntOpenHashMap;
    }

    @NotNull
    public static List<RequireInfo> calculateRequireInfos(@NotNull VirtualFile virtualFile, @NotNull RPsiFileBase psiFile) {
        if (virtualFile == null) {
            RFileUtil.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            RFileUtil.$$$reportNull$$$0(3);
        }
        List<RequireInfo> list = RFileUtil.collectRequires((RContainer)psiFile).stream().map(call -> {
            String evaluatedPath = RFileUtil.getRequirePath(virtualFile, call);
            if (evaluatedPath == null) {
                return null;
            }
            RubyCallType callType = call.getCallType();
            String prefix = callType instanceof RubyFileCallType ? ((RubyFileCallType)callType).getPrefix() : null;
            boolean isRelative = callType == RubyCallTypesCore.REQUIRE_RELATIVE_CALL;
            return new RequireInfo(RFileUtil.appendPrefix(evaluatedPath, prefix), isRelative);
        }).filter(it -> it != null).collect(Collectors.toList());
        if (list == null) {
            RFileUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static List<RCall> collectRequires(RContainer container) {
        StubElement stub;
        final ArrayList<RCall> requires = new ArrayList<RCall>();
        StubElement stubElement = stub = container instanceof RPsiFileBase ? ((RPsiFileBase)container).getGreenStub() : ((RStubBasedContainerBase)container).getGreenStub();
        if (stub != null) {
            List structureElements = container.getStructureElements();
            for (RPsiStructureElement structureElement : structureElements) {
                if (structureElement instanceof RCall && ((RCall)structureElement).getCallType() instanceof RubyFileCallType) {
                    requires.add((RCall)structureElement);
                }
                if (!(structureElement instanceof RContainer)) continue;
                requires.addAll(RFileUtil.collectRequires((RContainer)structureElement));
            }
        } else {
            container.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                public void visitRCall(@NotNull RCall call) {
                    RubyCallType callType;
                    if (call == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((callType = call.getCallType()) instanceof RubyFileCallType) {
                        requires.add(call);
                    }
                }

                public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
                    RubyCallType callType;
                    if (arrayIndexing == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((callType = arrayIndexing.getCallType()) instanceof RubyFileCallType) {
                        requires.add(arrayIndexing);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "call";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "arrayIndexing";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RFileUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRCall";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRArrayIndexing";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return requires;
    }

    @NotNull
    public static @NotNull List<@NotNull RequireInfo> computeRequires(@NotNull RFile rFile) {
        if (rFile == null) {
            RFileUtil.$$$reportNull$$$0(5);
        }
        if (rFile instanceof ErbFileImpl) {
            ErbFileImpl erbRubyFile = (ErbFileImpl)rFile;
            return RFileUtil.computeRequires(erbRubyFile.getInnerRubyFile());
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rFile);
        if (virtualFile == null) {
            List<RequireInfo> list = Collections.emptyList();
            if (list == null) {
                RFileUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (virtualFile instanceof VirtualFileWithId && !Registry.is((String)"ruby.disable.require.processing", (boolean)true)) {
            List<RequireInfo> list = RequiresIndexExtension.getValue(rFile.getProject(), virtualFile);
            if (list == null) {
                RFileUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        return RFileUtil.calculateRequireInfos(virtualFile, (RPsiFileBase)rFile);
    }

    public static RFileUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @NotNull
    public static Collection<? extends VirtualFile> getFilesByRPsiElement(@NotNull RFile file, boolean relativeToDirectory, @NotNull RPsiElement requirement, @Nullable String pathPrefix) {
        if (file == null) {
            RFileUtil.$$$reportNull$$$0(8);
        }
        if (requirement == null) {
            RFileUtil.$$$reportNull$$$0(9);
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file);
        VirtualFile parentDirectory = (VirtualFile)ObjectUtils.doIfNotNull((Object)virtualFile, VirtualFile::getParent);
        return RFileUtil.findFilesForName(file.getProject(), RFileUtil.appendPrefix(RFileUtil.evaluateRequirement(virtualFile, (PsiElement)requirement), pathPrefix), RFileUtil.createMapByLoadpath(LoadPathUtil.getLoadPath((RTopLevelContainer)file)), parentDirectory, relativeToDirectory, null);
    }

    @Nullable
    public static String evaluateRequirement(@Nullable VirtualFile file, @Nullable PsiElement requirement) {
        String value;
        try {
            value = RequireArgumentsEvaluator.evaluateRequireArg(file, requirement);
        }
        catch (StackOverflowError e) {
            Object msg = "SOE during requirement evaluation. Diagnostic info:\n";
            if (file != null) {
                msg = (String)msg + "File: " + file.getPath() + "\n";
            }
            if (requirement != null) {
                msg = (String)msg + "Require argument:\n" + requirement.getText();
            }
            LOG.error((String)msg, (Throwable)e);
            return null;
        }
        return value;
    }

    @Contract(value="!null, !null -> !null")
    public static String appendPrefix(@Nullable String name, @Nullable String prefix) {
        if (name != null && prefix != null) {
            return prefix + name;
        }
        return name;
    }

    @NotNull
    public static Collection<? extends VirtualFile> findFilesForName(@NotNull Project project, @Nullable String filePath, @NotNull Object2IntMap<VirtualFile> loadPath, @Nullable VirtualFile parentDirectory, boolean relativeToDirectory, @Nullable Map<String, Collection<VirtualFile>> filesToProbeCache) {
        if (project == null) {
            RFileUtil.$$$reportNull$$$0(10);
        }
        if (loadPath == null) {
            RFileUtil.$$$reportNull$$$0(11);
        }
        if (filePath == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                RFileUtil.$$$reportNull$$$0(12);
            }
            return set;
        }
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        if (relativeToDirectory) {
            if (filePath.indexOf(47) == 0) {
                filePath = filePath.substring(1);
            }
            RFileUtil.addFileRelativeTo(parentDirectory, filePath, files);
        } else {
            if (filePath.startsWith("../")) {
                RFileUtil.addFileRelativeTo(parentDirectory, filePath.substring("../".length()), files);
            }
            if (!RFileUtil.addFileAbs(filePath, files, (VirtualFileSystem)(parentDirectory != null ? parentDirectory.getFileSystem() : LocalFileSystem.getInstance()))) {
                if (parentDirectory != null && !parentDirectory.equals(project.getBaseDir())) {
                    RFileUtil.addFileRelativeTo(parentDirectory, filePath, files);
                }
                if (parentDirectory != null && !filePath.contains("../")) {
                    String name2LookUp = filePath;
                    files.addAll(FileRequireCache.getInstance(project).findFilesUnderLoadPath(loadPath, filePath, (Computable<Collection<VirtualFile>>)((Computable)() -> RFileUtil.findUnderLoadPathReverse(project, loadPath, name2LookUp, filesToProbeCache))));
                }
            }
        }
        LinkedHashSet<VirtualFile> linkedHashSet = files;
        if (linkedHashSet == null) {
            RFileUtil.$$$reportNull$$$0(13);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<VirtualFile> findUnderLoadPathReverse(@NotNull Project project, @NotNull Object2IntMap<VirtualFile> loadPath, @NotNull String relativePath, @Nullable Map<String, Collection<VirtualFile>> filesToProbeCache) {
        String fileName;
        if (project == null) {
            RFileUtil.$$$reportNull$$$0(14);
        }
        if (loadPath == null) {
            RFileUtil.$$$reportNull$$$0(15);
        }
        if (relativePath == null) {
            RFileUtil.$$$reportNull$$$0(16);
        }
        if ((fileName = VfsUtil.extractFileName((String)relativePath)) == null) {
            fileName = relativePath;
        }
        String pathToFile = relativePath.substring(0, relativePath.length() - fileName.length());
        Collection<VirtualFile> filesToProbe = RFileUtil.getFilesToProbe(project, fileName, filesToProbeCache);
        List pathParts = StringUtil.split((String)FileUtil.toCanonicalPath((String)pathToFile), (String)"/");
        List list = (List)((StreamEx)((StreamEx)StreamEx.of(filesToProbe).map(file -> {
            int index;
            VirtualFile parent = VirtualFileUtil.getAncestorByRelativePath(file.getParent(), pathParts);
            if (parent != null && (index = loadPath.getInt((Object)parent)) > 0) {
                return Pair.create((Object)index, (Object)file);
            }
            return null;
        }).filter(Objects::nonNull)).sorted(Comparator.comparingInt(o -> (Integer)o.first))).collapse((p1, p2) -> ((Integer)p1.first).equals(p2.first)).map(pair -> (VirtualFile)pair.getSecond()).collect(Collectors.toList());
        if (list == null) {
            RFileUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static Collection<VirtualFile> getFilesToProbe(@NotNull Project project, @NotNull String fileName, @Nullable Map<String, Collection<VirtualFile>> filesToProbeCache) {
        if (project == null) {
            RFileUtil.$$$reportNull$$$0(18);
        }
        if (fileName == null) {
            RFileUtil.$$$reportNull$$$0(19);
        }
        if (filesToProbeCache != null && filesToProbeCache.containsKey(fileName)) {
            Collection<VirtualFile> collection = filesToProbeCache.get(fileName);
            if (collection == null) {
                RFileUtil.$$$reportNull$$$0(20);
            }
            return collection;
        }
        boolean hasExtension = fileName.endsWith(RFileUtilCore.RB_FILE_SUFFIX) || fileName.endsWith(".so") || fileName.endsWith(".dll") || fileName.endsWith(".bundle");
        ArrayList<VirtualFile> filesToProbe = new ArrayList<VirtualFile>();
        if (!hasExtension) {
            filesToProbe.addAll(FilenameIndex.getVirtualFilesByName((String)(fileName + RFileUtilCore.RB_FILE_SUFFIX), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        }
        filesToProbe.addAll(FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        if (!hasExtension && RFileUtil.getOsSpecificSuffix() != null) {
            filesToProbe.addAll(FilenameIndex.getVirtualFilesByName((String)(fileName + RFileUtil.getOsSpecificSuffix()), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        }
        if (filesToProbeCache != null && filesToProbe.size() > 5) {
            filesToProbeCache.put(fileName, filesToProbe);
        }
        ArrayList<VirtualFile> arrayList = filesToProbe;
        if (arrayList == null) {
            RFileUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static String getOsSpecificSuffix() {
        if (SystemInfo.isMac) {
            return ".bundle";
        }
        if (SystemInfo.isLinux) {
            return ".so";
        }
        if (SystemInfo.isWindows) {
            return ".dll";
        }
        return null;
    }

    private static void addFileRelativeTo(VirtualFile parent, String name, Collection<? super VirtualFile> files) {
        VirtualFile file = RFileUtil.findFileRelativeTo(parent, name);
        if (file != null) {
            files.add((VirtualFile)file);
        }
    }

    @Nullable
    public static VirtualFile findFileRelativeTo(@Nullable VirtualFile parent, @NotNull String name) {
        if (name == null) {
            RFileUtil.$$$reportNull$$$0(22);
        }
        if (parent == null || !parent.isValid() || !parent.isDirectory() || name.isEmpty()) {
            return null;
        }
        int lastSeparator = name.lastIndexOf(47);
        if (lastSeparator != -1) {
            return RFileUtil.findFileRelativeTo(parent.findFileByRelativePath(name.substring(0, lastSeparator)), name.substring(lastSeparator + 1));
        }
        if (name.endsWith(RFileUtilCore.RB_FILE_SUFFIX) || name.endsWith(".so") || name.endsWith(".dll") || name.endsWith(".bundle")) {
            return parent.findChild(name);
        }
        VirtualFile file = parent.findChild(name + RFileUtilCore.RB_FILE_SUFFIX);
        file = file == null ? parent.findChild(name) : file;
        file = file == null && SystemInfo.isLinux ? parent.findChild(name + ".so") : file;
        file = file == null && SystemInfo.isWindows ? parent.findChild(name + ".dll") : file;
        file = file == null && SystemInfo.isMac ? parent.findChild(name + ".bundle") : file;
        return file;
    }

    private static boolean addFileAbs(String name, Collection<? super VirtualFile> files, VirtualFileSystem fileSystem) {
        if (fileSystem instanceof JarFileSystem) {
            return false;
        }
        if (name.endsWith(RFileUtilCore.RB_FILE_SUFFIX) || name.endsWith(".so") || name.endsWith(".dll") || name.endsWith(".bundle")) {
            return RFileUtil.findAndAddAbs(name, files, fileSystem);
        }
        if (!(RFileUtil.findAndAddAbs(name + RFileUtilCore.RB_FILE_SUFFIX, files, fileSystem) || RFileUtil.findAndAddAbs(name, files, fileSystem) || SystemInfo.isLinux && RFileUtil.findAndAddAbs(name + ".so", files, fileSystem) || SystemInfo.isWindows && RFileUtil.findAndAddAbs(name + ".dll", files, fileSystem))) {
            return SystemInfo.isMac && RFileUtil.findAndAddAbs(name + ".bundle", files, fileSystem);
        }
        return true;
    }

    private static boolean findAndAddAbs(String name, Collection<? super VirtualFile> files, VirtualFileSystem fileSystem) {
        VirtualFile child = fileSystem.findFileByPath(name);
        if (child != null && !child.isDirectory()) {
            files.add((VirtualFile)child);
            return true;
        }
        return false;
    }

    @NotNull
    public static List<String> getAvailableRequiresUrls(@NotNull RFile rFile, @NotNull VirtualFile file, boolean relativeToDirectory) {
        if (rFile == null) {
            RFileUtil.$$$reportNull$$$0(23);
        }
        if (file == null) {
            RFileUtil.$$$reportNull$$$0(24);
        }
        ArrayList<String> list = new ArrayList<String>();
        Project project = rFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile parent = file.getParent();
        if (!relativeToDirectory) {
            for (VirtualFile root : LoadPathUtil.getLoadPath((RTopLevelContainer)rFile)) {
                if (root == null) {
                    LOG.error("Null value as a loadpath found for file: " + (String)ObjectUtils.coalesce((Object)((String)ObjectUtils.doIfNotNull((Object)rFile.getVirtualFile(), vFile -> vFile.getPath())), (Object)rFile.getName()));
                    continue;
                }
                list.addAll(RubyVirtualFileScanner.getRelativeUrls(root));
            }
        }
        if (parent != null) {
            list.addAll(RubyVirtualFileScanner.getRelativeUrlsInProject(fileIndex, parent));
        }
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            RFileUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    public static String getFileName(@NotNull String arg) {
        if (arg == null) {
            RFileUtil.$$$reportNull$$$0(26);
        }
        Pair<String, TextRange> range = RFileUtil.getNameRange(arg);
        return (String)Pair.getFirst(range);
    }

    @Nullable
    public static Pair<String, TextRange> getNameRange(@NotNull String arg) {
        TextRange range;
        if (arg == null) {
            RFileUtil.$$$reportNull$$$0(27);
        }
        int start = 0;
        int end = arg.length();
        if (arg.startsWith("%q") || arg.startsWith("%Q")) {
            if (arg.length() > 2) {
                char delimiter = arg.charAt(2);
                start = 3;
                if (arg.endsWith(String.valueOf(CommonTextUtil.getCloseDelim((char)delimiter)))) {
                    --end;
                }
            }
        } else {
            if (arg.startsWith("\"")) {
                ++start;
            }
            if (arg.endsWith("\"")) {
                --end;
            }
            if (arg.startsWith("'")) {
                ++start;
            }
            if (arg.endsWith("'")) {
                --end;
            }
        }
        if (start >= end) {
            return null;
        }
        arg = arg.substring(start, end);
        TextRange oldRange = range = new TextRange(start, end);
        while (true) {
            int dotIndex;
            int slashIndex;
            if ((slashIndex = arg.lastIndexOf(47)) != -1) {
                arg = arg.substring(slashIndex + 1);
                range = new TextRange(range.getStartOffset() + slashIndex + 1, range.getEndOffset());
            }
            if ((slashIndex = arg.lastIndexOf(92)) != -1) {
                arg = arg.substring(slashIndex + 1);
                range = new TextRange(range.getStartOffset() + slashIndex + 1, range.getEndOffset());
            }
            if ((dotIndex = arg.lastIndexOf(46)) != -1) {
                arg = arg.substring(0, dotIndex);
                range = new TextRange(range.getStartOffset(), range.getStartOffset() + dotIndex);
            }
            if (range == oldRange) {
                return Pair.create((Object)arg, (Object)range);
            }
            oldRange = range;
        }
    }

    @Nullable
    public PsiElement rename(@NotNull RPsiElement fullCall, @NotNull TextRange textRange, @NotNull String newElementName) {
        if (fullCall == null) {
            RFileUtil.$$$reportNull$$$0(28);
        }
        if (textRange == null) {
            RFileUtil.$$$reportNull$$$0(29);
        }
        if (newElementName == null) {
            RFileUtil.$$$reportNull$$$0(30);
        }
        newElementName = StringUtil.trimEnd((String)newElementName, (String)RFileUtilCore.RB_FILE_SUFFIX);
        String fullText = fullCall.getText();
        String stringToLookForName = textRange.substring(fullText);
        Pair<String, TextRange> rangePair = RFileUtil.getNameRange(stringToLookForName);
        if (rangePair == null) {
            return null;
        }
        String newStringWithName = ((TextRange)rangePair.second).replace(stringToLookForName, newElementName);
        String textToCreateFile = fullText.substring(0, textRange.getStartOffset()) + newStringWithName + fullText.substring(textRange.getEndOffset());
        RPsiElement newFullCall = RubyElementFactoryCore.createElementFromText((PsiElement)fullCall, (String)textToCreateFile);
        assert (textToCreateFile.equals(newFullCall.getText()));
        RubyPsiUtilCore.replaceInParent((PsiElement)fullCall, (PsiElement)newFullCall);
        return newFullCall;
    }

    @Nullable
    public static String getRequirePath(@NotNull VirtualFile file, @NotNull RCall call) {
        if (file == null) {
            RFileUtil.$$$reportNull$$$0(31);
        }
        if (call == null) {
            RFileUtil.$$$reportNull$$$0(32);
        }
        Trinity data = (Trinity)call.getUserData(FILE_REQUIRE_PATH_KEY);
        String path = file.getPath();
        List evaluatedArguments = (List)call.getData(new RubyCallType[0]);
        if (data != null && path.equals(data.first) && evaluatedArguments.equals(data.third)) {
            return (String)data.second;
        }
        String result = RFileUtil.evaluateRequirePath(file, call);
        if (result != null) {
            call.putUserData(FILE_REQUIRE_PATH_KEY, (Object)Trinity.create((Object)path, (Object)result, (Object)evaluatedArguments));
        }
        return result;
    }

    @Nullable
    public static String evaluateRequirePath(@NotNull VirtualFile file, @NotNull RCall call) {
        int argIndex;
        if (file == null) {
            RFileUtil.$$$reportNull$$$0(33);
        }
        if (call == null) {
            RFileUtil.$$$reportNull$$$0(34);
        }
        RPossibleCallStub callStub = (RPossibleCallStub)((RPossibleCallImpl)call).getStub();
        boolean isAutoload = call.getCallType() == RubyCallTypes.AUTOLOAD_CALL;
        int n = argIndex = isAutoload ? 1 : 0;
        if (callStub != null) {
            Project project = call.getProject();
            List args = (List)call.getData(new RubyCallType[0]);
            int argsSize = args.size();
            if (argIndex < argsSize) {
                String name = (String)args.get(argIndex);
                if (name == null) {
                    return null;
                }
                return RFileUtil.tryEvaluateFast(file, call, isAutoload, argIndex, project, name);
            }
            if (isAutoload) {
                return RFileUtil.getFileNameFromStubConstant((RPossibleCallStub<? extends RCall>)callStub, args);
            }
            return null;
        }
        return RFileUtil.evalRequirePathByRealPsi(file, call.getArguments(), argIndex, isAutoload);
    }

    @Nullable
    private static String tryEvaluateFast(VirtualFile file, RCall call, boolean autoload, int argIndex, Project project, String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            if (name.contains("#{") && (EVALUATE_ALL_REQUIRES || ProjectRootManager.getInstance((Project)project).getFileIndex().isInSourceContent(file))) {
                return RFileUtil.evalRequirePathByRealPsi(file, RFileUtil.getArguments(call), argIndex, autoload);
            }
            if (name.indexOf(43) < 0) {
                return name.substring(1, name.length() - 1);
            }
        } else if (name.length() > 1 && name.startsWith("'") && name.endsWith("'") && name.indexOf(43) < 0) {
            return name.substring(1, name.length() - 1);
        }
        if (call.getCommand().contains(".") || call.getCommand().contains("::")) {
            return null;
        }
        if (name.contains("\n")) {
            return null;
        }
        if (!(name.contains("+") || name.contains("#{") || name.contains("File") || name.contains("FILE"))) {
            return null;
        }
        String text = "require(" + name + ")";
        List elements = RubyElementFactoryCore.getNotEmptyTopLevelElements((Project)project, (String)text, (LanguageLevel)LanguageLevel.latest());
        String result = RFileUtil.evaluateRequirement(file, (PsiElement)((RCall)elements.get(0)).getArguments().get(0));
        if (LOG.isDebugEnabled()) {
            LOG.info("Failed to evaluate full require for: " + file.getPath() + ", " + call.getCommand() + " " + name);
        }
        return result;
    }

    private static List<RPsiElement> getArguments(Object call) {
        if (call instanceof RCall) {
            return ((RCall)call).getArguments();
        }
        if (call instanceof RBlockCall) {
            return RFileUtil.getArguments(((RBlockCall)call).getCall());
        }
        if (call instanceof StubElement) {
            return RFileUtil.getArguments(((StubElement)call).getPsi());
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String getFileNameFromStubConstant(RPossibleCallStub<? extends RCall> callStub, List<String> args) {
        List blockCallArgs;
        RubyCallTypeBase.Data callData;
        if (args.isEmpty()) {
            return null;
        }
        String arg = args.get(0);
        String name = arg.charAt(0) == ':' ? arg.substring(1) : arg;
        RContainer parent = (RContainer)callStub.getParentStubOfType(RModule.class);
        parent = parent == null ? (RContainer)callStub.getParentStubOfType(RClass.class) : parent;
        String stubName = parent != null ? parent.getFQN().getFullPath() : null;
        String underPath = null;
        StubElement underStub = callStub.getParentStub();
        if (underStub instanceof RCodeBlockStub) {
            RBlockCall blockCall = ((RCodeBlock)((RCodeBlockStub)underStub).getPsi()).getBlockCall();
            StubElement stubElement = underStub = blockCall != null ? ((RStubBasedPsiElementBase)blockCall).getStub() : null;
        }
        if (underStub instanceof RBlockCallStub && (callData = ((RBlockCallStub)underStub).getCallData()).getCallType() == RubyCallTypes.AUTOLOAD_UNDER_CALL && (blockCallArgs = (List)callData.getData(RubyCallTypes.AUTOLOAD_UNDER_CALL, new RubyCallType[0])).size() == 1) {
            underPath = (String)blockCallArgs.get(0);
        }
        return RFileUtil.buildFullPath(stubName, underPath, name);
    }

    @Nullable
    private static String getFileNameFromPsiConstant(VirtualFile file, List<? extends RPsiElement> args) {
        RPossibleCall parentCall;
        if (args.isEmpty()) {
            return null;
        }
        RPsiElement arg = args.get(0);
        String name = RubyPsiUtilCore.getElementText((PsiElement)arg);
        RContainer container = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)arg);
        RBlockCall blockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)arg, RBlockCall.class);
        String underPath = null;
        if (blockCall != null && (parentCall = blockCall.getCall()) instanceof RCall) {
            RCall rCall = (RCall)parentCall;
            List parentArgs = rCall.getArguments();
            if (rCall.getCallType() == RubyCallTypes.AUTOLOAD_UNDER_CALL && parentArgs.size() == 1) {
                RPsiElement dir = (RPsiElement)parentArgs.get(0);
                underPath = RequireArgumentsEvaluator.isSimpleString((PsiElement)dir) ? RubyPsiUtilCore.getElementText((PsiElement)dir) : RFileUtil.evaluateRequirement(file, (PsiElement)dir);
            }
        }
        String containerName = container != null ? container.getFQN().getFullPath() : null;
        return RFileUtil.buildFullPath(containerName, underPath, name);
    }

    private static String buildFullPath(String ... names) {
        StringBuilder builder2 = new StringBuilder();
        for (String name : names) {
            if (name == null) continue;
            if (!builder2.isEmpty()) {
                builder2.append("::");
            }
            builder2.append(name);
        }
        return NamingConventions.toUnderscoreCase((String)builder2.toString());
    }

    @Nullable
    private static String evalRequirePathByRealPsi(VirtualFile file, List<? extends RPsiElement> args, int argIndex, boolean isAutoload) {
        if (argIndex < args.size()) {
            return RFileUtil.evaluateRequirement(file, (PsiElement)args.get(argIndex));
        }
        if (isAutoload && !args.isEmpty()) {
            return RFileUtil.getFileNameFromPsiConstant(file, args);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7, 12, 13, 17, 20, 21, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadPath";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RFileUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 8: 
            case 24: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCall";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RFileUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapByLoadpath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateRequireInfos";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRequires";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesForName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnderLoadPathReverse";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToProbe";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableRequiresUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMapByLoadpath";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateRequireInfos";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeRequires";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByRPsiElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFilesForName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUnderLoadPathReverse";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToProbe";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findFileRelativeTo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableRequiresUrls";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNameRange";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRequirePath";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "evaluateRequirePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7, 12, 13, 17, 20, 21, 25 -> new IllegalStateException(string);
        };
    }

    private static class SingletonHolder {
        private static final RFileUtil INSTANCE = new RFileUtil();

        private SingletonHolder() {
        }
    }
}

