/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class RubyClassResolveUtil {
    private RubyClassResolveUtil() {
    }

    @NotNull
    public static List<RClass> resolveSuperClass(@NotNull RClass rClass, PsiElement invocationPoint) {
        if (rClass == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(0);
        }
        if (!(rClass instanceof RClassBase)) {
            List<RClass> list = Collections.emptyList();
            if (list == null) {
                RubyClassResolveUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        Symbol superClassSymbol = RubyClassResolveUtil.resolveSuperClassSymbol(rClass, invocationPoint);
        if (superClassSymbol != null) {
            ArrayList<RClass> superClasses = new ArrayList<RClass>();
            for (PsiElement element : superClassSymbol.getAllDeclarations(invocationPoint)) {
                if (!(element instanceof RClass)) continue;
                superClasses.add((RClass)element);
            }
            ArrayList<RClass> arrayList = superClasses;
            if (arrayList == null) {
                RubyClassResolveUtil.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        List<RClass> list = Collections.emptyList();
        if (list == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static Symbol resolveSuperClassSymbol(@NotNull RClass rClass, PsiElement invocationPoint) {
        if (rClass == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(4);
        }
        if (!(rClass instanceof RClassBase)) {
            return null;
        }
        Symbol ownSuperClass = RubyClassResolveUtil.resolveSuperClassForPartialDeclaration(rClass, invocationPoint);
        if (ownSuperClass != null) {
            return ownSuperClass;
        }
        List<RContainer> partialDeclarations = RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)rClass, true, invocationPoint);
        HashSet<Symbol> superSymbols = new HashSet<Symbol>();
        for (RContainer partialDeclaration : partialDeclarations) {
            Symbol candidate;
            if (!(partialDeclaration instanceof RClassBase) || (candidate = RubyClassResolveUtil.resolveSuperClassForPartialDeclaration((RClass)partialDeclaration, invocationPoint)) == null) continue;
            superSymbols.add(candidate);
        }
        if (superSymbols.isEmpty()) {
            if (!FQN.same((FQN)rClass.getFQNWithNesting(), (String)"BasicObject") && !FQN.same((FQN)rClass.getFQNWithNesting(), (String)"Object")) {
                return SymbolUtil.findConstantByFQN(rClass.getProject(), Type.CLASS, RClassBase.OBJECT_FQN, invocationPoint);
            }
            return null;
        }
        return MultiSymbol.of((Symbol[])superSymbols.toArray(new Symbol[0]));
    }

    @Nullable
    private static Symbol resolveSuperClassForPartialDeclaration(@NotNull RClass rClass, PsiElement invocationPoint) {
        FQN superClassFQN;
        if (rClass == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(5);
        }
        if ((superClassFQN = rClass.getSuperClassFQN()) != null) {
            RContainer parentContainer = rClass.getParentContainer();
            Symbol container = SymbolUtil.getSymbolByContainer((RElementWithFQN)parentContainer);
            if (container == null) {
                return null;
            }
            Computable resolve = () -> SymbolUtil.resolveConstantFQN(container, (RPsiElement)parentContainer, superClassFQN, SymbolUtil.getClassTypes(), invocationPoint);
            return (Symbol)RecursionManager.doPreventingRecursion((Object)rClass, (boolean)false, (Computable)resolve);
        }
        return null;
    }

    @Nullable
    public static String getQualifiedName(@NotNull RClass rClass) {
        if (rClass == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(6);
        }
        if (!(rClass instanceof RClassBase)) {
            return null;
        }
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        return symbol != null ? symbol.getFQNWithNesting().getFullPath() : null;
    }

    @Nullable
    public static RPossibleCall findCall(@NotNull RClass rClass, @NotNull Predicate<RubyCallType<?>> predicate) {
        if (rClass == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(7);
        }
        if (predicate == null) {
            RubyClassResolveUtil.$$$reportNull$$$0(8);
        }
        if (!(rClass instanceof RClassBase)) {
            return null;
        }
        return RContainerUtil.findCall((RContainer)rClass, predicate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyClassResolveUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyClassResolveUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperClassSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperClassForPartialDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

