/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentInfoWithDefaultArgs;

public enum ArgumentInfoPresentation {
    NO_VALUES,
    SHORT,
    FULL;

    private static final Pattern VALUE_PATTERN;
    public static final String ELLIPSIS;
    public static final int MAX_SHORT_VALUE_SIZE = 10;

    @NotNull
    public static String getPresentableString(@NotNull Project project, @NotNull List<? extends ArgumentInfo> argumentInfos, @NotNull ArgumentInfoPresentation presentation) {
        if (project == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(0);
        }
        if (argumentInfos == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(2);
        }
        String string = StringUtil.join(argumentInfos, info -> ArgumentInfoPresentation.getPresentableString(project, info, presentation), (String)", ");
        if (string == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getPresentableString(@NotNull Project project, @NotNull ArgumentInfo argumentInfo, @NotNull ArgumentInfoPresentation presentation) {
        ArgumentInfo.Type type;
        if (project == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(4);
        }
        if (argumentInfo == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(6);
        }
        if (presentation != NO_VALUES && argumentInfo instanceof RArgumentInfoWithDefaultArgs && (type = argumentInfo.getType()).isOptional()) {
            String string = argumentInfo.getName() + ArgumentInfoPresentation.getNameValueInfix(type) + ArgumentInfoPresentation.formatValue(project, ((RArgumentInfoWithDefaultArgs)argumentInfo).getDefaultValue(), presentation);
            if (string == null) {
                ArgumentInfoPresentation.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = argumentInfo.getPresentableName();
        if (string == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String formatValue(@NotNull Project project, @Nullable String valueText, @NotNull ArgumentInfoPresentation presentation) {
        if (project == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(9);
        }
        if (presentation == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)valueText)) {
            String string = ELLIPSIS;
            if (string == null) {
                ArgumentInfoPresentation.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (presentation == FULL) {
            return ArgumentInfoPresentation.createFormattedResult(project, valueText);
        }
        Matcher matcher = VALUE_PATTERN.matcher(valueText);
        if (matcher.matches()) {
            ArrayList<String> startAndEnd = new ArrayList<String>(2);
            for (int groupIndex = 1; groupIndex <= matcher.groupCount(); ++groupIndex) {
                String group = matcher.group(groupIndex);
                if (group == null) continue;
                startAndEnd.add(group);
            }
            if (startAndEnd.size() != 2) {
                throw new AssertionError((Object)"Zero or two groups can match with this regex");
            }
            int sumLength = ((String)startAndEnd.get(0)).length() + ((String)startAndEnd.get(1)).length();
            if (sumLength > 10) {
                String string = ELLIPSIS;
                if (string == null) {
                    ArgumentInfoPresentation.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (sumLength == valueText.length()) {
                String string = valueText;
                if (string == null) {
                    ArgumentInfoPresentation.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = (String)startAndEnd.get(0) + " " + ELLIPSIS + " " + (String)startAndEnd.get(1);
            if (string == null) {
                ArgumentInfoPresentation.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = valueText.length() <= 10 ? valueText : ELLIPSIS;
        if (string == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String createFormattedResult(Project project, @NotNull String valueText) {
        if (valueText == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(16);
        }
        String string = valueText;
        if (string == null) {
            ArgumentInfoPresentation.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getNameValueInfix(ArgumentInfo.Type type) {
        return type == ArgumentInfo.Type.PREDEFINED ? " = " : ": ";
    }

    static {
        VALUE_PATTERN = Pattern.compile("^(?:(\\{).*(})|(\\[).*(])|(\\S+\\().*(\\)))$", 32);
        ELLIPSIS = ApplicationManager.getApplication().isUnitTestMode() ? "..." : "\u2026";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 11, 12, 13, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfoPresentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfoPresentation";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableString";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormattedResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableString";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFormattedResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 11, 12, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }
}

