/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ruby27.impl.PatternMatchingAccessImpl;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStrings;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.instructions.RaiseInstructionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.instructions.ReadWriteInstructionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.instructions.ReturnInstructionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.RaiseInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReturnInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBreakStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RLoopStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RNextStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRedoStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRetryStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhenCase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.REnsureBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RRescueModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RAltPattern;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RArrayPattern;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RGuardedPatternBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RHashPattern;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RPatternVarRef;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RVariableBind;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubySystemCallVisitor;

public class RControlFlowBuilder
extends RubySystemCallVisitor {
    private static final int DEFAULT_MAX_LIST_ELEMENT_TO_BUILD_FOR = 120;
    private static final int DEFAULT_MAX_CFG_SIZE = 2200;
    private static final Logger LOG = Logger.getInstance(RControlFlowBuilder.class);
    private final ControlFlowBuilder myBuilder = new ControlFlowBuilder();
    @Nullable
    private RWhenCase myPatternMatchingCase = null;

    RControlFlow buildControlFlow(@NotNull ControlFlowHolder owner) {
        if (owner == null) {
            RControlFlowBuilder.$$$reportNull$$$0(0);
        }
        try {
            ControlFlow controlFlow = this.myBuilder.build((PsiElementVisitor)this, (PsiElement)owner);
            if (this.isCfgTooBig()) {
                LOG.debug("Control flow is too big for: " + String.valueOf(owner) + "(" + owner.getName() + ") in " + String.valueOf(PsiUtilCore.getVirtualFile((PsiElement)owner)));
                return (RControlFlow)RControlFlowUtil.TOO_BIG_FLOW_PROVIDER.getValue();
            }
            return new RControlFlowImpl(controlFlow.getInstructions());
        }
        catch (InvalidInstructionBlockException e) {
            LOG.error("InvalidInstructionBlockException while building control flow graph.  File: %s. Control flow holder:\n%s".formatted(owner.getContainingFile().getName(), StringUtil.shortenTextWithEllipsis((String)owner.getText(), (int)512, (int)256)), (Throwable)e);
            return (RControlFlow)RControlFlowUtil.INVALID_INSTRUCTION_BLOCK_FLOW_PROVIDER.getValue();
        }
        catch (StackOverflowError e) {
            LOG.warn(RBundle.message((String)"ruby.control.flow.too.complex.error") + " File: " + owner.getContainingFile().getName() + ". File text: \n" + StringUtil.shortenTextWithEllipsis((String)owner.getContainingFile().getText(), (int)512, (int)256), (Throwable)e);
            return (RControlFlow)RControlFlowUtil.TOO_BIG_FLOW_PROVIDER.getValue();
        }
    }

    @Nullable
    public static RPsiElement getControlFlowNodeElement(PsiElement psiElement) {
        for (RPsiElement element = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)psiElement); element != null; element = element.getParent()) {
            if ((!(element instanceof RIdentifier) || RubyPsiUtilCore.isExplicitCall((RPsiElement)((RIdentifier)element))) && !(element instanceof RField) && !(element.getParent() instanceof RCompoundStatement) && !(element instanceof RCompoundStatement) && !(element instanceof RBodyStatement) && !(element instanceof RCall) && !(element instanceof RAssignmentExpression) && !(element instanceof RBinaryExpression) && !(element instanceof RRescueModStatement) && !(element instanceof RConditionalStatement) && !(element instanceof RLoopStatement) && !(element instanceof RCaseStatement) && !(element instanceof RBreakStatement) && !(element instanceof RNextStatement) && !(element instanceof RReturnStatement) && !(element instanceof RRedoStatement)) continue;
            return element;
        }
        return null;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            RControlFlowBuilder.$$$reportNull$$$0(1);
        }
        if (this.isCfgTooBig()) {
            return;
        }
        if (element instanceof ScopeHolder) {
            if (element instanceof RClass) {
                RClass rClass = (RClass)element;
                this.visitChildren((PsiElement)rClass.getPsiSuperClass());
            }
            if (element instanceof RObjectClass) {
                RObjectClass rObjectClass = (RObjectClass)element;
                this.visitChildren((PsiElement)rObjectClass.getObject());
            }
            if (element instanceof RSingletonMethod) {
                RSingletonMethod rSingletonMethod = (RSingletonMethod)element;
                this.visitChildren((PsiElement)rSingletonMethod.getClassObject());
            }
            if (element instanceof RCodeBlock) {
                this.myBuilder.startNode(element);
            }
            return;
        }
        if (element instanceof RPsiElement && (element.getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) != null || element.getParent() instanceof RCompoundStatement)) {
            this.visitChildren(element);
            this.myBuilder.startNode(element);
        } else {
            this.visitChildren(element);
        }
    }

    private boolean isCfgTooBig() {
        return this.myBuilder.instructions.size() >= RControlFlowBuilder.getMaxCfgSize();
    }

    private void visitChildren(@Nullable PsiElement psiElement) {
        if (psiElement != null && !this.isCfgTooBig()) {
            psiElement.acceptChildren((PsiElementVisitor)this);
        }
    }

    public void visitRClassObject(@NotNull RClassObject object) {
        if (object == null) {
            RControlFlowBuilder.$$$reportNull$$$0(2);
        }
    }

    public void visitRCompoundStatement(@NotNull RCompoundStatement rCompoundStatement) {
        if (rCompoundStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(3);
        }
        this.visitStatements(rCompoundStatement);
        this.myBuilder.startNode((PsiElement)rCompoundStatement);
    }

    private void visitStatements(RCompoundStatement rCompoundStatement) {
        for (RPsiElement statement : rCompoundStatement.getStatements()) {
            if (this.isCfgTooBig()) break;
            statement.accept((PsiElementVisitor)this);
        }
    }

    public void visitRReturnStatement(@NotNull RReturnStatement rReturnStatement) {
        if (rReturnStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(4);
        }
        for (RPsiElement element : rReturnStatement.getReturnValues()) {
            element.accept((PsiElementVisitor)this);
        }
        ReturnInstructionImpl instruction = new ReturnInstructionImpl(this.myBuilder, (RPsiElement)rReturnStatement);
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
        this.myBuilder.addPendingEdge(null, (Instruction)instruction);
        this.myBuilder.flowAbrupted();
    }

    public void visitRBlockCall(@NotNull RBlockCall blockCall) {
        boolean isFiniteLoop;
        if (blockCall == null) {
            RControlFlowBuilder.$$$reportNull$$$0(5);
        }
        RPossibleCall call = blockCall.getCall();
        call.accept((PsiElementVisitor)this);
        Instruction callInstruction = this.myBuilder.prevInstruction;
        RCodeBlock block = blockCall.getBlock();
        this.myBuilder.startNode((PsiElement)block);
        Instruction blockCallInstruction = this.myBuilder.startNode((PsiElement)blockCall);
        boolean bl = isFiniteLoop = !RubyPsiUtilCore.isInfiniteLoop((RLoopStatement)blockCall);
        if (isFiniteLoop) {
            this.myBuilder.addEdge(callInstruction, blockCallInstruction);
        }
    }

    public void visitRReference(@NotNull RReference reference) {
        RPsiElement referenceValue;
        if (reference == null) {
            RControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (reference.getReceiver() != null) {
            reference.getReceiver().accept((PsiElementVisitor)this);
        }
        if (reference instanceof RColonReference && (referenceValue = reference.getValue()) instanceof RConstant) {
            this.addConstantAssignmentInstructionIfPresent((RConstant)referenceValue, RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)reference));
        }
        this.myBuilder.startNode((PsiElement)reference);
    }

    public void visitRAssocList(@NotNull RAssocList rAssocList) {
        if (rAssocList == null) {
            RControlFlowBuilder.$$$reportNull$$$0(7);
        }
        RControlFlowBuilder.collectChildrenOrEmpty(rAssocList.getElementsIterator()).forEach(it -> it.accept((PsiElementVisitor)this));
        this.myBuilder.startNode((PsiElement)rAssocList);
    }

    @NotNull
    private static List<RPsiElement> collectChildrenOrEmpty(@NotNull Iterator<? extends RPsiElement> iterator) {
        if (iterator == null) {
            RControlFlowBuilder.$$$reportNull$$$0(8);
        }
        ArrayList<RPsiElement> elements = new ArrayList<RPsiElement>();
        while (iterator.hasNext()) {
            if (elements.size() == RControlFlowBuilder.getMaxListElementsForCfgToBuild()) {
                elements.clear();
                break;
            }
            elements.add(iterator.next());
        }
        ArrayList<RPsiElement> arrayList = elements;
        if (arrayList == null) {
            RControlFlowBuilder.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    public void visitRCall(@NotNull RCall call) {
        if (call == null) {
            RControlFlowBuilder.$$$reportNull$$$0(10);
        }
        call.getPsiCommand().accept((PsiElementVisitor)this);
        call.getCallArguments().accept((PsiElementVisitor)this);
        boolean isRaiseCall = RubyCallTypesCore.isRaiseCall((RPossibleCall)call);
        RaiseInstructionImpl instruction = isRaiseCall ? new RaiseInstructionImpl(this.myBuilder, (RPsiElement)call) : new InstructionImpl(this.myBuilder, (PsiElement)call);
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
        if (isRaiseCall) {
            this.visitRaiseOrThrow((RPossibleCall)call);
        } else if (RControlFlowBuilder.isThrowCall((PsiElement)call) || RubyPsiUtilCore.isExit((PsiElement)call)) {
            this.myBuilder.addPendingEdge(null, (Instruction)instruction);
            this.myBuilder.flowAbrupted();
        }
    }

    public void visitRLambdaCall(@NotNull RLambdaCall lambdaCall) {
        RPsiElement receiver;
        if (lambdaCall == null) {
            RControlFlowBuilder.$$$reportNull$$$0(11);
        }
        if ((receiver = lambdaCall.getReceiver()) != null) {
            receiver.accept((PsiElementVisitor)this);
        }
        lambdaCall.getCallArguments().accept((PsiElementVisitor)this);
        this.myBuilder.addNodeAndCheckPending((Instruction)new InstructionImpl(this.myBuilder, (PsiElement)lambdaCall));
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
        RPsiElement value;
        if (assignmentExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(12);
        }
        if ((value = assignmentExpression.getValue()) != null) {
            value.accept((PsiElementVisitor)this);
        }
        RPsiElement object = assignmentExpression.getObject();
        object.accept((PsiElementVisitor)this);
        this.myBuilder.startNode((PsiElement)assignmentExpression);
    }

    public void visitRSelfAssignmentExpression(RSelfAssignmentExpression selfAssignmentExpression) {
        RPsiElement value = selfAssignmentExpression.getValue();
        RPsiElement object = selfAssignmentExpression.getObject();
        ConditionalInstructionImpl trueInstruction = null;
        ConditionalInstructionImpl falseInstruction = null;
        if (selfAssignmentExpression.getOperationType() == RubyTokenTypes.tOR_OP_ASGN || selfAssignmentExpression.getOperationType() == RubyTokenTypes.tAND_OP_ASGN) {
            trueInstruction = new ConditionalInstructionImpl(this.myBuilder, null, (PsiElement)object, true);
            falseInstruction = new ConditionalInstructionImpl(this.myBuilder, null, (PsiElement)object, false);
            Instruction prev = this.myBuilder.prevInstruction;
            this.myBuilder.addNode((Instruction)trueInstruction);
            this.myBuilder.prevInstruction = prev;
            this.myBuilder.addNode((Instruction)falseInstruction);
            if (selfAssignmentExpression.getOperationType() == RubyTokenTypes.tAND_OP_ASGN) {
                this.myBuilder.prevInstruction = trueInstruction;
            }
        }
        if (value != null) {
            value.accept((PsiElementVisitor)this);
        }
        if (selfAssignmentExpression.getOperationType() == RubyTokenTypes.tAND_OP_ASGN) {
            this.myBuilder.addPendingEdge((PsiElement)value, falseInstruction);
        } else if (selfAssignmentExpression.getOperationType() == RubyTokenTypes.tOR_OP_ASGN) {
            this.myBuilder.addPendingEdge((PsiElement)value, (Instruction)trueInstruction);
        }
        object.accept((PsiElementVisitor)this);
        this.myBuilder.startNode((PsiElement)selfAssignmentExpression);
    }

    public void visitRMultiAssignmentExpression(@NotNull RMultiAssignmentExpression multiAssignmentExpression) {
        if (multiAssignmentExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(13);
        }
        this.visitRAssignmentExpression((RAssignmentExpression)multiAssignmentExpression);
    }

    public void visitRIntegerConstant(@NotNull RIntegerConstant rIntegerConstant) {
        if (rIntegerConstant == null) {
            RControlFlowBuilder.$$$reportNull$$$0(14);
        }
        this.myBuilder.startNode((PsiElement)rIntegerConstant);
    }

    public void visitRFloatConstant(@NotNull RFloatConstant rFloatConstant) {
        if (rFloatConstant == null) {
            RControlFlowBuilder.$$$reportNull$$$0(15);
        }
        this.myBuilder.startNode((PsiElement)rFloatConstant);
    }

    public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
        if (rStringLiteral == null) {
            RControlFlowBuilder.$$$reportNull$$$0(16);
        }
        this.myBuilder.startNode((PsiElement)rStringLiteral);
    }

    public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
        if (rDStringLiteral == null) {
            RControlFlowBuilder.$$$reportNull$$$0(17);
        }
        for (RExpressionSubstitution substitution : rDStringLiteral.getExpressionSubstitutions()) {
            substitution.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rDStringLiteral);
    }

    public void visitRStrings(@NotNull RStrings rStrings) {
        if (rStrings == null) {
            RControlFlowBuilder.$$$reportNull$$$0(18);
        }
        for (RStringLiteral literal : rStrings.getElements()) {
            literal.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rStrings);
    }

    public void visitRSymbol(@NotNull RSymbol rSymbol) {
        if (rSymbol == null) {
            RControlFlowBuilder.$$$reportNull$$$0(19);
        }
        rSymbol.getContent().accept((PsiElementVisitor)this);
        this.myBuilder.startNode((PsiElement)rSymbol);
    }

    public void visitRSymbols(@NotNull RWords rSymbols) {
        if (rSymbols == null) {
            RControlFlowBuilder.$$$reportNull$$$0(20);
        }
        this.myBuilder.startNode((PsiElement)rSymbols);
    }

    public void visitRDSymbols(@NotNull RWords rdSymbols) {
        if (rdSymbols == null) {
            RControlFlowBuilder.$$$reportNull$$$0(21);
        }
        for (RExpressionSubstitution substitution : rdSymbols.getExpressionSubstitutions()) {
            substitution.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rdSymbols);
    }

    public void visitRWords(@NotNull RWords words) {
        if (words == null) {
            RControlFlowBuilder.$$$reportNull$$$0(22);
        }
        this.myBuilder.startNode((PsiElement)words);
    }

    public void visitRDWords(@NotNull RWords words) {
        if (words == null) {
            RControlFlowBuilder.$$$reportNull$$$0(23);
        }
        for (RExpressionSubstitution substitution : words.getExpressionSubstitutions()) {
            substitution.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)words);
    }

    public void visitRUnaryExpression(@NotNull RUnaryExpression unaryExpression) {
        RPsiElement element;
        if (unaryExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(24);
        }
        if ((element = unaryExpression.getElement()) != null) {
            element.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)unaryExpression);
    }

    public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
        if (rPseudoConstant == null) {
            RControlFlowBuilder.$$$reportNull$$$0(25);
        }
        this.myBuilder.startNode((PsiElement)rPseudoConstant);
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
        RPsiElement rightOperand;
        RPsiElement leftOperand;
        if (rBinaryExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(26);
        }
        if ((leftOperand = rBinaryExpression.getLeftOperand()) != null) {
            leftOperand.accept((PsiElementVisitor)this);
        }
        if ((rightOperand = rBinaryExpression.getRightOperand()) != null) {
            rightOperand.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rBinaryExpression);
    }

    public void visitRBoolBinExpression(@NotNull RBoolBinExpression rBinaryExpression) {
        if (rBinaryExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(27);
        }
        IElementType operationType = rBinaryExpression.getOperationType();
        RPsiElement leftOperand = rBinaryExpression.getLeftOperand();
        leftOperand.accept((PsiElementVisitor)this);
        boolean booleanAndExpression = operationType == RubyTokenTypesCore.tAND || operationType == RubyTokenTypes.kAND;
        Instruction lastInstructionInBinaryExpression = this.findLastNonBoolBinInstruction();
        PsiElement lastInstructionElement = lastInstructionInBinaryExpression.getElement();
        ConditionalInstructionImpl trueInstruction = new ConditionalInstructionImpl(this.myBuilder, null, lastInstructionElement, true);
        ConditionalInstructionImpl falseInstruction = new ConditionalInstructionImpl(this.myBuilder, null, lastInstructionElement, false);
        Instruction prev = this.myBuilder.prevInstruction;
        this.myBuilder.addNode((Instruction)trueInstruction);
        this.myBuilder.prevInstruction = prev;
        this.myBuilder.addNode((Instruction)falseInstruction);
        if (booleanAndExpression) {
            this.myBuilder.prevInstruction = trueInstruction;
            this.myBuilder.addPendingEdge((PsiElement)rBinaryExpression, (Instruction)falseInstruction);
        } else {
            this.myBuilder.prevInstruction = falseInstruction;
            this.myBuilder.addPendingEdge((PsiElement)rBinaryExpression, (Instruction)trueInstruction);
        }
        RPsiElement rightOperand = rBinaryExpression.getRightOperand();
        ArrayList instructionsNotToBeLinked = new ArrayList();
        if (rightOperand != null) {
            this.myBuilder.processPending((pendingScope, instruction) -> {
                if (pendingScope instanceof RBinaryExpression && ((RBinaryExpression)pendingScope).getOperationType() == rBinaryExpression.getOperationType()) {
                    this.myBuilder.addPendingEdge((PsiElement)rBinaryExpression, instruction);
                } else {
                    this.myBuilder.addPendingEdge(pendingScope, instruction);
                }
            });
            rightOperand.accept((PsiElementVisitor)this);
            this.myBuilder.processPending((pendingScope, instruction) -> {
                if (pendingScope instanceof RBinaryExpression) {
                    instructionsNotToBeLinked.add(new Pair((Object)pendingScope, (Object)instruction));
                } else {
                    this.myBuilder.addPendingEdge(pendingScope, instruction);
                }
            });
        }
        this.myBuilder.startNode((PsiElement)rBinaryExpression);
        for (Pair pair : instructionsNotToBeLinked) {
            this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
        }
    }

    public void visitRRescueModStatement(@NotNull RRescueModStatement rRescueModStatement) {
        if (rRescueModStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(28);
        }
        RPsiElement statement = rRescueModStatement.getStatement();
        statement.accept((PsiElementVisitor)this);
        Instruction lastStatementInstruction = this.myBuilder.prevInstruction;
        RPsiElement rescueStatement = rRescueModStatement.getRescueStatement();
        if (rescueStatement != null) {
            rescueStatement.accept((PsiElementVisitor)this);
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)rRescueModStatement);
        this.myBuilder.addEdge(lastStatementInstruction, instruction);
    }

    public void visitRArgument(@NotNull RArgument argument) {
        if (argument == null) {
            RControlFlowBuilder.$$$reportNull$$$0(29);
        }
        if (argument.getType().isOptional() && argument.getValue() != null) {
            argument.getValue().accept((PsiElementVisitor)this);
        }
        if (argument.getIdentifier() != null) {
            argument.getIdentifier().accept((PsiElementVisitor)this);
        }
    }

    public void visitRFid(@NotNull RFid rFid) {
        if (rFid == null) {
            RControlFlowBuilder.$$$reportNull$$$0(30);
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)rFid);
        if (RubyPsiUtilCore.isExit((PsiElement)rFid)) {
            this.myBuilder.addPendingEdge(null, instruction);
            this.myBuilder.flowAbrupted();
        }
    }

    public void visitRArray(@NotNull RArray array) {
        if (array == null) {
            RControlFlowBuilder.$$$reportNull$$$0(31);
        }
        RControlFlowBuilder.collectChildrenOrEmpty(array.getElementsIterator()).forEach(it -> it.accept((PsiElementVisitor)this));
        this.myBuilder.startNode((PsiElement)array);
    }

    public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
        if (arrayIndexing == null) {
            RControlFlowBuilder.$$$reportNull$$$0(32);
        }
        if (arrayIndexing.getReceiver() != null) {
            arrayIndexing.getReceiver().accept((PsiElementVisitor)this);
        }
        for (PsiElement element : arrayIndexing.getIndexes()) {
            element.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)arrayIndexing);
    }

    public void visitRIdentifier(final @NotNull RIdentifier rIdentifier) {
        boolean isThrowCall;
        RWhenCase patternMatchingCase;
        boolean isRaiseCall;
        if (rIdentifier == null) {
            RControlFlowBuilder.$$$reportNull$$$0(33);
        }
        if (rIdentifier.getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) == null && RubyPsiUtilCore.isExplicitCall((RPsiElement)rIdentifier) && RBlockCallNavigator.getByCall((RPsiElement)rIdentifier) == null) {
            return;
        }
        boolean bl = isRaiseCall = RControlFlowBuilder.isRaiseOrFailCall((PsiElement)rIdentifier) && !rIdentifier.isLocalVariable() && !rIdentifier.isParameter();
        Object instruction = isRaiseCall ? new RaiseInstructionImpl(this.myBuilder, (RPsiElement)rIdentifier) : ((patternMatchingCase = this.myPatternMatchingCase) != null ? new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)rIdentifier, rIdentifier.getName()){

            public Access getAccess() {
                return new PatternMatchingAccessImpl((RPsiElement)rIdentifier, patternMatchingCase);
            }
        } : new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)rIdentifier, rIdentifier.getName()){

            public Access getAccess() {
                return UsageAnalyzer.createUsageAccess((RPsiElement)rIdentifier);
            }
        });
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
        boolean bl2 = isThrowCall = RControlFlowBuilder.isThrowCall((PsiElement)rIdentifier) && !rIdentifier.isLocalVariable() && !rIdentifier.isParameter();
        if (isRaiseCall || isThrowCall) {
            this.visitRaiseOrThrow((RPossibleCall)rIdentifier);
        } else if (RubyPsiUtilCore.isExit((PsiElement)rIdentifier)) {
            this.myBuilder.addPendingEdge(null, (Instruction)instruction);
            this.myBuilder.flowAbrupted();
        }
    }

    public void visitRConstant(final @NotNull RConstant rConstant) {
        if (rConstant == null) {
            RControlFlowBuilder.$$$reportNull$$$0(34);
        }
        if (rConstant.getName() != null && !rConstant.getName().contains("IntellijIdeaRulezzz") && rConstant.getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) == null) {
            ReadWriteInstructionImpl instruction = new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)rConstant, rConstant.getText()){

                public Access getAccess() {
                    return UsageAnalyzer.createUsageAccess((RPsiElement)rConstant);
                }
            };
            this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
            return;
        }
        super.visitRConstant(rConstant);
    }

    public void visitRTopConstReference(@NotNull RTopConstReference rTopConstReference) {
        RConstant constant;
        if (rTopConstReference == null) {
            RControlFlowBuilder.$$$reportNull$$$0(35);
        }
        if ((constant = rTopConstReference.getConstant()) != null) {
            this.addConstantAssignmentInstructionIfPresent(constant, RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)rTopConstReference));
        }
        this.myBuilder.startNode((PsiElement)rTopConstReference);
    }

    public void visitRGlobalVariable(final @NotNull RGlobalVariable rGlobalVariable) {
        if (rGlobalVariable == null) {
            RControlFlowBuilder.$$$reportNull$$$0(36);
        }
        ReadWriteInstructionImpl instruction = new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)rGlobalVariable, rGlobalVariable.getText()){

            public Access getAccess() {
                return UsageAnalyzer.createUsageAccess((RPsiElement)rGlobalVariable);
            }
        };
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    public void visitRInstanceVariable(final @NotNull RInstanceVariable rInstanceVariable) {
        if (rInstanceVariable == null) {
            RControlFlowBuilder.$$$reportNull$$$0(37);
        }
        ReadWriteInstructionImpl instruction = new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)rInstanceVariable, rInstanceVariable.getText()){

            public Access getAccess() {
                return UsageAnalyzer.createUsageAccess((RPsiElement)rInstanceVariable);
            }
        };
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    public void visitRClassVariable(final @NotNull RClassVariable rClassVariable) {
        if (rClassVariable == null) {
            RControlFlowBuilder.$$$reportNull$$$0(38);
        }
        ReadWriteInstructionImpl instruction = new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)rClassVariable, rClassVariable.getText()){

            public Access getAccess() {
                return UsageAnalyzer.createUsageAccess((RPsiElement)rClassVariable);
            }
        };
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    private ConditionExitInstructions getConditionExitInstruction(RCondition condition) {
        List<Instruction> trueInstruction;
        ArrayList trueInstructions = new ArrayList();
        ArrayList falseInstructions = new ArrayList();
        if (this.myBuilder.prevInstruction != null) {
            Instruction lastNonBoolBinInstruction = this.findLastNonBoolBinInstruction();
            if (lastNonBoolBinInstruction != this.myBuilder.prevInstruction) {
                ConditionalInstructionImpl trueBranch = new ConditionalInstructionImpl(this.myBuilder, null, lastNonBoolBinInstruction.getElement(), true);
                ConditionalInstructionImpl falseBranch = new ConditionalInstructionImpl(this.myBuilder, null, lastNonBoolBinInstruction.getElement(), false);
                Instruction prev = this.myBuilder.prevInstruction;
                this.myBuilder.addNode((Instruction)trueBranch);
                this.myBuilder.prevInstruction = prev;
                this.myBuilder.addNode((Instruction)falseBranch);
                trueInstructions.add(trueBranch);
                falseInstructions.add(falseBranch);
            } else {
                trueInstructions.add(this.myBuilder.prevInstruction);
                falseInstructions.add(this.myBuilder.prevInstruction);
            }
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)pendingScope, (boolean)false)) {
                if (instruction instanceof ConditionalInstruction) {
                    if (((ConditionalInstruction)instruction).getResult()) {
                        trueInstructions.add(instruction);
                    } else {
                        falseInstructions.add(instruction);
                    }
                }
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        List<Object> list = trueInstructions.isEmpty() ? Collections.emptyList() : (trueInstruction = trueInstructions.size() == 1 ? Collections.singletonList((Instruction)trueInstructions.get(0)) : trueInstructions);
        List<Instruction> falseInstruction = falseInstructions.isEmpty() ? Collections.emptyList() : (falseInstructions.size() == 1 ? Collections.singletonList((Instruction)falseInstructions.get(0)) : falseInstructions);
        return new ConditionExitInstructions(trueInstruction, falseInstruction);
    }

    public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
        RCondition condition;
        if (ifStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(39);
        }
        if ((condition = ifStatement.getCondition()) != null) {
            condition.accept((PsiElementVisitor)this);
        }
        ConditionExitInstructions conditionInstructions = this.getConditionExitInstruction(condition);
        RCompoundStatement thenBranch = ifStatement.getThenBlock();
        RElseBlock elseBranch = ifStatement.getElseBlock();
        ConditionalInstruction trueConditionInstruction = this.addConditionalInstruction(conditionInstructions.trueBranch, (PsiElement)condition, true);
        ConditionalInstruction falseConditionInstruction = this.addConditionalInstruction(conditionInstructions.falseBranch, (PsiElement)condition, false);
        ArrayList<Instruction> pendingInstructions = new ArrayList<Instruction>();
        if (thenBranch != null) {
            this.myBuilder.prevInstruction = trueConditionInstruction;
            thenBranch.accept((PsiElementVisitor)this);
            pendingInstructions.add(this.myBuilder.prevInstruction);
        }
        for (RElsifBlock block : ifStatement.getElsifBlocks()) {
            this.myBuilder.prevInstruction = falseConditionInstruction;
            this.myBuilder.startNode((PsiElement)block);
            condition = block.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
            }
            conditionInstructions = this.getConditionExitInstruction(condition);
            trueConditionInstruction = this.addConditionalInstruction(conditionInstructions.trueBranch, (PsiElement)condition, true);
            falseConditionInstruction = this.addConditionalInstruction(conditionInstructions.falseBranch, (PsiElement)condition, false);
            this.myBuilder.prevInstruction = trueConditionInstruction;
            block.getBody().accept((PsiElementVisitor)this);
            pendingInstructions.add(this.myBuilder.prevInstruction);
        }
        this.myBuilder.prevInstruction = falseConditionInstruction;
        if (elseBranch != null) {
            this.myBuilder.startNode((PsiElement)elseBranch);
            elseBranch.accept((PsiElementVisitor)this);
            pendingInstructions.add(this.myBuilder.prevInstruction);
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)ifStatement);
        for (Instruction pendingInstruction : pendingInstructions) {
            this.myBuilder.addEdge(pendingInstruction, instruction);
        }
    }

    public void visitRIfModStatement(@NotNull RIfModStatement ifStatement) {
        if (ifStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(40);
        }
        this.visitCondition((RConditionalStatement)ifStatement, ifStatement.getCondition(), ifStatement.getCommand(), null, true);
    }

    public void visitRTernaryExpression(@NotNull RTernaryExpression ternaryExpression) {
        if (ternaryExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(41);
        }
        this.visitCondition((RConditionalStatement)ternaryExpression, ternaryExpression.getCondition(), ternaryExpression.getTrueCommand(), ternaryExpression.getFalseCommand(), true);
    }

    public void visitRUnlessStatement(@NotNull RUnlessStatement rUnlessStatement) {
        if (rUnlessStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(42);
        }
        this.visitCondition((RConditionalStatement)rUnlessStatement, rUnlessStatement.getCondition(), (RPsiElement)rUnlessStatement.getThenBlock(), (RPsiElement)rUnlessStatement.getElseBlock(), false);
    }

    public void visitRUnlessModStatement(@NotNull RUnlessModStatement rUnlessModStatement) {
        if (rUnlessModStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(43);
        }
        this.visitCondition((RConditionalStatement)rUnlessModStatement, rUnlessModStatement.getCondition(), rUnlessModStatement.getCommand(), null, false);
    }

    private void visitCondition(RConditionalStatement statement, RCondition condition, @Nullable RPsiElement trueBranch, @Nullable RPsiElement falseBranch, boolean forward) {
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
        ConditionExitInstructions conditionInstructions = this.getConditionExitInstruction(condition);
        ConditionalInstruction trueBranchInstruction = this.addConditionalInstruction(forward ? conditionInstructions.trueBranch : conditionInstructions.falseBranch, (PsiElement)condition, forward);
        ConditionalInstruction falseBranchInstruction = this.addConditionalInstruction(forward ? conditionInstructions.falseBranch : conditionInstructions.trueBranch, (PsiElement)condition, !forward);
        Instruction lastTrueBranchInstruction = null;
        Instruction lastFalseBranchInstruction = null;
        this.myBuilder.prevInstruction = trueBranchInstruction;
        if (trueBranch != null) {
            trueBranch.accept((PsiElementVisitor)this);
            lastTrueBranchInstruction = this.myBuilder.prevInstruction;
        }
        this.myBuilder.prevInstruction = falseBranchInstruction;
        if (falseBranch != null) {
            falseBranch.accept((PsiElementVisitor)this);
            lastFalseBranchInstruction = this.myBuilder.prevInstruction;
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)statement);
        this.myBuilder.addEdge(lastTrueBranchInstruction, instruction);
        this.myBuilder.addEdge(lastFalseBranchInstruction, instruction);
    }

    public void visitRWhileStatement(@NotNull RWhileStatement rWhileStatement) {
        if (rWhileStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(44);
        }
        this.visitRLoop((RConditionalStatement)rWhileStatement, rWhileStatement.getCondition(), (RPsiElement)rWhileStatement.getLoopBody(), true);
    }

    public void visitRBeginEndBlockStatement(@NotNull RBeginEndBlockStatement rBeginEndBlockStatement) {
        if (rBeginEndBlockStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(45);
        }
        rBeginEndBlockStatement.getBody().accept((PsiElementVisitor)this);
        this.myBuilder.startNode((PsiElement)rBeginEndBlockStatement);
    }

    public void visitRWhileModStatement(@NotNull RWhileModStatement rWhileModStatement) {
        if (rWhileModStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(46);
        }
        this.visitRLoop((RConditionalStatement)rWhileModStatement, rWhileModStatement.getCondition(), rWhileModStatement.getLoopBody(), true);
    }

    public void visitRUntilStatement(@NotNull RUntilStatement rUntilStatement) {
        if (rUntilStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(47);
        }
        this.visitRLoop((RConditionalStatement)rUntilStatement, rUntilStatement.getCondition(), (RPsiElement)rUntilStatement.getLoopBody(), false);
    }

    public void visitRUntilModStatement(@NotNull RUntilModStatement rUntilModStatement) {
        if (rUntilModStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(48);
        }
        this.visitRLoop((RConditionalStatement)rUntilModStatement, rUntilModStatement.getCondition(), rUntilModStatement.getLoopBody(), false);
    }

    private void visitRLoop(RConditionalStatement statement, RCondition condition, RPsiElement body, boolean exitOnFalse) {
        boolean postConditionLoop;
        boolean bl = postConditionLoop = statement instanceof RModifierStatement && body instanceof RBeginEndBlockStatement;
        if (postConditionLoop) {
            this.visitRPostLoop(statement, condition, body, exitOnFalse);
        } else {
            this.visitRPreLoop(statement, condition, body, exitOnFalse);
        }
    }

    private void visitRPostLoop(RConditionalStatement statement, RCondition condition, RPsiElement body, boolean exitOnFalse) {
        Instruction lastBodyInstruction;
        Instruction firstBodyInstruction;
        int firstBodyInstructionIndex = this.myBuilder.instructionCount;
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        if (firstBodyInstructionIndex < this.myBuilder.instructionCount) {
            firstBodyInstruction = (Instruction)this.myBuilder.instructions.get(firstBodyInstructionIndex);
            lastBodyInstruction = this.myBuilder.prevInstruction;
            this.finishLoop(firstBodyInstruction, statement, condition, exitOnFalse);
        } else {
            firstBodyInstruction = null;
            lastBodyInstruction = null;
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)statement);
        this.myBuilder.processPending((pendingScope, pendingInstruction) -> {
            if (statement == pendingScope) {
                PsiElement element = pendingInstruction.getElement();
                if (element instanceof RNextStatement) {
                    this.myBuilder.addEdge(pendingInstruction, lastBodyInstruction);
                } else if (element instanceof RRedoStatement) {
                    this.myBuilder.addEdge(pendingInstruction, firstBodyInstruction);
                } else {
                    this.myBuilder.addEdge(pendingInstruction, instruction);
                }
            } else {
                this.myBuilder.addPendingEdge(pendingScope, pendingInstruction);
            }
        });
    }

    private void visitRPreLoop(RConditionalStatement statement, RCondition condition, RPsiElement body, boolean exitOnFalse) {
        this.visitLoopCondition(condition);
        this.createLoopConditionExit(statement, condition, exitOnFalse);
        this.visitRPostLoop(statement, condition, body, exitOnFalse);
    }

    private void visitLoopCondition(RCondition condition) {
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
    }

    private void createLoopConditionExit(RConditionalStatement statement, RCondition condition, boolean exitOnFalse) {
        ConditionExitInstructions conditionInstructions = this.getConditionExitInstruction(condition);
        ConditionalInstruction trueBranch = this.addConditionalInstruction(conditionInstructions.trueBranch, (PsiElement)condition, exitOnFalse);
        ConditionalInstruction falseBranch = this.addConditionalInstruction(conditionInstructions.falseBranch, (PsiElement)condition, !exitOnFalse);
        this.myBuilder.prevInstruction = trueBranch;
        this.myBuilder.addPendingEdge((PsiElement)statement, (Instruction)falseBranch);
    }

    private void finishLoop(Instruction firstBodyInstruction, RConditionalStatement statement, RCondition condition, boolean exitOnFalse) {
        this.visitLoopCondition(condition);
        this.createLoopConditionExit(statement, condition, exitOnFalse);
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, firstBodyInstruction);
        this.myBuilder.flowAbrupted();
    }

    public void visitRCaseStatement(@NotNull RCaseStatement rCaseStatement) {
        RPsiElement expression;
        if (rCaseStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(49);
        }
        if ((expression = rCaseStatement.getExpression()) != null) {
            expression.accept((PsiElementVisitor)this);
        }
        Instruction condition = this.myBuilder.prevInstruction;
        ArrayList<Instruction> pendingInstructions = new ArrayList<Instruction>();
        for (RWhenCase whenCase : rCaseStatement.getCases()) {
            boolean patternMatching = whenCase.isPatternMatching();
            this.myBuilder.prevInstruction = condition;
            this.myBuilder.startNode((PsiElement)whenCase);
            RPsiElement caseExpr = whenCase.getCaseExpression();
            if (caseExpr != null) {
                if (patternMatching) {
                    this.myPatternMatchingCase = whenCase;
                }
                caseExpr.accept((PsiElementVisitor)this);
                this.myPatternMatchingCase = null;
                this.myBuilder.prevInstruction = this.addConditionalInstruction(ContainerUtil.createMaybeSingletonList((Object)this.myBuilder.prevInstruction), (PsiElement)caseExpr, true);
            }
            RCompoundStatement body = whenCase.getCaseBody();
            body.accept((PsiElementVisitor)this);
            pendingInstructions.add(this.myBuilder.prevInstruction);
        }
        RElseBlock elseBlock = rCaseStatement.getElseCase();
        this.myBuilder.prevInstruction = condition;
        if (elseBlock != null) {
            this.myBuilder.startNode((PsiElement)elseBlock);
            elseBlock.accept((PsiElementVisitor)this);
            pendingInstructions.add(this.myBuilder.prevInstruction);
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)rCaseStatement);
        for (Instruction pendingInstruction : pendingInstructions) {
            this.myBuilder.addEdge(pendingInstruction, instruction);
        }
    }

    public void visitRYieldStatement(@NotNull RYieldStatement rYieldStatement) {
        if (rYieldStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(50);
        }
        for (RPsiElement argument : rYieldStatement.getArguments()) {
            argument.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rYieldStatement);
    }

    public void visitRForStatement(@NotNull RForStatement rForStatement) {
        Instruction lastBodyInstruction;
        Instruction firstBodyInstruction;
        RPsiElement expr;
        if (rForStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(51);
        }
        Instruction firstExpressionInstruction = (expr = rForStatement.getExpression()) != null ? this.acceptAndGetFirstInstruction((PsiElement)expr) : null;
        Instruction lastExpressionInstruction = this.myBuilder.prevInstruction;
        RCompoundStatement body = rForStatement.getBody();
        if (body != null) {
            Instruction firstVariableInstruction = this.acceptAndGetFirstInstruction((PsiElement)rForStatement.getVariable());
            firstBodyInstruction = this.acceptAndGetFirstInstruction((PsiElement)body);
            lastBodyInstruction = this.myBuilder.prevInstruction;
            if (this.myBuilder.prevInstruction != null) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, firstVariableInstruction);
            }
        } else {
            firstBodyInstruction = null;
            lastBodyInstruction = null;
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)rForStatement);
        this.myBuilder.addEdge(lastExpressionInstruction, instruction);
        this.myBuilder.processPending((pendingScope, pendingInstruction) -> {
            if (pendingScope == rForStatement) {
                PsiElement element = pendingInstruction.getElement();
                if (element instanceof RRetryStatement) {
                    this.myBuilder.addEdge(pendingInstruction, firstExpressionInstruction);
                } else if (element instanceof RNextStatement) {
                    this.myBuilder.addEdge(pendingInstruction, lastBodyInstruction);
                } else if (element instanceof RRedoStatement) {
                    this.myBuilder.addEdge(pendingInstruction, firstBodyInstruction);
                } else {
                    this.myBuilder.addEdge(pendingInstruction, instruction);
                }
            } else {
                this.myBuilder.addPendingEdge(pendingScope, pendingInstruction);
            }
        });
    }

    public void visitRBreakStatement(@NotNull RBreakStatement breakStatement) {
        if (breakStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(52);
        }
        for (RPsiElement element : breakStatement.getParams()) {
            element.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)breakStatement);
        RLoopStatement loop = breakStatement.getLoop();
        if (loop != null) {
            this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
            this.myBuilder.flowAbrupted();
        }
    }

    public void visitRNextStatement(@NotNull RNextStatement rNextStatement) {
        RListOfExpressions expressions;
        if (rNextStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(53);
        }
        if ((expressions = rNextStatement.getExpressions()) != null) {
            this.visitRListOfExpressions(expressions);
        }
        this.visitJump((PsiElement)rNextStatement, (PsiElement)rNextStatement.getLoop());
    }

    public void visitRRedoStatement(@NotNull RRedoStatement rRedoStatement) {
        if (rRedoStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(54);
        }
        RLoopStatement loop = rRedoStatement.getLoop();
        this.visitJump((PsiElement)rRedoStatement, (PsiElement)loop);
    }

    public void visitRRetryStatement(@NotNull RRetryStatement rRetryStatement) {
        if (rRetryStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(55);
        }
        this.visitJump((PsiElement)rRetryStatement, (PsiElement)rRetryStatement.getRetryContext());
    }

    private void visitJump(PsiElement element, PsiElement context) {
        Instruction instruction = this.myBuilder.startNode(element);
        if (context != null) {
            if (context instanceof RBlockCall) {
                Instruction firstInstructionInBlockCall = (Instruction)this.myBuilder.instructions.get(1);
                while (firstInstructionInBlockCall.getElement() != null && RubyUsageAnalyzerCore.isParameterInScope((RPsiElement)((RPsiElement)firstInstructionInBlockCall.getElement()))) {
                    Iterator iterator = firstInstructionInBlockCall.allSucc().iterator();
                    if (iterator.hasNext()) {
                        firstInstructionInBlockCall = (Instruction)iterator.next();
                        continue;
                    }
                    LOG.error("Missing successors on: element: " + String.valueOf(element) + "; context: " + String.valueOf(context) + "; current: " + String.valueOf(firstInstructionInBlockCall.getElement()), new Attachment[]{new Attachment("codeSample.txt", context.getText())});
                    break;
                }
                this.myBuilder.addEdge(instruction, firstInstructionInBlockCall);
            } else {
                this.myBuilder.addPendingEdge(context, instruction);
            }
            this.myBuilder.flowAbrupted();
        }
    }

    public void visitRBodyStatement(@NotNull RBodyStatement rBodyStatement) {
        if (rBodyStatement == null) {
            RControlFlowBuilder.$$$reportNull$$$0(56);
        }
        RCompoundStatement compoundStatement = rBodyStatement.getCompoundStatement();
        int firstBlockInstructionIndex = this.myBuilder.instructionCount;
        compoundStatement.accept((PsiElementVisitor)this);
        Instruction firstBlockInstruction = (Instruction)this.myBuilder.instructions.get(firstBlockInstructionIndex);
        Instruction lastBlockInstruction = this.myBuilder.prevInstruction;
        RElseBlock elseBlock = rBodyStatement.getElseBlock();
        if (elseBlock != null) {
            this.myBuilder.startNode((PsiElement)elseBlock);
            elseBlock.accept((PsiElementVisitor)this);
        }
        this.myBuilder.addPendingEdge((PsiElement)rBodyStatement, this.myBuilder.prevInstruction);
        ArrayList<Instruction> rescueInstructions = new ArrayList<Instruction>();
        for (RRescueBlock rescueBlock : rBodyStatement.getRescueBlocks()) {
            this.myBuilder.prevInstruction = lastBlockInstruction;
            Instruction rescueInstruction = this.myBuilder.startNode((PsiElement)rescueBlock);
            rescueBlock.accept((PsiElementVisitor)this);
            rescueInstructions.add(rescueInstruction);
            this.myBuilder.addPendingEdge((PsiElement)rBodyStatement, this.myBuilder.prevInstruction);
        }
        this.addEdgesFromAllPossibleRaiseExceptionCalls(firstBlockInstruction, lastBlockInstruction, rescueInstructions);
        REnsureBlock ensureBlock = rBodyStatement.getEnsureBlock();
        Instruction firstEnsureInstruction = null;
        Instruction lastEnsureInstruction = null;
        if (ensureBlock != null) {
            firstEnsureInstruction = this.myBuilder.startNode((PsiElement)ensureBlock);
            ensureBlock.accept((PsiElementVisitor)this);
            lastEnsureInstruction = this.myBuilder.prevInstruction;
            this.myBuilder.addPendingEdge((PsiElement)ensureBlock, lastEnsureInstruction);
        }
        Ref firstEnsureRef = new Ref(firstEnsureInstruction);
        Ref lastEnsureRef = new Ref(lastEnsureInstruction);
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement pendingElement = instruction.getElement();
            if (pendingScope == rBodyStatement && pendingElement instanceof RRetryStatement) {
                this.myBuilder.addEdge(instruction, firstBlockInstruction);
                return;
            }
            if (RControlFlowBuilder.isRaiseInstruction(instruction, pendingElement) && PsiTreeUtil.isAncestor((PsiElement)compoundStatement, (PsiElement)pendingElement, (boolean)false)) {
                for (Instruction rescueInstruction : rescueInstructions) {
                    this.myBuilder.addEdge(instruction, rescueInstruction);
                }
                if (ensureBlock != null) {
                    this.myBuilder.addEdge(instruction, (Instruction)firstEnsureRef.get());
                } else if (rescueInstructions.isEmpty()) {
                    this.myBuilder.addPendingEdge(pendingScope, instruction);
                }
                return;
            }
            if (pendingElement != null && instruction instanceof ReturnInstruction && !firstEnsureRef.isNull() && PsiTreeUtil.isAncestor((PsiElement)rBodyStatement, (PsiElement)pendingElement, (boolean)false)) {
                this.myBuilder.addEdge(instruction, (Instruction)firstEnsureRef.get());
                this.myBuilder.addPendingEdge(null, (Instruction)lastEnsureRef.get());
                return;
            }
            if (pendingElement != null && ensureBlock != null && pendingScope != ensureBlock && PsiTreeUtil.isAncestor((PsiElement)rBodyStatement, (PsiElement)pendingElement, (boolean)false)) {
                this.myBuilder.addEdge(instruction, (Instruction)firstEnsureRef.get());
                return;
            }
            this.myBuilder.addPendingEdge(pendingScope, instruction);
        });
    }

    private static boolean isRaiseInstruction(Instruction instruction, PsiElement element) {
        if (instruction instanceof RaiseInstruction) {
            return true;
        }
        if (element == null) {
            return false;
        }
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class);
        return call != null && RubyCallTypesCore.isRaiseCall((RPossibleCall)call);
    }

    private void visitRaiseOrThrow(@NotNull RPossibleCall call) {
        RArgument argument;
        if (call == null) {
            RControlFlowBuilder.$$$reportNull$$$0(57);
        }
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        PsiElement parent = call.getParent();
        if (!(parent instanceof RArgument) || !(argument = (RArgument)parent).getType().isOptional()) {
            this.myBuilder.flowAbrupted();
        }
    }

    public void visitRHeredocId(@NotNull RHeredocId heredocId) {
        RHeredocValue value;
        if (heredocId == null) {
            RControlFlowBuilder.$$$reportNull$$$0(58);
        }
        if ((value = heredocId.getHeredocValue()) != null) {
            this.visitChildren((PsiElement)value);
            this.myBuilder.startNode((PsiElement)value);
        }
    }

    public void visitRHeredocValue(@NotNull RHeredocValue heredocValue) {
        if (heredocValue == null) {
            RControlFlowBuilder.$$$reportNull$$$0(59);
        }
    }

    public void visitRArrayToArguments(@NotNull RArrayToArguments rArrayToArguments) {
        if (rArrayToArguments == null) {
            RControlFlowBuilder.$$$reportNull$$$0(60);
        }
        if (rArrayToArguments.getArray() != null) {
            rArrayToArguments.getArray().accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rArrayToArguments);
    }

    public void visitGroupedExpression(@NotNull RGroupedExpression groupedExpression) {
        if (groupedExpression == null) {
            RControlFlowBuilder.$$$reportNull$$$0(61);
        }
        if (groupedExpression.getExpression() != null) {
            groupedExpression.getExpression().accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)groupedExpression);
    }

    public void visitRLambda(@NotNull RLambda rLambda) {
        if (rLambda == null) {
            RControlFlowBuilder.$$$reportNull$$$0(62);
        }
        Instruction prevInstruction = this.myBuilder.prevInstruction;
        this.visitChildren((PsiElement)rLambda);
        Instruction instruction = this.myBuilder.startNode((PsiElement)rLambda);
        this.myBuilder.addEdge(prevInstruction, instruction);
    }

    public void visitRArrayPattern(@NotNull RArrayPattern rArrayPattern) {
        if (rArrayPattern == null) {
            RControlFlowBuilder.$$$reportNull$$$0(63);
        }
        for (PsiElement element : rArrayPattern.getPatternElements()) {
            element.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rArrayPattern);
    }

    public void visitRHashPattern(@NotNull RHashPattern rHashPattern) {
        if (rHashPattern == null) {
            RControlFlowBuilder.$$$reportNull$$$0(64);
        }
        for (PsiElement element : rHashPattern.getPatternElements()) {
            if (element instanceof RAssoc) {
                RPsiElement value = ((RAssoc)element).getValue();
                RPsiElement key = ((RAssoc)element).getKey();
                if (key != null && value != null) {
                    RWhenCase savedPatternMatchingCase = this.myPatternMatchingCase;
                    this.myPatternMatchingCase = null;
                    key.accept((PsiElementVisitor)this);
                    this.myPatternMatchingCase = savedPatternMatchingCase;
                    value.accept((PsiElementVisitor)this);
                    continue;
                }
                if (key != null) {
                    key.accept((PsiElementVisitor)this);
                    continue;
                }
                if (value == null) continue;
                value.accept((PsiElementVisitor)this);
                continue;
            }
            element.accept((PsiElementVisitor)this);
        }
        this.myBuilder.startNode((PsiElement)rHashPattern);
    }

    public void visitRAltPattern(@NotNull RAltPattern rAltPattern) {
        if (rAltPattern == null) {
            RControlFlowBuilder.$$$reportNull$$$0(65);
        }
        Instruction prevInstruction = this.myBuilder.prevInstruction;
        ArrayList<Instruction> lastPatternInstructions = new ArrayList<Instruction>();
        for (PsiElement element : rAltPattern.getPatternElements()) {
            this.myBuilder.prevInstruction = prevInstruction;
            element.accept((PsiElementVisitor)this);
            lastPatternInstructions.add(this.myBuilder.prevInstruction);
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)rAltPattern);
        for (Instruction lastPatternInstruction : lastPatternInstructions) {
            this.myBuilder.addEdge(lastPatternInstruction, instruction);
        }
    }

    public void visitRGuardedPattern(@NotNull RGuardedPatternBase rGuardedPattern) {
        if (rGuardedPattern == null) {
            RControlFlowBuilder.$$$reportNull$$$0(66);
        }
        RPsiElement pattern = rGuardedPattern.getPattern();
        RCondition condition = rGuardedPattern.getCondition();
        if (pattern != null) {
            pattern.accept((PsiElementVisitor)this);
        }
        RWhenCase savedPatternMatchingCase = this.myPatternMatchingCase;
        this.myPatternMatchingCase = null;
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
        this.myPatternMatchingCase = savedPatternMatchingCase;
        this.myBuilder.startNode((PsiElement)rGuardedPattern);
    }

    public void visitRPatternVarRef(@NotNull RPatternVarRef rPatternVarRef) {
        if (rPatternVarRef == null) {
            RControlFlowBuilder.$$$reportNull$$$0(67);
        }
        RWhenCase savedPatternMatchingCase = this.myPatternMatchingCase;
        this.myPatternMatchingCase = null;
        RExpression variable = rPatternVarRef.getVariable();
        if (variable != null) {
            variable.accept((PsiElementVisitor)this);
        }
        this.myPatternMatchingCase = savedPatternMatchingCase;
        this.myBuilder.startNode((PsiElement)rPatternVarRef);
    }

    public void visitRVariableBind(@NotNull RVariableBind rVariableBind) {
        if (rVariableBind == null) {
            RControlFlowBuilder.$$$reportNull$$$0(68);
        }
        RPsiElement pattern = rVariableBind.getPattern();
        RIdentifier variable = rVariableBind.getVariable();
        pattern.accept((PsiElementVisitor)this);
        if (variable != null) {
            variable.accept((PsiElementVisitor)this);
        }
    }

    private Instruction findLastNonBoolBinInstruction() {
        int counter = this.myBuilder.instructionCount - 1;
        while (((Instruction)this.myBuilder.instructions.get(counter)).getElement() instanceof RBoolBinExpression) {
            --counter;
        }
        return (Instruction)this.myBuilder.instructions.get(counter);
    }

    @Contract(value="_, null, _ -> null")
    @Nullable
    private ConditionalInstruction addConditionalInstruction(@NotNull Iterable<Instruction> fromInstructions, @Nullable PsiElement condition, boolean result) {
        if (fromInstructions == null) {
            RControlFlowBuilder.$$$reportNull$$$0(69);
        }
        if (condition == null) {
            return null;
        }
        this.myBuilder.flowAbrupted();
        ConditionalInstructionImpl retInstruction = new ConditionalInstructionImpl(this.myBuilder, null, condition, result);
        this.myBuilder.addNode((Instruction)retInstruction);
        for (Instruction instruction : fromInstructions) {
            this.myBuilder.addEdge(instruction, (Instruction)retInstruction);
        }
        return retInstruction;
    }

    private static boolean isRaiseOrFailCall(@Nullable PsiElement element) {
        RPossibleCall possibleCall;
        return element instanceof RPossibleCall && RubyCallTypesCore.isRaiseCall((RPossibleCall)(possibleCall = (RPossibleCall)element));
    }

    private static boolean isThrowCall(@Nullable PsiElement element) {
        RPossibleCall possibleCall;
        return element instanceof RPossibleCall && RubyCallTypesCore.isThrowCall((RPossibleCall)(possibleCall = (RPossibleCall)element));
    }

    private void addConstantAssignmentInstructionIfPresent(final @NotNull RConstant constant, final @Nullable RAssignmentExpression assignmentExpression) {
        if (constant == null) {
            RControlFlowBuilder.$$$reportNull$$$0(70);
        }
        if (assignmentExpression != null) {
            this.myBuilder.addNodeAndCheckPending((Instruction)new ReadWriteInstructionImpl(this, this.myBuilder, (RPsiElement)constant, constant.getName()){

                public Access getAccess() {
                    return UsageAnalyzer.createAssignAccess((RPsiElement)constant, assignmentExpression);
                }
            });
        }
    }

    private Instruction acceptAndGetFirstInstruction(@NotNull PsiElement element) {
        if (element == null) {
            RControlFlowBuilder.$$$reportNull$$$0(71);
        }
        int firstInstructionIndex = this.myBuilder.instructionCount;
        element.accept((PsiElementVisitor)this);
        if (firstInstructionIndex < this.myBuilder.instructionCount) {
            return (Instruction)this.myBuilder.instructions.get(firstInstructionIndex);
        }
        return null;
    }

    private void addEdgesFromAllPossibleRaiseExceptionCalls(@NotNull Instruction firstBlockInstruction, @NotNull Instruction lastInclusiveBlockInstruction, @NotNull List<Instruction> rescueInstructions) {
        if (firstBlockInstruction == null) {
            RControlFlowBuilder.$$$reportNull$$$0(72);
        }
        if (lastInclusiveBlockInstruction == null) {
            RControlFlowBuilder.$$$reportNull$$$0(73);
        }
        if (rescueInstructions == null) {
            RControlFlowBuilder.$$$reportNull$$$0(74);
        }
        try {
            this.addEdgesFromAllPossibleRaiseExceptionCalls(firstBlockInstruction, lastInclusiveBlockInstruction, rescueInstructions, new HashSet<Instruction>());
        }
        catch (InvalidInstructionBlockException e) {
            throw new InvalidInstructionBlockException(String.format("Instruction range: %s - %s isn't https://en.wikipedia.org/wiki/Basic_block", firstBlockInstruction, lastInclusiveBlockInstruction));
        }
    }

    private void addEdgesFromAllPossibleRaiseExceptionCalls(@NotNull Instruction currentInstruction, @NotNull Instruction lastInclusiveBlockInstruction, @NotNull List<Instruction> rescueInstructions, @NotNull Set<Instruction> visited) {
        if (currentInstruction == null) {
            RControlFlowBuilder.$$$reportNull$$$0(75);
        }
        if (lastInclusiveBlockInstruction == null) {
            RControlFlowBuilder.$$$reportNull$$$0(76);
        }
        if (rescueInstructions == null) {
            RControlFlowBuilder.$$$reportNull$$$0(77);
        }
        if (visited == null) {
            RControlFlowBuilder.$$$reportNull$$$0(78);
        }
        while (!visited.contains(currentInstruction)) {
            visited.add(currentInstruction);
            SmartList succ = new SmartList(currentInstruction.allSucc());
            PsiElement element = currentInstruction.getElement();
            if (RControlFlowBuilder.canRaiseException(element)) {
                for (Instruction rescueInstruction : rescueInstructions) {
                    this.myBuilder.addEdge(currentInstruction, rescueInstruction);
                }
            }
            if (currentInstruction == lastInclusiveBlockInstruction) {
                return;
            }
            if (succ.size() == 1) {
                currentInstruction = (Instruction)succ.get(0);
                continue;
            }
            for (Instruction next : succ) {
                if (next == lastInclusiveBlockInstruction) {
                    throw new InvalidInstructionBlockException();
                }
                this.addEdgesFromAllPossibleRaiseExceptionCalls(next, lastInclusiveBlockInstruction, rescueInstructions, visited);
            }
            return;
        }
    }

    private static boolean canRaiseException(@Nullable PsiElement element) {
        RReference rReference;
        if (!(element instanceof RPsiElement) || RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)element) != null || element instanceof RPseudoConstant || element instanceof RAssignmentExpression) {
            return false;
        }
        if (element instanceof RReference && (rReference = (RReference)element).isConstructorLike()) {
            return false;
        }
        return element instanceof RPossibleCall;
    }

    public static int getMaxCfgSize() {
        return Registry.intValue((String)"ruby.control.flow.max.size", (int)2200);
    }

    public static int getMaxListElementsForCfgToBuild() {
        return Registry.intValue((String)"ruby.control.flow.max.list.size", (int)120);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCompoundStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReturnStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAssocList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/impl/RControlFlowBuilder";
                break;
            }
            case 10: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaCall";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiAssignmentExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIntegerConstant";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFloatConstant";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStringLiteral";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDStringLiteral";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStrings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbol";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbols";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdSymbols";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPseudoConstant";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBinaryExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rRescueModStatement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFid";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndexing";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rTopConstReference";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rGlobalVariable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rInstanceVariable";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClassVariable";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ternaryExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnlessStatement";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnlessModStatement";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rWhileStatement";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBeginEndBlockStatement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rWhileModStatement";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUntilStatement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUntilModStatement";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCaseStatement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rYieldStatement";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rForStatement";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rNextStatement";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rRedoStatement";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rRetryStatement";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBodyStatement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocId";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocValue";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArrayToArguments";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedExpression";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rLambda";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArrayPattern";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rHashPattern";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAltPattern";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rGuardedPattern";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPatternVarRef";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rVariableBind";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromInstructions";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstBlockInstruction";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastInclusiveBlockInstruction";
                break;
            }
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rescueInstructions";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/impl/RControlFlowBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildrenOrEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildControlFlow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitRClassObject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitRCompoundStatement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitRReturnStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitRBlockCall";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssocList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenOrEmpty";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitRLambdaCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssignmentExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitRMultiAssignmentExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitRIntegerConstant";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitRFloatConstant";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitRStringLiteral";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitRDStringLiteral";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitRStrings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbol";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbols";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitRDSymbols";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitRWords";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitRDWords";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnaryExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitRPseudoConstant";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitRBinaryExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolBinExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitRRescueModStatement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitRArgument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitRFid";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitRArray";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayIndexing";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitRIdentifier";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitRConstant";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitRTopConstReference";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitRGlobalVariable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitRInstanceVariable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitRClassVariable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitRIfStatement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitRIfModStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitRTernaryExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnlessStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnlessModStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitRWhileStatement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitRBeginEndBlockStatement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitRWhileModStatement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitRUntilStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitRUntilModStatement";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitRCaseStatement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitRYieldStatement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitRForStatement";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitRBreakStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitRNextStatement";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitRRedoStatement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitRRetryStatement";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitRBodyStatement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitRaiseOrThrow";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitRHeredocId";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitRHeredocValue";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayToArguments";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitGroupedExpression";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitRLambda";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayPattern";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitRHashPattern";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitRAltPattern";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitRGuardedPattern";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "visitRPatternVarRef";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitRVariableBind";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addConditionalInstruction";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addConstantAssignmentInstructionIfPresent";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "acceptAndGetFirstInstruction";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addEdgesFromAllPossibleRaiseExceptionCalls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    public static final class InvalidInstructionBlockException
    extends RuntimeException {
        private InvalidInstructionBlockException() {
        }

        private InvalidInstructionBlockException(@NotNull String message) {
            if (message == null) {
                InvalidInstructionBlockException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/impl/RControlFlowBuilder$InvalidInstructionBlockException", "<init>"));
        }
    }

    private static final class ConditionExitInstructions {
        public final Collection<Instruction> trueBranch;
        public final Collection<Instruction> falseBranch;

        private ConditionExitInstructions(Collection<Instruction> trueBranch, Collection<Instruction> falseBranch) {
            this.trueBranch = trueBranch;
            this.falseBranch = falseBranch;
        }
    }
}

