/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.LanguageStubDefinition;
import com.intellij.psi.stubs.LightLanguageStubDefinition;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SummaryBuilderInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SummaryTypeInferenceVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyParser;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyParserDefinition;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RubyPsiBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RFileImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RubyFileStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.containers.RubyFileStubImpl;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/parser/RubyStubDefinition;", "Lcom/intellij/psi/stubs/LightLanguageStubDefinition;", "Lcom/intellij/psi/stubs/LanguageStubDefinition;", "<init>", "()V", "language", "Lcom/intellij/lang/Language;", "parseContentsLight", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "chameleon", "Lcom/intellij/lang/ASTNode;", "stubVersion", "", "getStubVersion", "()I", "builder", "Lcom/intellij/psi/StubBuilder;", "getBuilder", "()Lcom/intellij/psi/StubBuilder;", "RubyFileStubSerializer", "intellij.ruby.backend"})
public final class RubyStubDefinition
implements LightLanguageStubDefinition,
LanguageStubDefinition {
    @NotNull
    private final Language language;

    public RubyStubDefinition() {
        RubyLanguage rubyLanguage = RubyLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)rubyLanguage, (String)"INSTANCE");
        this.language = (Language)rubyLanguage;
    }

    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(@NotNull ASTNode chameleon) {
        Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
        LanguageLevel languageLevel = RubyPsiUtilCore.getLanguageLevel((PsiElement)chameleon.getPsi());
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevel(...)");
        LanguageLevel languageLevel2 = languageLevel;
        RubyPsiBuilder rubyPsiBuilder = RubyPsiBuilder.create((ASTNode)chameleon, (Language)this.language);
        Intrinsics.checkNotNullExpressionValue((Object)rubyPsiBuilder, (String)"create(...)");
        RubyPsiBuilder builder2 = rubyPsiBuilder;
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = new RubyParser(languageLevel2).parseLight((IElementType)RubyParserDefinition.FILE, (PsiBuilder)builder2);
        Intrinsics.checkNotNullExpressionValue((Object)flyweightCapableTreeStructure, (String)"parseLight(...)");
        return flyweightCapableTreeStructure;
    }

    public int getStubVersion() {
        return 184 + RubyCallTypeRegistry.getInstance().getStubsVersion() + (RControlFlowBuilder.getMaxCfgSize() << 1) + (RControlFlowBuilder.getMaxListElementsForCfgToBuild() << 2) + (TypeInferenceContext.getMaxTypeInferenceCfgSize() << 3) + (SummaryTypeInferenceVisitor.getMaxElementsNumberToAnalyze() << 4) + (SummaryBuilderInstance.getMaxSummaryGraphCfgSize() << 5) + (SummaryBuilderInstance.getRubyIndexStringLimit() << 6);
    }

    @NotNull
    public StubBuilder getBuilder() {
        return (StubBuilder)new DefaultStubBuilder(){

            protected StubElement<?> createStubForFile(PsiFile file) {
                StubElement stubElement;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file instanceof RFileImpl) {
                    stubElement = (StubElement)new RubyFileStubImpl((RFile)file, ((RFileImpl)file).getPragmas(), RubyParserDefinition.FILE);
                } else {
                    StubElement stubElement2 = super.createStubForFile(file);
                    stubElement = stubElement2;
                    Intrinsics.checkNotNullExpressionValue((Object)stubElement2, (String)"createStubForFile(...)");
                }
                return stubElement;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/parser/RubyStubDefinition$RubyFileStubSerializer;", "Lcom/intellij/psi/stubs/StubSerializer;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/containers/RubyFileStub;", "<init>", "()V", "fileElementType", "Lcom/intellij/psi/tree/IFileElementType;", "getFileElementType", "()Lcom/intellij/psi/tree/IFileElementType;", "getExternalId", "", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.ruby.backend"})
    public static class RubyFileStubSerializer
    implements StubSerializer<RubyFileStub> {
        @NotNull
        private final IFileElementType fileElementType;

        public RubyFileStubSerializer() {
            IFileElementType iFileElementType = RubyParserDefinition.FILE;
            Intrinsics.checkNotNullExpressionValue((Object)iFileElementType, (String)"FILE");
            this.fileElementType = iFileElementType;
        }

        @NotNull
        public IFileElementType getFileElementType() {
            return this.fileElementType;
        }

        @NotNull
        public String getExternalId() {
            return "ruby.FILE";
        }

        public void serialize(@NotNull RubyFileStub stub, @NotNull StubOutputStream dataStream) {
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            Map map = stub.getPragmas();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getPragmas(...)");
            Map pragmas = map;
            dataStream.writeVarInt(pragmas.size());
            for (Map.Entry pragma : pragmas.entrySet()) {
                dataStream.writeName((String)pragma.getKey());
                dataStream.writeName((String)pragma.getValue());
            }
        }

        @NotNull
        public RubyFileStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            int size = dataStream.readVarInt();
            Map pragmas = new LinkedHashMap();
            int n = 0;
            while (n < size) {
                int it = n++;
                boolean bl = false;
                String string = dataStream.readNameString();
                Intrinsics.checkNotNull((Object)string);
                String string2 = dataStream.readNameString();
                Intrinsics.checkNotNull((Object)string2);
                pragmas.put(string, string2);
            }
            return new RubyFileStubImpl(pragmas, this.getFileElementType());
        }

        public void indexStub(@NotNull RubyFileStub stub, @NotNull IndexSink sink) {
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        }
    }
}

