/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

final class RubyCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private final boolean myIsValidResult;
    private final boolean myShouldShowContainer;
    private final int myUsagesCount;

    RubyCallHierarchyNodeDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase, boolean isValidResult, boolean shouldShowContainer, int usagesCount) {
        if (element == null) {
            RubyCallHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(element.getProject(), parentDescriptor, element, isBase);
        this.myIsValidResult = isValidResult;
        this.myShouldShowContainer = shouldShowContainer;
        this.myUsagesCount = usagesCount;
    }

    public boolean isValidResult() {
        return this.myIsValidResult;
    }

    @Nullable
    public NavigatablePsiElement getPresentationElement() {
        NavigatablePsiElement element = (NavigatablePsiElement)this.getPsiElement();
        if (element instanceof RPossibleCall && this.myShouldShowContainer) {
            return ((RPossibleCall)element).getParentContainer();
        }
        return element;
    }

    @Nullable
    protected Icon getIcon(@NotNull PsiElement element) {
        if (element == null) {
            RubyCallHierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        return (Icon)ObjectUtils.doIfNotNull((Object)this.getPresentationElement(), e -> super.getIcon((PsiElement)e));
    }

    public boolean update() {
        boolean changes = super.update();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        NavigatablePsiElement element = this.getPresentationElement();
        if (element == null) {
            return this.invalidElement();
        }
        ItemPresentation presentation = element.getPresentation();
        if (presentation != null && element instanceof RContainer) {
            String nameWithLocation = RContainerPresentationUtil.getContainerNameWithLocation((RContainer)((RContainer)element), (boolean)true);
            this.myHighlightedText.getEnding().addText(nameWithLocation, (TextAttributes)null);
        } else if (element instanceof PsiFile) {
            this.myHighlightedText.getEnding().addText(element.getName(), (TextAttributes)null);
        } else {
            this.myHighlightedText.getEnding().addText(RBundle.message((String)"class.anonymous"), (TextAttributes)null);
        }
        if (this.myUsagesCount > 1) {
            this.myHighlightedText.getEnding().addText(" (" + this.myUsagesCount + ")");
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/hierarchy/call/RubyCallHierarchyNodeDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

