/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubySpacingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class RubyPreFormatProcessor
implements PreFormatProcessor {
    private static final TokenSet TAILS_REQUIRES_SEMICOLON = TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.SUPER_CLASS, RubyElementTypes.NAME, RubyElementTypes.CLASS_OBJECT});

    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange rangeInElement) {
        PsiElement psiElement;
        if (element == null) {
            RubyPreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (rangeInElement == null) {
            RubyPreFormatProcessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid() || !psiElement.getLanguage().isKindOf((Language)RubyLanguage.INSTANCE)) {
            TextRange textRange = rangeInElement;
            if (textRange == null) {
                RubyPreFormatProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            TextRange textRange = rangeInElement;
            if (textRange == null) {
                RubyPreFormatProcessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        RubyCodeStyleSettings rubySettings = RubyCodeStyleSettings.getInstance((PsiElement)psiElement);
        if (rubySettings.EMPTY_DECLARATIONS_STYLE != 1) {
            TextRange textRange = rangeInElement;
            if (textRange == null) {
                RubyPreFormatProcessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiElement.getProject());
        final Document document = psiDocumentManager.getDocument(containingFile);
        if (document == null) {
            TextRange textRange = rangeInElement;
            if (textRange == null) {
                RubyPreFormatProcessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        int elementStartOffset = psiElement.getTextRange().getStartOffset();
        final TextRange rangeInDocument = rangeInElement.shiftRight(elementStartOffset);
        final ArrayList adjustments = new ArrayList();
        psiElement.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(this){

            public void visitRBodyStatement(@NotNull RBodyStatement rBodyStatement) {
                PsiElement prevChild;
                if (rBodyStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!rBodyStatement.getTextRange().isEmpty() || !rangeInDocument.contains(rBodyStatement.getTextRange())) {
                    super.visitRBodyStatement(rBodyStatement);
                    return;
                }
                IElementType parentType = PsiUtilCore.getElementType((PsiElement)rBodyStatement.getParent());
                if (!((TokenSet)RubySpacingProcessor.POSSIBLE_SINGLE_LINERS.get()).contains(parentType)) {
                    return;
                }
                int newLineOffset = -1;
                for (prevChild = rBodyStatement.getPrevSibling(); prevChild != null; prevChild = prevChild.getPrevSibling()) {
                    if (RubySpaceUtil.isEol((PsiElement)prevChild)) {
                        newLineOffset = prevChild.getTextOffset();
                        continue;
                    }
                    if (!(prevChild instanceof PsiWhiteSpace) && !prevChild.getTextRange().isEmpty()) break;
                }
                int offsetToInsert = newLineOffset;
                if (newLineOffset > -1 && TAILS_REQUIRES_SEMICOLON.contains(PsiUtilCore.getElementType((PsiElement)prevChild))) {
                    adjustments.add(() -> document.insertString(offsetToInsert, (CharSequence)";"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rBodyStatement", "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyPreFormatProcessor$1", "visitRBodyStatement"));
            }
        });
        int oldDocumentLength = document.getTextLength();
        for (int i = adjustments.size() - 1; i >= 0; --i) {
            ((Runnable)adjustments.get(i)).run();
        }
        psiDocumentManager.commitDocument(document);
        TextRange textRange = rangeInDocument.grown(document.getTextLength() - oldDocumentLength).shiftLeft(elementStartOffset);
        if (textRange == null) {
            RubyPreFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyPreFormatProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyPreFormatProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

