/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyHeredocUtil;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

final class RubyHeredocPostFormatter
implements PostFormatProcessor {
    RubyHeredocPostFormatter() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(1);
        }
        if (!RubyHeredocPostFormatter.checkIsRuby23(source)) {
            PsiElement psiElement = source;
            if (psiElement == null) {
                RubyHeredocPostFormatter.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)source.getProject()).createSmartPsiElementPointer(source);
        PsiFile file = source.getContainingFile();
        TextRange newRange = this.processText(file, source.getTextRange(), settings);
        if (pointer.getElement() != null) {
            PsiElement psiElement = pointer.getElement();
            if (psiElement == null) {
                RubyHeredocPostFormatter.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiElement element1 = file.findElementAt(newRange.getStartOffset());
        PsiElement element2 = file.findElementAt(newRange.getEndOffset());
        if (element1 == null || element2 == null) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                RubyHeredocPostFormatter.$$$reportNull$$$0(4);
            }
            return psiFile;
        }
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2), (Object)file);
        if (psiElement == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(6);
        }
        if (rangeToReformat == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(8);
        }
        if (!RubyHeredocPostFormatter.checkIsRuby23((PsiElement)source)) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                RubyHeredocPostFormatter.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        Document document = PsiDocumentManager.getInstance((Project)source.getProject()).getDocument(source);
        if (document == null) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                RubyHeredocPostFormatter.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        Project project = source.getProject();
        Visitor visitor = new Visitor(project, document, null);
        visitor.visitElement((PsiElement)source);
        List<Pair<TextRange, CharSequence>> replacements = visitor.myReplacements;
        int delta = 0;
        for (int i = replacements.size() - 1; i >= 0; --i) {
            Pair<TextRange, CharSequence> replacement = replacements.get(i);
            TextRange first = (TextRange)replacement.getFirst();
            CharSequence second = (CharSequence)replacement.getSecond();
            document.replaceString(first.getStartOffset(), first.getEndOffset(), second);
            delta += second.length() - first.getLength();
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        TextRange textRange = TextRange.from((int)rangeToReformat.getStartOffset(), (int)Math.max(0, rangeToReformat.getLength() + delta));
        if (textRange == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    private static boolean checkIsRuby23(@NotNull PsiElement source) {
        if (source == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(12);
        }
        return source.getLanguage() == RubyLanguage.INSTANCE && !RubyPsiUtilCore.getLanguageLevel((PsiElement)source).isLessThan(LanguageLevel.RUBY23);
    }

    @NotNull
    private static String createNewIndent(@NotNull String indent, int plusIndent, boolean useTabs) {
        int spacesInTheEnd;
        if (indent == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(13);
        }
        if (!useTabs) {
            String string = indent + StringUtil.repeatSymbol((char)' ', (int)plusIndent);
            if (string == null) {
                RubyHeredocPostFormatter.$$$reportNull$$$0(14);
            }
            return string;
        }
        for (spacesInTheEnd = 0; spacesInTheEnd < indent.length() && indent.charAt(indent.length() - spacesInTheEnd - 1) == ' '; ++spacesInTheEnd) {
        }
        String string = indent.substring(0, indent.length() - spacesInTheEnd) + StringUtil.repeatSymbol((char)'\t', (int)((plusIndent + spacesInTheEnd) / 8)) + StringUtil.repeatSymbol((char)' ', (int)((plusIndent + spacesInTheEnd) % 8));
        if (string == null) {
            RubyHeredocPostFormatter.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 9, 10, 11, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkIsRuby23";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNewIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 9, 10, 11, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class Visitor
    extends RubyRecursiveElementVisitor {
        @NotNull
        private final Document myDocument;
        @Nullable
        private final TextRange myTextRange;
        @NotNull
        private final CodeStyleFacade myCodeStyleFacade;
        @NotNull
        private final List<Pair<TextRange, CharSequence>> myReplacements;

        private Visitor(@NotNull Project project, @NotNull Document document, @Nullable TextRange range) {
            if (project == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (document == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.myReplacements = new ArrayList<Pair<TextRange, CharSequence>>();
            this.myDocument = document;
            this.myTextRange = range;
            this.myCodeStyleFacade = CodeStyleFacade.getInstance((Project)project);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (this.myTextRange != null && !element.getTextRange().intersects(this.myTextRange)) {
                return;
            }
            super.visitElement(element);
            if (TokenBNF.tHEREDOC_ENDS.contains(PsiUtilCore.getElementType((PsiElement)element))) {
                this.visitHeredocEnd(element);
            }
        }

        public void visitRHeredocValue(@NotNull RHeredocValue heredocValue) {
            RHeredocId idElement;
            if (heredocValue == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (!RubyHeredocUtil.isSquiggly((String)(idElement = heredocValue.getIdElement()).getIdPrefix())) {
                return;
            }
            int indentSize = this.myCodeStyleFacade.getIndentSize((FileType)RubyFileType.RUBY);
            int idElementTextOffset = idElement.getTextRange().getStartOffset();
            int lineStartOffset = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(idElementTextOffset));
            String parentIndent = StringUtil.notNullize((String)CodeStyleManager.getInstance((Project)heredocValue.getProject()).getLineIndent(this.myDocument, lineStartOffset));
            if (RubyTextUtil.getLineIndent((CharSequence)parentIndent, (int)8) + indentSize == heredocValue.getIndent()) {
                return;
            }
            boolean useTabs = this.myCodeStyleFacade.useTabCharacter((FileType)RubyFileType.RUBY);
            String newIndent = RubyHeredocPostFormatter.createNewIndent(parentIndent, indentSize, useTabs);
            List lines = heredocValue.getContentLines();
            List newLines = ContainerUtil.map((Collection)lines, line -> {
                if (line.isEmpty()) {
                    return line.toString();
                }
                return newIndent + String.valueOf(line);
            });
            String newContents = StringUtil.join((Collection)newLines, (String)"\n");
            this.myReplacements.add((Pair<TextRange, CharSequence>)Pair.create((Object)heredocValue.getTextRange(), (Object)newContents));
        }

        public void visitHeredocEnd(@NotNull PsiElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            Project project = element.getProject();
            RHeredocId id = (RHeredocId)ObjectUtils.doIfNotNull((Object)((RHeredocValue)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, RHeredocValue.class)), RHeredocValue::getIdElement);
            if (id == null || id.getIdPrefix().equals("<<")) {
                return;
            }
            int idOffset = id.getTextRange().getStartOffset();
            int idLineOffset = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(idOffset));
            int endOffset = element.getTextRange().getStartOffset();
            int endLineOffset = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(endOffset));
            int endIndent = endOffset - endLineOffset;
            String indent = StringUtil.notNullize((String)CodeStyleManager.getInstance((Project)project).getLineIndent(this.myDocument, idLineOffset));
            if (indent.length() == endIndent) {
                return;
            }
            PsiWhiteSpace previous = (PsiWhiteSpace)ObjectUtils.tryCast((Object)element.getPrevSibling(), PsiWhiteSpace.class);
            if (previous != null) {
                this.myReplacements.add((Pair<TextRange, CharSequence>)Pair.create((Object)previous.getTextRange(), (Object)indent));
            } else {
                this.myReplacements.add((Pair<TextRange, CharSequence>)Pair.create((Object)TextRange.from((int)endOffset, (int)0), (Object)indent));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "heredocValue";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRHeredocValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitHeredocEnd";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

