/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.findUsages;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RDefinedStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RBaseStringNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RRescueBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RListOfExpressionsNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyFileCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;

public final class RubyUsageTypeProvider
implements UsageTypeProvider {
    public static final Key<Boolean> TEXT_OCCURRENCE_KEY = new Key("Ruby.Text.Occurrence");
    public static final UsageType MESSAGE_SEND = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.message.send.group"));
    private static final UsageType UNTYPED = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.untyped.group"));
    private static final UsageType DECLARATION = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.declarations.group"));
    private static final UsageType PARTIAL_DECLARATION = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.partial.declarations.group"));
    private static final UsageType NAMESPACE_DECLARATION = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.namespace.declaration.group"));
    private static final UsageType SUPERCLASS_CLAUSE = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.superclass.clause.group"));
    private static final UsageType ALIAS_OCCURRENCE = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.alias.occurrence.group"));
    private static final UsageType REQUIRE_LOAD_OCCURRENCE = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.require.load.file.occurrence.group"));
    private static final UsageType METHOD_CALL = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.method.call"));
    private static final UsageType STRING_LITERAL = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.string.group"));
    private static final UsageType SYMBOL_HASH_KEY_CONSTANT = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.symbol.or.hash.key.group"));
    private static final UsageType EXTEND_INCLUDE_PREPEND_CALL = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.extend.include.prepend.group"));
    private static final UsageType NESTED_CONSTANT_ACCESS = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.nested.constant.access.group"));
    private static final UsageType CONSTANT_MEMBER_ACCESS = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.constant.member.access.group"));
    private static final UsageType RESCUE_CLAUSE = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.rescue.clause.group"));
    private static final UsageType TYPE_CHECK_CALL = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.type.check.group"));
    private static final UsageType DEFINED_STATEMENT = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.defined.statement.group"));
    private static final UsageType VISIBILITY_MODIFIER_CALL = new UsageType(RBundle.messagePointer((String)"find.usages.ruby.visibility.modifier.group"));
    private static final List<String> MESSAGE_SEND_COMMANDS = List.of("send", "public_send");
    private static final List<String> TYPE_CHECK_COMMANDS = List.of("instance_of?", "is_a?", "kind_of?", "respond_to?");
    private static final List<String> VISIBILITY_MODIFIER_COMMANDS = List.of("private", "private_class_method", "private_constant", "protected", "public", "public_class_method", "public_constant", "public_instance_method");
    private static final List<ArgumentInfo.Type> DECLARATION_ARGUMENT_INFO_TYPES = List.of(ArgumentInfo.Type.PREDEFINED, ArgumentInfo.Type.NAMED);

    @Nullable
    public UsageType getUsageType(@NotNull PsiElement element) {
        block33: {
            block32: {
                if (element == null) {
                    RubyUsageTypeProvider.$$$reportNull$$$0(0);
                }
                if (element.getUserData(TEXT_OCCURRENCE_KEY) != null) {
                    element.putUserData(TEXT_OCCURRENCE_KEY, null);
                    return UNTYPED;
                }
                RReference reference = RReferenceNavigator.getReferenceByLeftPart((PsiElement)element);
                if (reference instanceof RColonReference) {
                    return NESTED_CONSTANT_ACCESS;
                }
                if ((element instanceof RConstant || element instanceof RColonReference) && reference instanceof RDotReference) {
                    if (reference instanceof RReferenceBase && reference.isConstructorLike()) {
                        return UsageType.CLASS_NEW_OPERATOR;
                    }
                    return CONSTANT_MEMBER_ACCESS;
                }
                if (element instanceof RClass) {
                    return PARTIAL_DECLARATION;
                }
                if (element instanceof RModule) {
                    List statements = ((RModule)element).getCompoundStatement().getStatements();
                    if (!statements.isEmpty() && ContainerUtil.and((Iterable)statements, statement -> statement instanceof RClass || statement instanceof RModule)) {
                        return NAMESPACE_DECLARATION;
                    }
                    return PARTIAL_DECLARATION;
                }
                if (RNameNavigator.getRName((PsiElement)element) instanceof RSuperClass) {
                    return SUPERCLASS_CLAUSE;
                }
                if (RubyPsiUtil.isCallOfType((PsiElement)RCallNavigator.getByFirstRArgument((PsiElement)element), RubyCallTypes.CLASS_NEW)) {
                    return SUPERCLASS_CLAUSE;
                }
                if (RubyPsiUtil.isCallOfType((PsiElement)RCallNavigator.getByRArgument((PsiElement)element), RubyIncludeExtendCallTypes.ALL::contains) && (element instanceof RConstant || element instanceof RColonReference || element instanceof RTopConstReference)) {
                    return EXTEND_INCLUDE_PREPEND_CALL;
                }
                if (RubyPsiUtil.isCallWithCommand((PsiElement)RCallNavigator.getByRArgument((PsiElement)element), MESSAGE_SEND_COMMANDS::contains)) {
                    return MESSAGE_SEND;
                }
                if (RubyPsiUtil.isCallOfType(element, RubyCallTypes.VISIBILITY_MODIFIER_CALLS::contains)) break block32;
                if (!RubyPsiUtil.isCallWithCommand((PsiElement)RCallNavigator.getByRArgument((PsiElement)element), VISIBILITY_MODIFIER_COMMANDS::contains)) break block33;
            }
            return VISIBILITY_MODIFIER_CALL;
        }
        if (RubyPsiUtil.isCallWithCommand((PsiElement)RCallNavigator.getByFirstRArgument((PsiElement)element), TYPE_CHECK_COMMANDS::contains)) {
            return TYPE_CHECK_CALL;
        }
        if (PsiTreeUtil.findFirstParent((PsiElement)element, parent -> parent instanceof RDefinedStatement) != null) {
            return DEFINED_STATEMENT;
        }
        if (element instanceof RStringLiteral || RBaseStringNavigator.getByPsiElement((PsiElement)element) != null) {
            return STRING_LITERAL;
        }
        if (element instanceof RSymbol || element instanceof RAssocKey) {
            return SYMBOL_HASH_KEY_CONSTANT;
        }
        Type type = RubyUsageTypeProvider.getType(element);
        if (Types.METHODS.contains(type)) {
            return METHOD_CALL;
        }
        if (RubyPsiUtilCore.isDeclaration((PsiElement)element)) {
            RArgument argument;
            if (element instanceof RConstant) {
                return DECLARATION;
            }
            if (element instanceof RPsiElement && (argument = RArgumentNavigator.getByParameter((RPsiElement)((RPsiElement)element))) != null && !DECLARATION_ARGUMENT_INFO_TYPES.contains(argument.getType())) {
                return DECLARATION;
            }
            return UsageType.WRITE;
        }
        if (element instanceof RFName) {
            return DECLARATION;
        }
        if (element instanceof RPsiElement && RubyUsageAnalyzerCore.isParameter((RPsiElement)((RPsiElement)element))) {
            return DECLARATION;
        }
        if (element instanceof RCall && ((RCall)element).getCallType() instanceof RubyFileCallType) {
            return REQUIRE_LOAD_OCCURRENCE;
        }
        if (element instanceof RAliasStatement || element instanceof RPsiElement && RAliasStatementNavigator.getAliasByName((PsiElement)element, (boolean)true) != null) {
            return ALIAS_OCCURRENCE;
        }
        if (element instanceof RReferenceBase && ((RReferenceBase)element).isConstructorLike()) {
            return UsageType.CLASS_NEW_OPERATOR;
        }
        if (RRescueBlockNavigator.getByException((PsiElement)((PsiElement)ObjectUtils.coalesce((Object)RListOfExpressionsNavigator.getByPsiElement((PsiElement)element), (Object)element))) != null) {
            return RESCUE_CLAUSE;
        }
        if (element instanceof RVariable || element instanceof RTopConstReference || element instanceof RColonReference) {
            return UsageType.READ;
        }
        if (Types.ATTR_METHODS.contains(type)) {
            return UsageType.READ;
        }
        if (element instanceof RIdentifier && ((RIdentifier)element).isNumberedParameter()) {
            return UsageType.READ;
        }
        return null;
    }

    @Nullable
    private static Type getType(@NotNull PsiElement element) {
        if (element == null) {
            RubyUsageTypeProvider.$$$reportNull$$$0(1);
        }
        return (Type)ObjectUtils.doIfNotNull((Object)ResolveUtil.resolveToSymbolWithCaching(element.getReference()), Symbol::getType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/findUsages/RubyUsageTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsageType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

