/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyAliasMethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.RubyElementNameAndDescriptionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTargetElementUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyWordsScanner;
import org.jetbrains.plugins.ruby.ruby.lang.findUsages.RubySearchableFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;

public class RubyFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return new RubyWordsScanner();
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof RContainer && !(psiElement instanceof RObjectClass)) {
            return true;
        }
        if (psiElement instanceof RConstant) {
            return RubyPsiUtilCore.isDeclaration((PsiElement)psiElement);
        }
        if (psiElement instanceof RIdentifier) {
            RIdentifier id = (RIdentifier)psiElement;
            return id.isParameterDeclaration() || id.isLocalVariable();
        }
        if (psiElement instanceof RAssocKey || psiElement instanceof RField || psiElement instanceof RGlobalVariable || psiElement instanceof RSymbol || psiElement instanceof RubySearchableFakePsiElement) {
            return true;
        }
        return !RubyTargetElementUtil.getRubyNamedElements(psiElement).isEmpty();
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(1);
        }
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement psiElement) {
        String type;
        RCall call;
        if (psiElement == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof RClass || RubyCallTypesCore.isClassName((PsiElement)psiElement)) {
            String string = RBundle.message((String)"class");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (psiElement instanceof RModule) {
            String string = RBundle.message((String)"module");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (psiElement instanceof RSingletonMethod) {
            String string = RBundle.message((String)"singleton.method");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (psiElement instanceof RMethod) {
            String string = RBundle.message((String)"method");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (psiElement instanceof RAliasStatement || psiElement instanceof RubyAliasMethodNameFakePsiElement) {
            String string = RBundle.message((String)"alias");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (psiElement instanceof RIdentifier) {
            RIdentifier id = (RIdentifier)psiElement;
            if (id.isParameterDeclaration()) {
                String string = RBundle.message((String)"parameter");
                if (string == null) {
                    RubyFindUsagesProvider.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (id.isLocalVariable()) {
                String string = RBundle.message((String)"local.variable");
                if (string == null) {
                    RubyFindUsagesProvider.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        if ((call = RubyPsiUtil.getCoveringRCall(psiElement)) != null) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            RubyCallTypes.processElementsAtArgument(call, psiElement, null, (Processor<? super PsiElement>)finder);
            PsiElement match = (PsiElement)finder.getFoundValue();
            if (match instanceof PsiPresentableMetaData && StringUtil.isNotEmpty((String)(type = ((PsiPresentableMetaData)match).getTypeName()))) {
                String string = type;
                if (string == null) {
                    RubyFindUsagesProvider.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        if (psiElement instanceof RAssocKey) {
            String string = RBundle.message((String)"assoc.key");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (psiElement instanceof RSymbol) {
            String string = RBundle.message((String)"symbol");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (psiElement instanceof RCall) {
            String string = RBundle.message((String)"call");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (psiElement instanceof RGlobalVariable) {
            String string = RBundle.message((String)"global.variable");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (psiElement instanceof RConstant) {
            String string = RBundle.message((String)"constant");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (psiElement instanceof RClassVariable) {
            String string = RBundle.message((String)"class.variable");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (psiElement instanceof RInstanceVariable) {
            String string = RBundle.message((String)"instance.variable");
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(17);
            }
            return string;
        }
        for (RubyElementNameAndDescriptionProvider provider : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            type = provider.getType(psiElement);
            if (type == null) continue;
            String string = type;
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(18);
            }
            return string;
        }
        @NlsSafe String typeText = PsiUtilCore.getElementType((PsiElement)psiElement).toString();
        if (typeText.startsWith("Ruby:")) {
            String string = typeText.substring(5);
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = typeText;
        if (string == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(21);
        }
        if (element instanceof RMethod) {
            String string = RMethodPresentationUtil.formatName((RMethod)((RMethod)element), (int)4353);
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (element instanceof RAssoc) {
            String string = ((RAssoc)element).getKeyText();
            if (string == null) {
                RubyFindUsagesProvider.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = this.getNodeText(element, false);
        if (string == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        ItemPresentation presentation;
        if (element == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(25);
        }
        if ((presentation = ((RPsiElement)element).getPresentation()) == null) {
            return "";
        }
        String presentableText = presentation.getPresentableText();
        String string = presentableText == null ? "" : presentableText;
        if (string == null) {
            RubyFindUsagesProvider.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/findUsages/RubyFindUsagesProvider";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/findUsages/RubyFindUsagesProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsagesFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 26 -> new IllegalStateException(string);
        };
    }
}

