/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.findUsages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usages.UsageGroup;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RubyContainerUsageGroup
implements UsageGroup {
    private final SmartPsiElementPointer myClassPointer;
    private final @NlsContexts.ListItem String myText;
    private final String myQName;
    private final Icon myIcon;

    public RubyContainerUsageGroup(RContainer rContainer) {
        this.myClassPointer = SmartPointerManager.getInstance((Project)rContainer.getProject()).createSmartPsiElementPointer((PsiElement)rContainer);
        this.myText = rContainer instanceof RObjectClass ? ((RObjectClass)rContainer).getPresentableName() : (rContainer instanceof RSingletonMethod ? ((RSingletonMethod)rContainer).getPresentableName(false) : rContainer.getFQN().getFullPath());
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rContainer);
        this.myQName = symbol == null ? this.myText : symbol.getFQNWithNesting().getFullPath();
        this.myIcon = rContainer.getIcon(0);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getPresentableGroupText() {
        String string = this.myText;
        if (string == null) {
            RubyContainerUsageGroup.$$$reportNull$$$0(0);
        }
        return string;
    }

    public FileStatus getFileStatus() {
        if (this.isValid()) {
            return NavigationItemFileStatus.get((NavigationItem)this.getContainer());
        }
        return null;
    }

    private RContainer getContainer() {
        return (RContainer)this.myClassPointer.getElement();
    }

    public boolean isValid() {
        PsiElement element = this.myClassPointer.getElement();
        return element != null && element.isValid();
    }

    public int compareTo(@NotNull UsageGroup o) {
        if (o == null) {
            RubyContainerUsageGroup.$$$reportNull$$$0(1);
        }
        return this.getPresentableGroupText().compareToIgnoreCase(o.getPresentableGroupText());
    }

    public void navigate(boolean requestFocus) {
        if (this.isValid()) {
            this.getContainer().navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RubyContainerUsageGroup that = (RubyContainerUsageGroup)o;
        return !(this.myQName != null ? !this.myQName.equals(that.myQName) : that.myQName != null);
    }

    public int hashCode() {
        return this.myQName != null ? this.myQName.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/findUsages/RubyContainerUsageGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableGroupText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/findUsages/RubyContainerUsageGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

