/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.list;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.list.HtmlListBuilder;

public class LabeledListBuilder
extends HtmlListBuilder {
    @NonNls
    public static final String LABEL_AND_TEXT_DELIMITER = ":: ";

    @Override
    @NotNull
    public String getHtmlCode() {
        StringBuilder result = new StringBuilder();
        result.append("<dl>");
        for (int i = 0; i < this.myItemTexts.size(); ++i) {
            String text = (String)this.myItemTexts.get(i);
            String caption = (String)this.myItemCaptions.get(i);
            result.append("<dt><b>").append(caption).append("</b></dt>").append("<dd>").append(text).append("</dd>");
        }
        result.append("</dl>");
        String string = result.toString();
        if (string == null) {
            LabeledListBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public String getCaption(@NotNull String line) {
        String trimmedBullet;
        if (line == null) {
            LabeledListBuilder.$$$reportNull$$$0(1);
        }
        int bulletEndOffset = LabeledListBuilder.getCaptionEndOffset(line);
        String notTrimmedBullet = line.substring(line.startsWith("-") ? 1 : 0, bulletEndOffset);
        if (notTrimmedBullet.endsWith(LABEL_AND_TEXT_DELIMITER)) {
            trimmedBullet = StringUtil.trimEnd((String)notTrimmedBullet, (String)LABEL_AND_TEXT_DELIMITER).trim();
        } else if (notTrimmedBullet.startsWith("[") && notTrimmedBullet.endsWith("]")) {
            trimmedBullet = StringUtil.trimStart((String)notTrimmedBullet, (String)"[");
            trimmedBullet = StringUtil.trimEnd((String)trimmedBullet, (String)"]").trim();
        } else {
            return null;
        }
        return trimmedBullet;
    }

    @Override
    @NotNull
    public String replaceBulletWithSpace(@NotNull String line) {
        if (line == null) {
            LabeledListBuilder.$$$reportNull$$$0(2);
        }
        int bulletEndOffset = LabeledListBuilder.getCaptionEndOffset(line);
        String string = StringUtil.repeat((String)" ", (int)bulletEndOffset) + line.substring(bulletEndOffset);
        if (string == null) {
            LabeledListBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static int getCaptionEndOffset(@NotNull String line) {
        if (line == null) {
            LabeledListBuilder.$$$reportNull$$$0(4);
        }
        int bracketIndex = line.indexOf(93);
        int colonIndex = line.indexOf(LABEL_AND_TEXT_DELIMITER);
        if (bracketIndex < 0 && colonIndex < 0) {
            return 0;
        }
        int bulletEndOffset = line.startsWith("[") && bracketIndex > 0 && bracketIndex < colonIndex || colonIndex < 0 ? bracketIndex + 1 : colonIndex + LABEL_AND_TEXT_DELIMITER.length();
        return bulletEndOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/list/LabeledListBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlCode";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/list/LabeledListBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceBulletWithSpace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCaption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceBulletWithSpace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCaptionEndOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

