/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.BaseDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.CompositeDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationText;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.list.HtmlListBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.list.LabeledListBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.list.OrderedListBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.list.UnorderedListBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RenderedDocumentationList
extends BaseDocumentationItem {
    private final Project myProject;
    @Nullable
    private final RContainer myTarget;
    private HtmlListBuilder myListBuilder;

    public RenderedDocumentationList(@NotNull Project project, @Nullable RContainer target) {
        if (project == null) {
            RenderedDocumentationList.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myTarget = target;
    }

    public int getListItemIndent() {
        if (this.myListBuilder == null) {
            return 1;
        }
        String line = ContainerUtil.reverse(this.getLines()).stream().filter(it -> this.isNextListItem((String)it)).map(it -> this.myListBuilder.replaceBulletWithSpace((String)it)).findFirst().orElse(null);
        if (line == null) {
            return 1;
        }
        if (line.trim().isEmpty()) {
            String lastLine = this.get(this.getLinesNumber() - 1);
            return !lastLine.trim().isEmpty() ? RubyDocumentationUtil.getIndent(lastLine) : 0;
        }
        return RubyDocumentationUtil.getIndent(line);
    }

    @Override
    public void addLine(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationList.$$$reportNull$$$0(1);
        }
        super.addLine(line);
        if (this.getLinesNumber() == 1) {
            this.myListBuilder = RenderedDocumentationList.getListBuilder(line.trim());
        }
    }

    @Override
    @NotNull
    public String getRenderedText(boolean isFirstItem) {
        if (this.myListBuilder == null) {
            return "";
        }
        List<String> lines = RubyDocumentationUtil.cutCommonIndent(this.getLines());
        String firstLine = lines.get(0);
        int listIndent = RubyDocumentationUtil.getIndent(firstLine);
        ArrayList<String> currentLinesBlock = new ArrayList<String>();
        String caption = null;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            int lineIndent = RubyDocumentationUtil.getIndent(line);
            if (StringUtil.isNotEmpty((String)line) && listIndent == lineIndent) {
                if (!currentLinesBlock.isEmpty()) {
                    String listItemCaption = this.renderListItemCaption((String)ObjectUtils.coalesce(caption, (Object)""));
                    String listItemContent = this.renderListItemContent(currentLinesBlock);
                    this.myListBuilder.addItem(listItemCaption, listItemContent);
                }
                currentLinesBlock = new ArrayList();
                caption = this.myListBuilder.getCaption(line);
                line = this.myListBuilder.replaceBulletWithSpace(line);
            }
            currentLinesBlock.add(line);
        }
        if (!currentLinesBlock.isEmpty()) {
            String listItemCaption = this.renderListItemCaption((String)ObjectUtils.coalesce(caption, (Object)""));
            String listItemContent = this.renderListItemContent(RubyDocumentationUtil.cutCommonIndent(currentLinesBlock));
            this.myListBuilder.addItem(listItemCaption, listItemContent);
        }
        String string = this.myListBuilder.getHtmlCode();
        if (string == null) {
            RenderedDocumentationList.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean hasPriorityToTakeLine(@NotNull String line) {
        int lineIndent;
        if (line == null) {
            RenderedDocumentationList.$$$reportNull$$$0(3);
        }
        return (lineIndent = RubyDocumentationUtil.getIndent(line)) >= this.getListItemIndent() && lineIndent != 0 || this.isNextListItem(line.trim());
    }

    @NotNull
    private String renderListItemCaption(@NotNull String caption) {
        if (caption == null) {
            RenderedDocumentationList.$$$reportNull$$$0(4);
        }
        RenderedDocumentationText text = new RenderedDocumentationText(this.myProject, this.myTarget);
        text.addLine(caption);
        String string = text.getRenderedText(false);
        if (string == null) {
            RenderedDocumentationList.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String renderListItemContent(@NotNull List<String> lines) {
        if (lines == null) {
            RenderedDocumentationList.$$$reportNull$$$0(6);
        }
        CompositeDocumentationItem compositeDocumentationItem = new CompositeDocumentationItem(this.myProject, Collections.emptyList(), this.myTarget);
        int listItemIndent = 0;
        for (String line : lines) {
            if (line.isEmpty() || line.trim().isEmpty()) continue;
            listItemIndent = RubyDocumentationUtil.getIndent(line);
            break;
        }
        for (String line : lines) {
            if (line.length() >= listItemIndent) {
                line = line.substring(listItemIndent);
            }
            compositeDocumentationItem.addLine(line);
        }
        String string = compositeDocumentationItem.getRenderedText(false);
        if (string == null) {
            RenderedDocumentationList.$$$reportNull$$$0(7);
        }
        return string;
    }

    private boolean isNextListItem(@NotNull String line) {
        String firstLine;
        if (line == null) {
            RenderedDocumentationList.$$$reportNull$$$0(8);
        }
        if ((firstLine = (String)ContainerUtil.getFirstItem(this.getLines())) == null) {
            return true;
        }
        firstLine = firstLine.trim();
        return RubyDocumentationUtil.isUnorderedListItem(line) && RubyDocumentationUtil.isUnorderedListItem(firstLine) || RubyDocumentationUtil.isOrderedListItem(line) && RubyDocumentationUtil.isOrderedListItem(firstLine) || RubyDocumentationUtil.isLabeledListItem(line) && RubyDocumentationUtil.isLabeledListItem(firstLine);
    }

    @Nullable
    private static HtmlListBuilder getListBuilder(@NotNull String firstLine) {
        if (firstLine == null) {
            RenderedDocumentationList.$$$reportNull$$$0(9);
        }
        if (RubyDocumentationUtil.isLabeledListItem(firstLine)) {
            return new LabeledListBuilder();
        }
        if (RubyDocumentationUtil.isUnorderedListItem(firstLine)) {
            return new UnorderedListBuilder();
        }
        if (RubyDocumentationUtil.isOrderedListItem(firstLine)) {
            return new OrderedListBuilder();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/RenderedDocumentationList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/RenderedDocumentationList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "renderListItemCaption";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "renderListItemContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addLine";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasPriorityToTakeLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderListItemCaption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderListItemContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNextListItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getListBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7 -> new IllegalStateException(string);
        };
    }
}

