/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering;

import com.intellij.lang.documentation.DocumentationSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.BaseDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;

public class RenderedDocumentationCodeBlock
extends BaseDocumentationItem {
    @Override
    @NotNull
    public String getRenderedText(boolean isFirstItem) {
        float saturation = DocumentationSettings.getHighlightingSaturation((boolean)true);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.getInstance().forFileType((FileType)RubyFileType.RUBY)).getEditorHighlighter(null, (FileType)RubyFileType.RUBY, null, scheme);
        String text = RubyDocumentationUtil.trimNewLinesAtTheEnd(RubyDocumentationUtil.cutCommonIndent(this.getLines()).stream().map(it -> !it.isBlank() ? " " + it : "").collect(Collectors.joining("\n")));
        editorHighlighter.setText((CharSequence)text);
        HighlighterIterator highlighterIterator = editorHighlighter.createIterator(0);
        HtmlBuilder result = new HtmlBuilder();
        while (!highlighterIterator.atEnd()) {
            HtmlChunk tokenText = HtmlChunk.text((String)text.substring(highlighterIterator.getStart(), highlighterIterator.getEnd()));
            if (!RubyTokenSets.getTWHITESPACES().contains(highlighterIterator.getTokenType())) {
                Color color;
                TextAttributes textAttributes = highlighterIterator.getTextAttributes();
                Color color2 = color = textAttributes != null ? textAttributes.getForegroundColor() : null;
                if (color != null) {
                    Color tunedColor = ColorUtil.tuneSaturationEspeciallyGrey((Color)color, (int)1, (float)saturation);
                    tokenText = tokenText.wrapWith(HtmlChunk.tag((String)"span").style(String.format("color: %s;", RubyDocumentationUtil.getHexFromColor(tunedColor))));
                }
            }
            result.append(tokenText);
            highlighterIterator.advance();
        }
        String string = "<pre><code>" + String.valueOf(result) + "</code></pre>";
        if (string == null) {
            RenderedDocumentationCodeBlock.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean hasPriorityToTakeLine(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationCodeBlock.$$$reportNull$$$0(1);
        }
        return this.getLinesNumber() != 0 && RubyDocumentationUtil.getIndent(line) >= RubyDocumentationUtil.getIndent(this.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/RenderedDocumentationCodeBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/RenderedDocumentationCodeBlock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasPriorityToTakeLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

