/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.YARDMethodData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.ROverloadSyntheticSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyMethodTypeDocPresentationProvider;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public final class RubyMethodAnnotationTypeDocPresentationProvider
implements RubyMethodTypeDocPresentationProvider {
    @Override
    @Nullable
    public String getMethodParameterTypeText(@NotNull ArgumentInfo argumentInfo, @NotNull RMethodSymbol method, @Nullable RPossibleCall call, @Nullable RPsiElement argument) {
        MethodAnnotationData annotationData;
        if (argumentInfo == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(0);
        }
        if (method == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(1);
        }
        if ((annotationData = method.getAnnotationData()) == null) {
            return null;
        }
        ROverloadSyntheticSignature overloadSignature = RubyMethodAnnotationTypeDocPresentationProvider.getOverloadSignature(annotationData, call);
        SerializableType parameterType = RubyMethodAnnotationTypeDocPresentationProvider.getParameterType(argumentInfo, annotationData, overloadSignature);
        return (String)ObjectUtils.doIfNotNull((Object)parameterType, SerializableType::getPresentableName);
    }

    @Override
    @Nullable
    public List<ArgumentInfo> getArgumentInfo(@NotNull RMethodSymbol methodSymbol, @Nullable RPossibleCall call) {
        MethodAnnotationData annotationData;
        if (methodSymbol == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(2);
        }
        if ((annotationData = methodSymbol.getAnnotationData()) == null) {
            return null;
        }
        ROverloadSyntheticSignature overloadSignature = RubyMethodAnnotationTypeDocPresentationProvider.getOverloadSignature(annotationData, call);
        if (overloadSignature == null) {
            return null;
        }
        return overloadSignature.getParametersInfo();
    }

    @Override
    @Nullable
    public String getMethodReturnTypeText(@NotNull RMethodSymbol methodSymbol, @Nullable RPossibleCall call) {
        RMethod method;
        if (methodSymbol == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(3);
        }
        if ((method = (RMethod)ObjectUtils.tryCast((Object)methodSymbol.getPsiElement(), RMethod.class)) == null) {
            return null;
        }
        Project project = method.getProject();
        PsiElement anchor = (PsiElement)ObjectUtils.coalesce((Object)call, (Object)method);
        MethodAnnotationData methodAnnotationData = method.getAnnotationData();
        SerializableType serializableMethodAnnotationReturnType = methodAnnotationData.getReturnType();
        String methodReturnTypeNameFromAnnotation = serializableMethodAnnotationReturnType.getPresentableName();
        if (!methodReturnTypeNameFromAnnotation.isEmpty()) {
            return RubyHelpUtil.linkinize(project, methodReturnTypeNameFromAnnotation, anchor);
        }
        RType methodReturnTypeFromResolve = RFrozenType.clearFrozenStatus(serializableMethodAnnotationReturnType.resolve(method.getProject(), (PsiElement)method));
        if (methodReturnTypeFromResolve instanceof RSymbolType && methodReturnTypeFromResolve.isTyped() && "String".equals(method.getName())) {
            return RFrozenType.clearFrozenStatus(RTypeFactory.createStringType((RPsiElement)method)).getPresentableName();
        }
        if (RTypeUtilCore.isNullOrEmpty((RType)methodReturnTypeFromResolve)) {
            return null;
        }
        String methodReturnTypeName = methodReturnTypeFromResolve.getPresentableName();
        if (methodReturnTypeName == null) {
            return null;
        }
        return RubyHelpUtil.linkinize(project, methodReturnTypeName, anchor);
    }

    @Nullable
    private static ROverloadSyntheticSignature getOverloadSignature(@NotNull MethodAnnotationData annotationData, @Nullable RPossibleCall call) {
        if (annotationData == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(4);
        }
        if (call == null) {
            return null;
        }
        RBlockCall blockCall = (RBlockCall)ObjectUtils.doIfNotNull((Object)call, RBlockCallNavigator::getByCall);
        List parameters = call.getArguments();
        RCodeBlock block = (RCodeBlock)ObjectUtils.doIfNotNull((Object)blockCall, RBlockCall::getBlock);
        YARDMethodData yardAnnotationData = (YARDMethodData)ObjectUtils.doIfNotNull((Object)annotationData, MethodAnnotationData::getYARDMethodData);
        if (yardAnnotationData == null || yardAnnotationData.getOverloads().isEmpty()) {
            return null;
        }
        Map matches = yardAnnotationData.getMatchingOverloads(call.getProject(), parameters, block);
        return (ROverloadSyntheticSignature)ContainerUtil.getFirstItem((List)ContainerUtil.concat(matches.getOrDefault(ThreeState.YES, Collections.emptyList()), matches.getOrDefault(ThreeState.UNSURE, Collections.emptyList())));
    }

    @Nullable
    private static SerializableType getParameterType(@NotNull ArgumentInfo argumentInfo, @NotNull MethodAnnotationData annotationData, @Nullable ROverloadSyntheticSignature overloadSignature) {
        if (argumentInfo == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(5);
        }
        if (annotationData == null) {
            RubyMethodAnnotationTypeDocPresentationProvider.$$$reportNull$$$0(6);
        }
        if (overloadSignature != null) {
            if (argumentInfo.getType().isBlock()) {
                return overloadSignature.getYardMethodData().getBlockType();
            }
            return overloadSignature.getYardMethodData().getParameterType(argumentInfo.getName());
        }
        if (argumentInfo.getType().isBlock()) {
            return annotationData.getBlockParameterType(argumentInfo.getName());
        }
        return annotationData.getParameterType(argumentInfo.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationData";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyMethodAnnotationTypeDocPresentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodParameterTypeText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodReturnTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOverloadSignature";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

