/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.lang.Language;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOptionTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOverloadDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDReturnTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDYieldparamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDSubMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.AnnotationsHelperCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyAliasMethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.DelegateProducedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.lang.RubyElementNameAndDescriptionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.RubyMethodTypeDocPresentationProvider;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RDocFormat;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RDocFormatIndex;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.CompositeDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.FieldType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RubyHelpUtil {
    private static final Logger LOG = Logger.getInstance(RubyHelpUtil.class);
    private static final String UNDEFINED_ELEMENT = "[undefined]";
    private static final String RIGHT_ARROW = "&nbsp;\u2192&nbsp;";
    private static final String LEFT_ARROW = "&nbsp;\u2190&nbsp;";
    private static final String SIGNATURE_INDENT = "    ";
    private static final String PARAMS_SECTION = "Params:";
    private static final String OPTIONS_SECTION = "Options:";
    private static final String YIELDS_SECTION = "Yields:";
    private static final String RETURNS_SECTION = "Returns:";
    private static final List<String> SECTIONS_ORDER = Arrays.asList("Params:", "Options:", "Yields:", "Returns:");
    private static final Pattern STOPDOC_LINE = Pattern.compile("(^|\n|#)\\s*(:stopdoc:)\\s*(\\n|$)");
    private static final Pattern STARTDOC_LINE = Pattern.compile("(^|\n|#)\\s*(:startdoc:)\\s*(\\n|$)");
    private static final Pattern MARKUP_LINE = Pattern.compile("(^|\n|#)\\s*(:markup:)\\s*.*(\\n|$)");

    private RubyHelpUtil() {
    }

    @Nullable
    @NlsSafe
    public static String getSimpleInfo(@Nullable RPsiElement targetElement, @Nullable PsiElement originalElement, boolean forNavigateInfo) {
        Symbol targetSymbol;
        if (targetElement == null || targetElement instanceof PsiFile) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        Symbol symbol = targetSymbol = targetElement instanceof RContainer ? SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)targetElement)) : null;
        if (targetSymbol != null) {
            RubyHelpUtil.appendSymbolLocation(targetSymbol, builder2, targetElement);
            RubyHelpUtil.appendVisibility(targetElement, targetSymbol, builder2);
            RubyHelpUtil.appendSymbolKindInfo(targetSymbol, builder2);
        } else {
            RubyHelpUtil.appendVisibility(targetElement, null, builder2);
            String kindText = RubyHelpUtil.getElementKindInfo(targetElement);
            if (kindText != null) {
                builder2.append(kindText).append(forNavigateInfo ? " " : "&nbsp;");
            }
        }
        RubyHelpUtil.appendPresentableName((PsiElement)targetElement, targetSymbol, originalElement, builder2, !forNavigateInfo);
        if (targetSymbol != null) {
            RubyHelpUtil.appendSuperClassInfo(targetSymbol, builder2, !forNavigateInfo, (PsiElement)targetElement);
        }
        RubyHelpUtil.appendLocation(targetElement, targetSymbol, builder2, !forNavigateInfo);
        if (!forNavigateInfo) {
            RubyHelpUtil.appendTypeInfo(null, targetElement, null, builder2);
        }
        return !builder2.isEmpty() ? builder2.toString() : null;
    }

    @Nullable
    public static String getHelpByElement(@Nullable PsiElement elementAtCursor, @Nullable RPsiElement rPsiElementAtCursor, @NotNull RPsiElement targetElement) {
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(0);
        }
        if (targetElement instanceof RFile) {
            LOG.debug("No documentation: target is file: ", new Object[]{targetElement});
            return null;
        }
        if (rPsiElementAtCursor != null) {
            String help = RubyHelpUtil.createHelpUsingResolveToSymbol(elementAtCursor, rPsiElementAtCursor, targetElement);
            if (help != null) {
                return help;
            }
        } else {
            LOG.debug("No original RPsiElement.", new Object[]{" ElementAtCursor=", elementAtCursor, "; rPsiElementAtCursor=", rPsiElementAtCursor, "; targetElement=", targetElement});
        }
        if (targetElement instanceof RContainer) {
            RContainer container = (RContainer)targetElement;
            Symbol containerSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
            if (containerSymbol != null) {
                return RubyHelpUtil.createHelpForSymbol(containerSymbol, rPsiElementAtCursor, targetElement);
            }
            LOG.debug("No documentation: no symbol for container.", new Object[]{" ElementAtCursor=", elementAtCursor, "; rPsiElementAtCursor=", rPsiElementAtCursor, "; targetElement=", targetElement});
            return null;
        }
        if (RubyHelpUtil.isVariableLike(targetElement) || targetElement instanceof RConstant || targetElement instanceof RField || targetElement instanceof RGlobalVariable || targetElement instanceof RAliasStatement || targetElement instanceof RubyAliasMethodNameFakePsiElement || targetElement instanceof RCall || targetElement instanceof RBlockCall) {
            String help = RubyHelpUtil.createHelpUsingResolveToSymbol(elementAtCursor, rPsiElementAtCursor, targetElement);
            if (help != null) {
                return help;
            }
            return RubyHelpUtil.getDescriptionWithoutSymbol(targetElement, (PsiElement)rPsiElementAtCursor);
        }
        LOG.debug("No documentation: unknown target element type ", new Object[]{" ElementAtCursor=", elementAtCursor, "; rPsiElementAtCursor=", rPsiElementAtCursor, "; targetElement=", targetElement});
        return null;
    }

    @Nullable
    private static String getElementKindInfo(@NotNull RPsiElement targetElement) {
        RGlobalVariable var;
        RConstant constant;
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(1);
        }
        if (targetElement instanceof RIdentifier) {
            RIdentifier identifier = (RIdentifier)targetElement;
            if (identifier.isParameter()) {
                return RBundle.message((String)"parameter");
            }
            if (identifier.isLocalVariable()) {
                return RBundle.message((String)"local.variable");
            }
            return null;
        }
        if (targetElement instanceof RubyAliasMethodNameFakePsiElement) {
            return RBundle.message((String)"alias");
        }
        if (targetElement instanceof RConstant && RubyPsiUtilCore.isDeclaration((PsiElement)(constant = (RConstant)targetElement))) {
            return RBundle.message((String)"constant");
        }
        if (targetElement instanceof RField) {
            RField field = (RField)targetElement;
            return field.getFieldType() == FieldType.CLASS_VARIABLE ? RBundle.message((String)"class.variable") : RBundle.message((String)"instance.variable");
        }
        if (targetElement instanceof RGlobalVariable && RubyPsiUtilCore.isDeclaration((PsiElement)(var = (RGlobalVariable)targetElement))) {
            return RBundle.message((String)"global.variable");
        }
        if (targetElement instanceof RMethod) {
            return RBundle.message((String)"method");
        }
        if (targetElement instanceof RClass) {
            return RBundle.message((String)"class");
        }
        if (targetElement instanceof RModule) {
            return RBundle.message((String)"module");
        }
        if (targetElement instanceof RSymbol) {
            return RBundle.message((String)"symbol");
        }
        if (targetElement instanceof RAssocKey) {
            return RBundle.message((String)"assoc.key");
        }
        if (targetElement instanceof ArgumentFakePsiElement) {
            return ((ArgumentFakePsiElement)targetElement).getTypeName();
        }
        return null;
    }

    @Nullable
    private static String createTypeText(@NotNull RType type, @NotNull RPsiElement targetElement) {
        String typeString;
        if (type == null) {
            RubyHelpUtil.$$$reportNull$$$0(2);
        }
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(3);
        }
        return (typeString = type.getPresentableName()) == null ? null : RubyHelpUtil.linkinize(targetElement.getProject(), typeString, (PsiElement)targetElement);
    }

    static String createRefText(Symbol symbol, String linkLabel) {
        String refText;
        StringBuilder typeName = new StringBuilder();
        PsiElement element = symbol.getPsiElement();
        PsiFile psiFile = element != null ? element.getContainingFile() : null;
        VirtualFile vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        String string = refText = vFile != null ? vFile.getPath() + "::" + element.getTextRange().getStartOffset() : null;
        if (refText != null) {
            DocumentationManagerUtil.createHyperlink((StringBuilder)typeName, (String)refText, (String)linkLabel, (boolean)true);
        } else {
            typeName.append(linkLabel);
        }
        return typeName.toString();
    }

    @NotNull
    public static String linkinize(Project project, @NotNull String typeName, @Nullable PsiElement anchor) {
        if (typeName == null) {
            RubyHelpUtil.$$$reportNull$$$0(4);
        }
        if (typeName.contains("<a href=") && typeName.contains("/a>")) {
            String string = typeName;
            if (string == null) {
                RubyHelpUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String delims = "<>, -()";
        StringTokenizer st = new StringTokenizer(typeName, delims, true);
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1 && delims.contains(token) || token.equals("or") || token.equals("and")) {
                sb.append(RubyHelpUtil.encodeBrackets(token));
                continue;
            }
            Symbol symbol = SymbolUtil.findConstantByFQN(project, FQN.of((String)token), anchor);
            if (symbol == null) {
                sb.append(token);
                continue;
            }
            sb.append(RubyHelpUtil.createRefText(symbol, token));
        }
        String string = sb.toString();
        if (string == null) {
            RubyHelpUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static PsiElement getElementByLink(String link, PsiManager psiManager) {
        if (link.contains("::")) {
            String[] split = link.split("::", 2);
            try {
                PsiElement element;
                PsiFile psiFile;
                int offset = Integer.parseInt(split[1]);
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)split[0]));
                if (file != null && (psiFile = psiManager.findFile(file)) != null && (element = psiFile.findElementAt(offset)) != null) {
                    return PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void appendPresentableNameForContainer(@NotNull PsiElement element, @Nullable Symbol targetSymbol, @Nullable PsiElement originalElement, boolean isForQuickDoc, @NotNull StringBuilder builder2) {
        if (element == null) {
            RubyHelpUtil.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            RubyHelpUtil.$$$reportNull$$$0(8);
        }
        if (targetSymbol instanceof RMethodSymbol) {
            RubyHelpUtil.formatMethodPresentableName((RMethodSymbol)targetSymbol, originalElement, isForQuickDoc, builder2);
            return;
        }
        if (targetSymbol instanceof DelegateProducedSymbol) {
            RubyHelpUtil.formatDelegatedMethodPresentableName((DelegateProducedSymbol)targetSymbol, builder2);
            return;
        }
        if (element instanceof RContainer) {
            FQN fqn = ((RContainer)element).getFQNWithNesting();
            Object name = fqn.getShortName();
            if (((String)name).equals("$$SINGLETON$$") && fqn.getCallerFQN() != FQN.INVALID) {
                name = fqn.getCallerFQN().getShortName() + "::" + (String)name;
            }
            builder2.append(RContainerPresentationUtil.getHumanizedFQN((FQN)FQN.of((String)name)));
            return;
        }
        for (RubyElementNameAndDescriptionProvider provider : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String variant = provider.getPresentableName(element);
            if (variant == null) continue;
            builder2.append(variant);
            return;
        }
        builder2.append(element.getText());
    }

    private static void formatMethodPresentableName(@NotNull RMethodSymbol method, @Nullable PsiElement invocationPoint, boolean isForQuickDoc, @NotNull StringBuilder builder2) {
        Object indent;
        if (method == null) {
            RubyHelpUtil.$$$reportNull$$$0(9);
        }
        if (builder2 == null) {
            RubyHelpUtil.$$$reportNull$$$0(10);
        }
        StringBuilder sb = new StringBuilder();
        String name = method.getFQNWithNesting().getShortName();
        sb.append(name);
        RPossibleCall call = RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)invocationPoint, RPossibleCall.class, (boolean)false)));
        List parameters = call != null ? call.getArguments() : Collections.emptyList();
        MethodAnnotationData annotationData = method.getAnnotationData();
        List argumentInfosFromProviders = Arrays.stream((RubyMethodTypeDocPresentationProvider[])RubyMethodTypeDocPresentationProvider.EP_NAME.getExtensions()).map(provider -> provider.getArgumentInfo(method, call)).filter(Objects::nonNull).findFirst().orElse(null);
        ArrayList<ArgumentInfo> argumentInfos = new ArrayList<ArgumentInfo>((Collection)ObjectUtils.coalesce((Object)argumentInfosFromProviders, (Object)method.getArgumentInfos(true), Collections.emptyList()));
        if (annotationData != null && annotationData.getBlockParameterType(null) != null && !ContainerUtil.exists(argumentInfos, it -> it.getName().equals("blk"))) {
            argumentInfos.add(new ArgumentInfo("block", ArgumentInfo.Type.BLOCK));
        }
        BiFunction<ArgumentInfo, RPsiElement, String> argumentTypeTextProvider = (argumentInfo, argument) -> Arrays.stream((RubyMethodTypeDocPresentationProvider[])RubyMethodTypeDocPresentationProvider.EP_NAME.getExtensions()).map(provider -> provider.getMethodParameterTypeText((ArgumentInfo)argumentInfo, method, call, (RPsiElement)argument)).filter(Objects::nonNull).findFirst().orElse(null);
        if (argumentInfos.isEmpty()) {
            builder2.append((CharSequence)sb);
            return;
        }
        sb.append('(');
        if (isForQuickDoc && sb.length() > 30) {
            indent = SIGNATURE_INDENT;
            sb.append("\n").append((String)indent);
        } else {
            indent = StringUtil.repeatSymbol((char)' ', (int)sb.length());
        }
        if (builder2.lastIndexOf("<pre>") != -1) {
            int preIndex = builder2.lastIndexOf("<pre>");
            int newlineIndex = builder2.lastIndexOf("\n");
            int globalIndent = builder2.length() - (newlineIndex != -1 ? newlineIndex + 1 : preIndex + "<pre>".length());
            indent = StringUtil.repeatSymbol((char)' ', (int)globalIndent) + (String)indent;
        }
        ArrayList<Integer> commaPositions = new ArrayList<Integer>();
        for (int i = 0; i < argumentInfos.size(); ++i) {
            ArgumentInfo info = (ArgumentInfo)argumentInfos.get(i);
            RPsiElement parameter = parameters.size() > i ? (RPsiElement)parameters.get(i) : null;
            String argumentString = ArgumentInfoPresentation.getPresentableString(method.getProject(), info, isForQuickDoc ? ArgumentInfoPresentation.FULL : ArgumentInfoPresentation.SHORT);
            String typeText = argumentTypeTextProvider.apply(info, parameter);
            sb.append(StringUtil.replace((String)argumentString, (String)"\n", (String)("\n" + (String)indent)));
            if (typeText != null) {
                sb.append(LEFT_ARROW).append(RubyHelpUtil.linkinize(method.getProject(), typeText, method.getPsiElement()));
            }
            if (i + 1 >= argumentInfos.size()) continue;
            commaPositions.add(sb.length());
            sb.append(", ");
        }
        sb.append(')');
        if (isForQuickDoc && sb.length() > 80) {
            Collections.reverse(commaPositions);
            Iterator iterator = commaPositions.iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                sb.replace(position + 1, position + 2, "\n" + (String)indent);
            }
        }
        builder2.append((CharSequence)sb);
    }

    private static void formatDelegatedMethodPresentableName(@NotNull DelegateProducedSymbol symbol, @NotNull StringBuilder builder2) {
        Symbol contextSymbol;
        if (symbol == null) {
            RubyHelpUtil.$$$reportNull$$$0(11);
        }
        if (builder2 == null) {
            RubyHelpUtil.$$$reportNull$$$0(12);
        }
        Symbol originalSymbol = (contextSymbol = SymbolUtil.getScopeContextWithCaching(symbol.getPsiElement())) == null ? null : SymbolUtil.findMethod(contextSymbol, symbol.getTo(), Types.METHODS_LIKE, symbol.getPsiElement());
        String toPresentation = originalSymbol != null ? RubyHelpUtil.createRefText(originalSymbol, symbol.getTo()) : symbol.getTo();
        builder2.append('#').append(symbol.getName()).append(" to: :").append(toPresentation);
        if (!symbol.getName().equals(symbol.getDelegateName())) {
            builder2.append('#').append(symbol.getDelegateName());
        }
    }

    @NotNull
    private static String encodeBrackets(String s) {
        String string = StringUtil.replace((String)s, Arrays.asList("<", ">"), Arrays.asList("&lt;", "&gt;"));
        if (string == null) {
            RubyHelpUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void appendPresentableNameForAlias(@Nullable String newName, @Nullable String oldName, StringBuilder builder2, boolean useHtmlLayout) {
        String name;
        String string = name = !StringUtil.isEmpty((String)newName) ? newName : UNDEFINED_ELEMENT;
        if (useHtmlLayout) {
            RubyDocumentationMarkupUtil.appendBoldCode(builder2, name);
        } else {
            builder2.append(name);
        }
        String originalName = !StringUtil.isEmpty((String)oldName) ? oldName : UNDEFINED_ELEMENT;
        builder2.append("(").append(RBundle.message((String)"ruby.doc.original")).append(": ");
        builder2.append(originalName);
        builder2.append(')');
    }

    @Nullable
    public static String getDocumentation(PsiElement targetElement, @Nullable Symbol targetSymbol) {
        PsiElement latestDeclaration;
        Symbol sourceSymbol;
        String descriptionText = RubyCommentsUtil.getPsiHelpWithoutYARD(targetElement);
        if (descriptionText == null && targetSymbol != null && targetSymbol.getType() == Type.ALIAS && (sourceSymbol = SymbolUtil.getMethodSymbolByAlias(targetSymbol)) != null && (latestDeclaration = sourceSymbol.getPsiElement()) != null) {
            descriptionText = RubyCommentsUtil.getPsiHelpWithoutYARD(latestDeclaration);
        }
        if (descriptionText != null) {
            descriptionText = RubyHelpUtil.filterRDocDirectives(descriptionText);
        }
        if (descriptionText != null) {
            if (RubyHelpUtil.getRDocFormat(targetElement.getContainingFile()) == RDocFormat.MARKDOWN) {
                return DocMarkdownToHtmlConverter.convert((Project)targetElement.getProject(), (String)RubyCommentsUtilCore.unsharpText((String)descriptionText), (Language)RubyLanguage.INSTANCE);
            }
            descriptionText = RubyHelpUtil.processCodeDocumentation(targetSymbol, descriptionText, targetElement.getProject());
        }
        return StringUtil.isEmptyOrSpaces((String)descriptionText) ? null : descriptionText;
    }

    @NotNull
    public static String processCodeDocumentation(@Nullable Symbol target, @NonNls @NotNull String text, @NotNull Project project) {
        if (text == null) {
            RubyHelpUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            RubyHelpUtil.$$$reportNull$$$0(15);
        }
        PsiElement targetElement = (PsiElement)ObjectUtils.doIfNotNull((Object)target, Symbol::getPsiElement);
        List lines = ContainerUtil.map(RubyHelpUtil.splitByLines(RubyCommentsUtilCore.unsharpText((String)text)), line -> line.isEmpty() || !Character.isWhitespace(line.charAt(0)) ? line : line.substring(1));
        return RubyHelpUtil.getRenderedDocumentation(lines, project, RubyPsiUtilCore.getParentContainer((PsiElement)targetElement));
    }

    @Nls
    @NotNull
    public static String getRenderedDocumentation(@NotNull List<String> lines, @NotNull Project project, @Nullable RContainer target) {
        if (lines == null) {
            RubyHelpUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            RubyHelpUtil.$$$reportNull$$$0(17);
        }
        CompositeDocumentationItem compositeDocumentationItem = new CompositeDocumentationItem(project, lines, target);
        String string = compositeDocumentationItem.getRenderedText(true);
        if (string == null) {
            RubyHelpUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public static String filterRDocDirectives(@NotNull String descriptionText) {
        String docText;
        Matcher stopdocMatcher;
        if (descriptionText == null) {
            RubyHelpUtil.$$$reportNull$$$0(19);
        }
        if ((stopdocMatcher = STOPDOC_LINE.matcher(docText = descriptionText)).find()) {
            if (!STARTDOC_LINE.matcher(docText).find()) {
                return "";
            }
            docText = stopdocMatcher.replaceAll("\n");
        }
        docText = STARTDOC_LINE.matcher(docText).replaceAll("\n");
        return StringUtil.isEmptyOrSpaces((String)(docText = MARKUP_LINE.matcher(docText).replaceAll("\n"))) ? null : docText;
    }

    @Nullable
    private static String createHelpUsingResolveToSymbol(@Nullable PsiElement elementAtCursor, @Nullable RPsiElement rPsiElementAtCursor, @NotNull RPsiElement targetElement) {
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(20);
        }
        if (DumbService.getInstance((Project)targetElement.getProject()).isDumb()) {
            return null;
        }
        PsiReference ref = RubyHelpUtil.calcDocumentationReference(elementAtCursor);
        if (ref instanceof RPsiPolyVariantReference) {
            SymbolResolveResult resolveResult = ((RPsiPolyVariantReference)ref).resolveToSymbol();
            Symbol resolvedSymbol = resolveResult.getSymbol();
            if (resolvedSymbol == null) {
                return null;
            }
            if (!(resolvedSymbol instanceof MultiSymbol)) {
                return RubyHelpUtil.createHelpForSymbol(resolvedSymbol, rPsiElementAtCursor, targetElement);
            }
            List symbols = ((MultiSymbol)resolvedSymbol).getSymbols();
            StringBuilder builder2 = new StringBuilder();
            builder2.append("<h2>").append(RBundle.message((String)"ruby.doc.several.variants")).append(":</h2>");
            for (Symbol symbol : symbols) {
                String description = RubyHelpUtil.createHelpForSymbol(symbol, rPsiElementAtCursor, targetElement);
                builder2.append("<hr>").append(description);
            }
            return builder2.toString();
        }
        LOG.debug("no help from symbol: no reference found");
        return null;
    }

    @Nullable
    private static PsiReference calcDocumentationReference(@Nullable PsiElement elementAtCursor) {
        if (elementAtCursor == null) {
            return null;
        }
        PsiReference result = elementAtCursor.getReference();
        if (result != null) {
            return result;
        }
        return elementAtCursor.getContainingFile().findReferenceAt(elementAtCursor.getTextRange().getStartOffset());
    }

    @Nullable
    private static String getDescriptionWithoutSymbol(@NotNull RPsiElement targetElement, @Nullable PsiElement originalElement) {
        Map<String, String> section;
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(21);
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append("<div class='definition'><pre>");
        String shortDescription = RubyHelpUtil.getSimpleInfo(targetElement, originalElement, false);
        if (shortDescription != null) {
            builder2.append(shortDescription);
        }
        builder2.append("</pre></div>");
        String documentation = RubyHelpUtil.getDocumentation((PsiElement)targetElement, null);
        if (!StringUtil.isEmptyOrSpaces((String)documentation)) {
            builder2.append("<div class='content'>");
            builder2.append(documentation);
            builder2.append("</div>");
        }
        if ((section = RubyHelpUtil.generateYardSection(targetElement.getProject(), targetElement, originalElement)) != null) {
            RubyHelpUtil.renderSection(builder2, section);
        }
        return !builder2.isEmpty() ? builder2.toString() : null;
    }

    @NotNull
    private static String createHelpForSymbol(@NotNull Symbol targetSymbol, @Nullable RPsiElement originalElement, @NotNull RPsiElement targetElement) {
        Map<String, String> section;
        if (targetSymbol == null) {
            RubyHelpUtil.$$$reportNull$$$0(22);
        }
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(23);
        }
        List declarations = SymbolContainerUtil.siftUpMainDeclarations(targetSymbol.getFQNWithNesting(), SymbolContainerUtil.sortElements(targetSymbol.getAllDeclarations((PsiElement)targetElement), (PsiElement)targetElement));
        StringBuilder builder2 = new StringBuilder();
        builder2.append("<div class='definition'><pre>");
        RubyHelpUtil.appendSymbolLocation(targetSymbol, builder2, targetElement);
        RubyHelpUtil.appendVisibility(targetElement, targetSymbol, builder2);
        RubyHelpUtil.appendSymbolKindInfo(targetSymbol, builder2);
        RubyHelpUtil.appendPresentableName((PsiElement)targetElement, targetSymbol, (PsiElement)originalElement, builder2, true);
        RubyHelpUtil.appendSuperClassInfo(targetSymbol, builder2, true, (PsiElement)originalElement);
        if (!(targetSymbol instanceof ClassModuleSymbol)) {
            RubyHelpUtil.appendTypeInfo(originalElement, targetElement, targetSymbol, builder2);
        }
        builder2.append("</pre></div>");
        String documentation = RubyHelpUtil.getDocumentationWithPartialDeclarations(targetSymbol, declarations);
        if (documentation != null) {
            builder2.append(documentation);
        }
        if ((section = RubyHelpUtil.generateYardSection(targetSymbol.getProject(), targetSymbol, (PsiElement)originalElement)) != null) {
            RubyHelpUtil.renderSection(builder2, section);
        }
        String string = builder2.toString();
        if (string == null) {
            RubyHelpUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void appendSymbolLocation(@NotNull Symbol symbol, @NotNull StringBuilder builder2, RPsiElement anchor) {
        if (symbol == null) {
            RubyHelpUtil.$$$reportNull$$$0(25);
        }
        if (builder2 == null) {
            RubyHelpUtil.$$$reportNull$$$0(26);
        }
        if (symbol.getType() == Type.LOCAL_VARIABLE || symbol.getType() == Type.METHOD_PARAMETER) {
            return;
        }
        FQN namespaceFQN = symbol.getFQNWithNesting().getCallerFQN();
        if ((symbol.getType() == Type.CLASS_METHOD || symbol.getType() == Type.INSTANCE_METHOD || symbol.getType() == Type.CLASS_FIELD) && namespaceFQN.getShortName().equals("$$SINGLETON$$") && (namespaceFQN = namespaceFQN.getCallerFQN()) == FQN.INVALID) {
            namespaceFQN = FQN.of((String)"Object");
        }
        if (namespaceFQN == FQN.INVALID) {
            return;
        }
        builder2.append(RubyHelpUtil.linkinize(symbol.getProject(), RContainerPresentationUtil.getHumanizedFQN((FQN)namespaceFQN, (Symbol)symbol, (PsiElement)anchor), (PsiElement)anchor)).append("\n");
    }

    @Nullable
    private static String getDocumentationWithPartialDeclarations(@NotNull Symbol targetSymbol, @NotNull List<? extends PsiElement> declarations) {
        if (targetSymbol == null) {
            RubyHelpUtil.$$$reportNull$$$0(27);
        }
        if (declarations == null) {
            RubyHelpUtil.$$$reportNull$$$0(28);
        }
        if (declarations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        PsiElement firstElement = (PsiElement)ContainerUtil.getFirstItem(declarations);
        Optional.ofNullable(RubyHelpUtil.getDocumentation(firstElement, targetSymbol)).ifPresent(str -> {
            sb.append("<div class='content'>");
            sb.append((String)str);
            sb.append("</div>");
        });
        Ref openedSection = Ref.create((Object)false);
        declarations.stream().skip(1L).forEach(element -> {
            String doc = RubyHelpUtil.getDocumentation(element, targetSymbol);
            if (doc == null) {
                return;
            }
            if (!((Boolean)openedSection.get()).booleanValue()) {
                sb.append("<table class='sections'>");
                openedSection.set((Object)true);
            }
            sb.append("<tr>").append("<td valign='top'>");
            sb.append("<br>").append("<h4>").append("<span class='grayed'>");
            sb.append(element instanceof RContainer ? RBundle.message((String)"ruby.doc.documentation.from.partial", (Object[])new Object[]{RContainerPresentationUtil.getLocation((RPsiElement)((RContainer)element))}) : RBundle.message((String)"ruby.doc.documentation.from.partial.no.address"));
            sb.append("</span>").append("</h4><p>");
            sb.append(doc);
            sb.append("</td>").append("</tr>");
        });
        if (((Boolean)openedSection.get()).booleanValue()) {
            sb.append("</table>");
        }
        return !sb.isEmpty() ? sb.toString() : null;
    }

    private static void renderSection(@NotNull StringBuilder builder2, @NotNull Map<String, String> section) {
        if (builder2 == null) {
            RubyHelpUtil.$$$reportNull$$$0(29);
        }
        if (section == null) {
            RubyHelpUtil.$$$reportNull$$$0(30);
        }
        if (section.isEmpty()) {
            return;
        }
        builder2.append("<table class='sections'>");
        for (String header : SECTIONS_ORDER) {
            String content = section.get(header);
            if (content == null) continue;
            builder2.append("<tr><td valign='top' class='section'><p>");
            builder2.append(header);
            builder2.append("</td><td valign='top'>");
            builder2.append(content);
        }
        builder2.append("</table>");
    }

    @Nullable
    private static Map<String, String> generateYardSection(@NotNull Project project, @NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RubyHelpUtil.$$$reportNull$$$0(31);
        }
        if (symbol == null) {
            RubyHelpUtil.$$$reportNull$$$0(32);
        }
        if (symbol instanceof RMethodSymbol) {
            PsiElement psiElement = symbol.getPsiElement();
            if (psiElement instanceof RMethod) {
                return RubyHelpUtil.generateYardSection(project, (RPsiElement)((RMethod)psiElement), invocationPoint);
            }
            if (psiElement instanceof MethodNameFakePsiElement) {
                YARDSubMethodDirective tag = YARDUtil.recreateTagByFakeMethodName((MethodNameFakePsiElement)psiElement);
                return tag != null ? RubyHelpUtil.generateYardSection(project, tag.getChildTags(), invocationPoint) : null;
            }
        }
        return null;
    }

    @Nullable
    private static Map<String, String> generateYardSection(@NotNull Project project, @NotNull RPsiElement element, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RubyHelpUtil.$$$reportNull$$$0(33);
        }
        if (element == null) {
            RubyHelpUtil.$$$reportNull$$$0(34);
        }
        return element instanceof RMethod ? RubyHelpUtil.generateYardSection(project, ((RMethod)element).getYARDTags(), invocationPoint) : null;
    }

    @Nullable
    private static Map<String, String> generateYardSection(@NotNull Project project, @NotNull List<YARDTag> yardTags, @Nullable PsiElement invocationPoint) {
        RPossibleCall call;
        if (project == null) {
            RubyHelpUtil.$$$reportNull$$$0(35);
        }
        if (yardTags == null) {
            RubyHelpUtil.$$$reportNull$$$0(36);
        }
        RBlockCall blockCall = (call = RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)invocationPoint, RPossibleCall.class, (boolean)false)))) != null ? RBlockCallNavigator.getByCall((RPsiElement)call) : null;
        List arguments = call != null ? call.getArguments() : Collections.emptyList();
        RCodeBlock block = blockCall != null ? blockCall.getBlock() : null;
        Map<ThreeState, List<YARDOverloadDirective>> matches = yardTags.stream().mapMulti(StreamUtil.select(YARDOverloadDirective.class, (Class[])new Class[0])).collect(Collectors.groupingBy(tag -> AnnotationsHelperCore.getROverloadSyntheticSignature((YARDOverloadDirective)tag).isMatch(project, arguments, block)));
        YARDOverloadDirective overload = (YARDOverloadDirective)ContainerUtil.getFirstItem((List)ContainerUtil.concat(matches.getOrDefault(ThreeState.YES, Collections.emptyList()), matches.getOrDefault(ThreeState.UNSURE, Collections.emptyList())));
        List tags = overload != null && call != null ? overload.getChildTags() : yardTags;
        HashMap<String, String> parameterData = new HashMap<String, String>();
        StringBuilder paramData = new StringBuilder();
        StringBuilder yieldParamData = new StringBuilder();
        StringBuilder optionData = new StringBuilder();
        for (YARDTag tag2 : tags) {
            String documentation;
            if (tag2 instanceof YARDParamTag) {
                documentation = ((YARDParamTag)tag2).getDescription();
                if (StringUtil.isEmptyOrSpaces((String)documentation)) continue;
                paramData.append("<p>").append(((YARDParamTag)tag2).getName()).append(" &mdash; ").append(documentation);
                continue;
            }
            if (tag2 instanceof YARDReturnTag) {
                documentation = ((YARDReturnTag)tag2).getDescription();
                if (StringUtil.isEmptyOrSpaces((String)documentation)) continue;
                parameterData.put(RETURNS_SECTION, documentation);
                continue;
            }
            if (tag2 instanceof YARDOptionTag) {
                if (optionData.isEmpty()) {
                    optionData.append("<p>For ").append(((YARDOptionTag)tag2).getName()).append(":</p>");
                }
                optionData.append("<p>").append(((YARDOptionTag)tag2).getOptionName()).append(" &mdash; ");
                if (((YARDOptionTag)tag2).isRequired()) {
                    optionData.append("(required) ");
                }
                optionData.append(((YARDOptionTag)tag2).getDescription());
                continue;
            }
            if (!(tag2 instanceof YARDYieldparamTag)) continue;
            documentation = ((YARDYieldparamTag)tag2).getDescription();
            yieldParamData.append("<p>").append(((YARDYieldparamTag)tag2).getName()).append(" &mdash; ").append(documentation);
        }
        if (!paramData.isEmpty()) {
            parameterData.put(PARAMS_SECTION, paramData.toString());
        }
        if (!optionData.isEmpty()) {
            parameterData.put(OPTIONS_SECTION, optionData.toString());
        }
        if (!yieldParamData.isEmpty()) {
            parameterData.put(YIELDS_SECTION, yieldParamData.toString());
        }
        return !parameterData.isEmpty() ? parameterData : null;
    }

    private static void appendPresentableName(@NotNull PsiElement targetElement, @Nullable Symbol targetSymbol, @Nullable PsiElement originalElement, StringBuilder builder2, boolean isForQuickDoc) {
        if (targetElement == null) {
            RubyHelpUtil.$$$reportNull$$$0(37);
        }
        if (targetSymbol != null && targetSymbol.getType() == Type.ALIAS) {
            if (targetElement instanceof RCall) {
                List args = ((RCall)targetElement).getArguments();
                if (args.size() == 2) {
                    RPsiElement newName = (RPsiElement)args.get(0);
                    RPsiElement oldName = (RPsiElement)args.get(1);
                    RubyHelpUtil.appendPresentableNameForAlias(newName != null ? RubyPsiUtilCore.getElementText((PsiElement)newName) : null, oldName != null ? RubyPsiUtilCore.getElementText((PsiElement)oldName) : null, builder2, isForQuickDoc);
                    return;
                }
            } else {
                if (targetElement instanceof RAliasStatement) {
                    RAliasStatement alias = (RAliasStatement)targetElement;
                    RubyHelpUtil.appendPresentableNameForAlias(alias.getName(), alias.getOldName(), builder2, isForQuickDoc);
                    return;
                }
                if (targetElement instanceof RubyAliasMethodNameFakePsiElement) {
                    RAliasStatement alias = (RAliasStatement)targetElement.getParent();
                    RubyHelpUtil.appendPresentableNameForAlias(alias.getName(), alias.getOldName(), builder2, isForQuickDoc);
                    return;
                }
            }
        }
        RubyHelpUtil.appendPresentableNameForContainer(targetElement, targetSymbol, originalElement, isForQuickDoc, builder2);
    }

    private static void appendVisibility(RPsiElement targetElement, @Nullable Symbol targetSymbol, StringBuilder builder2) {
        Symbol sourceMethod;
        if (targetElement instanceof RMethod) {
            String access = ((RMethod)targetElement).getVisibility().getPresentableName();
            builder2.append(access).append(' ');
        } else if (targetSymbol != null && targetSymbol.getType() == Type.ALIAS && (sourceMethod = SymbolUtil.getMethodSymbolByAlias(targetSymbol)) != null && sourceMethod instanceof RMethodSymbol) {
            String access = ((RMethodSymbol)sourceMethod).getVisibility().getPresentableName();
            builder2.append(access).append(' ');
        }
    }

    private static void appendLocation(RPsiElement targetElement, @Nullable Symbol targetSymbol, StringBuilder builder2, boolean useHtmlLayout) {
        String space;
        String string = space = useHtmlLayout ? "&nbsp;" : " ";
        if (targetElement instanceof RContainer || targetSymbol != null && targetSymbol.getType() == Type.ALIAS) {
            builder2.append(" ");
            builder2.append(RBundle.message((String)"in")).append(space);
            String locationText = RContainerPresentationUtil.getLocation((RPsiElement)targetElement);
            if (useHtmlLayout) {
                RubyDocumentationMarkupUtil.appendCode(builder2, locationText);
            } else {
                builder2.append(locationText);
            }
        }
        for (RubyElementNameAndDescriptionProvider provider : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            provider.appendVisibilityAndLocation((PsiElement)targetElement, builder2, useHtmlLayout);
        }
    }

    private static void appendSuperClassInfo(@NotNull Symbol targetSymbol, StringBuilder builder2, boolean isForQuickDoc, @Nullable PsiElement invocationPoint) {
        if (targetSymbol == null) {
            RubyHelpUtil.$$$reportNull$$$0(38);
        }
        if (targetSymbol.getType() == Type.CLASS) {
            Symbol superclass;
            Symbol symbol = superclass = targetSymbol instanceof ClassModuleSymbol ? ((ClassModuleSymbol)targetSymbol).getSuperClassSymbol(invocationPoint) : null;
            if (superclass != null) {
                if (isForQuickDoc) {
                    builder2.append("<span class='grayed'>");
                }
                builder2.append("&nbsp;&lt;&nbsp;");
                builder2.append(RubyHelpUtil.createRefText(superclass, RContainerPresentationUtil.getPresentableSymbolName((Symbol)superclass, (PsiElement)superclass.getPsiElement())));
                if (isForQuickDoc) {
                    builder2.append("</span>");
                }
            }
        }
    }

    private static void appendTypeInfo(@Nullable RPsiElement originalRPsiElement, RPsiElement targetElement, @Nullable Symbol targetSymbol, StringBuilder builder2) {
        RType type = null;
        String typeText = null;
        if (targetSymbol instanceof RMethodSymbol) {
            RPossibleCall possibleCall = (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)originalRPsiElement, RPossibleCall.class);
            RPossibleCall call = RCallNavigator.getRealCall((RPossibleCall)possibleCall);
            typeText = Arrays.stream((RubyMethodTypeDocPresentationProvider[])RubyMethodTypeDocPresentationProvider.EP_NAME.getExtensions()).map(provider -> provider.getMethodReturnTypeText((RMethodSymbol)targetSymbol, call)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (typeText == null) {
            if (RubyHelpUtil.isVariableLike(originalRPsiElement)) {
                type = RTypeUtil.getCoveringExpressionType((PsiElement)originalRPsiElement);
            }
            if (type == null) {
                if (targetSymbol instanceof RMethodSymbol && (type = RubyTypeProvider.createTypeBySymbolFromProviders((Symbol)targetSymbol, Collections.emptyList())) == null && targetElement instanceof RMethod) {
                    type = TypeInferenceContext.getInstance(targetSymbol.getProject()).inferControlFlowBasedReturnType((RMethod)targetElement);
                }
                if (type == null && originalRPsiElement == null && RubyHelpUtil.isVariableLike(targetElement)) {
                    type = RTypeUtil.getCoveringExpressionType((PsiElement)targetElement);
                }
            }
            if (type == null && targetSymbol instanceof TypedSymbol) {
                ContextImpl context = originalRPsiElement != null ? ContextImpl.getContext((PsiElement)originalRPsiElement) : null;
                context = context == null && targetElement != null ? ContextImpl.getContext((PsiElement)targetElement) : context;
                RType rType = type = context != null ? ((TypedSymbol)targetSymbol).getType((Context)context) : null;
            }
        }
        if (RTypeUtilCore.isNotEmpty(type) || typeText != null) {
            if (typeText == null) {
                typeText = RubyHelpUtil.createTypeText(type, targetElement);
            }
            if (targetSymbol instanceof CallableSymbol || targetElement instanceof RMethod) {
                builder2.append(RIGHT_ARROW);
                builder2.append(typeText);
            } else {
                builder2.append(" (");
                builder2.append(typeText);
                builder2.append(")");
            }
        }
    }

    private static void appendSymbolKindInfo(Symbol targetSymbol, StringBuilder builder2) {
        Type symbolKind;
        if (targetSymbol instanceof SingletonClassSymbol || targetSymbol instanceof AnonymousClassModuleSymbol) {
            return;
        }
        Type type = symbolKind = targetSymbol instanceof DelegateProducedSymbol ? Type.DELEGATE : targetSymbol.getType();
        if (symbolKind == Type.INSTANCE_METHOD || symbolKind == Type.CLASS_METHOD) {
            boolean isClassMethod = "$$SINGLETON$$".equals(targetSymbol.getFQNWithNesting().getCallerFQN().getShortName());
            builder2.append(RBundle.message((String)"ruby.doc.method")).append(' ').append(!isClassMethod ? "#" : "::");
        } else {
            String kindText = symbolKind.getPresentableName();
            if (kindText != null) {
                builder2.append(kindText).append(' ');
            }
        }
    }

    private static boolean isVariableLike(@Nullable RPsiElement element) {
        return element instanceof RIdentifier || element instanceof RInstanceVariable || element instanceof RClassVariable || element instanceof RConstant;
    }

    @NotNull
    private static List<String> splitByLines(@NotNull String text) {
        int eolIndex;
        if (text == null) {
            RubyHelpUtil.$$$reportNull$$$0(39);
        }
        int lastEolIndex = 0;
        ArrayList<String> lines = new ArrayList<String>();
        while ((eolIndex = text.indexOf(10, lastEolIndex)) != -1) {
            lines.add(text.substring(lastEolIndex, eolIndex));
            lastEolIndex = eolIndex + 1;
        }
        lines.add(text.substring(lastEolIndex));
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            RubyHelpUtil.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    public static RDocFormat getRDocFormat(@NotNull PsiFile file) {
        RFile rFile;
        if (file == null) {
            RubyHelpUtil.$$$reportNull$$$0(41);
        }
        if ((rFile = (RFile)ObjectUtils.tryCast((Object)file, RFile.class)) == null) {
            RDocFormat rDocFormat = RDocFormat.DEFAULT;
            if (rDocFormat == null) {
                RubyHelpUtil.$$$reportNull$$$0(42);
            }
            return rDocFormat;
        }
        RDocFormat rDocFormat = (RDocFormat)((Object)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            boolean markdownDirectiveFoundInFile = ContainerUtil.exists((Object[])((PsiElement[])ObjectUtils.coalesce((Object)PsiTreeUtil.getChildrenOfType((PsiElement)rFile.getCompoundStatement(), PsiComment.class), (Object)PsiElement.EMPTY_ARRAY)), it -> it.getText().contains(":markup: markdown"));
            if (markdownDirectiveFoundInFile) {
                return CachedValueProvider.Result.create((Object)((Object)RDocFormat.MARKDOWN), (Object[])new Object[]{file});
            }
            VirtualFile root = (VirtualFile)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getVirtualFileFromElement((PsiElement)rFile), it -> ProjectFileIndex.getInstance((Project)rFile.getProject()).getContentRootForFile(it));
            VirtualFile optionsFile = (VirtualFile)ObjectUtils.doIfNotNull((Object)root, it -> it.findChild(".rdoc_options"));
            if (optionsFile != null) {
                return CachedValueProvider.Result.create((Object)((Object)((RDocFormat)((Object)((Object)FileBasedIndex.getInstance().getSingleEntryIndexData(RDocFormatIndex.KEY, optionsFile, file.getProject()))))), (Object[])new Object[]{file});
            }
            return CachedValueProvider.Result.create((Object)((Object)RDocFormat.DEFAULT), (Object[])new Object[]{file});
        }));
        if (rDocFormat == null) {
            RubyHelpUtil.$$$reportNull$$$0(43);
        }
        return rDocFormat;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 13, 18, 24, 40, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 18: 
            case 24: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyHelpUtil";
                break;
            }
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 17: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionText";
                break;
            }
            case 22: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSymbol";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yardTags";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyHelpUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "linkinize";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeBrackets";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedDocumentation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpForSymbol";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getRDocFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHelpByElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementKindInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "linkinize";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 18: 
            case 24: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentableNameForContainer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodPresentableName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatDelegatedMethodPresentableName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processCodeDocumentation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRenderedDocumentation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterRDocDirectives";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHelpUsingResolveToSymbol";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionWithoutSymbol";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createHelpForSymbol";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendSymbolLocation";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationWithPartialDeclarations";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "renderSection";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateYardSection";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentableName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "appendSuperClassInfo";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRDocFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 13, 18, 24, 40, 42, 43 -> new IllegalStateException(string);
        };
    }
}

