/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RubyDocumentationUtil {
    @NonNls
    public static final String LINE_BREAK = "<br/>";

    @Contract(pure=true)
    @NotNull
    public static String trimNewLinesAtTheEnd(@NotNull String result) {
        int i;
        if (result == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(0);
        }
        for (i = result.length() - 1; i >= 0 && result.charAt(i) == '\n'; --i) {
        }
        String string = result.substring(0, i + 1);
        if (string == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isListBlockStarts(@NotNull String line) {
        String trimmedLine;
        if (line == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(2);
        }
        return RubyDocumentationUtil.isUnorderedListItem(trimmedLine = line.trim()) || RubyDocumentationUtil.isOrderedListItem(trimmedLine) || RubyDocumentationUtil.isLabeledListItem(trimmedLine);
    }

    public static boolean isUnorderedListItem(@NotNull String line) {
        if (line == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(3);
        }
        if (RubyDocumentationUtil.isLabeledListItem(line)) {
            return false;
        }
        return (line.startsWith("*") || line.startsWith("-")) && line.length() > 1 && Character.isWhitespace(line.charAt(1));
    }

    public static boolean isOrderedListItem(@NotNull String line) {
        int i;
        if (line == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(4);
        }
        if (line.isEmpty() || !Character.isDigit(line.charAt(0))) {
            return false;
        }
        for (i = 0; i < line.length() && Character.isDigit(line.charAt(i)); ++i) {
        }
        return i + 1 < line.length() && line.charAt(i) == '.' && Character.isWhitespace(line.charAt(i + 1));
    }

    public static boolean isLabeledListItem(@NotNull String line) {
        if (line == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(5);
        }
        return line.startsWith("[") && line.length() > 2 && line.contains("]") || line.contains(":: ");
    }

    public static boolean isCommentFollows(@NotNull PsiComment comment, @NotNull PsiComment nextComment) {
        PsiElement nextElement;
        if (comment == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(6);
        }
        if (nextComment == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(7);
        }
        return RubySpaceUtil.isNonMultilineSoftNewLine((PsiElement)(nextElement = comment.getNextSibling())) && nextElement.getNextSibling() == nextComment;
    }

    @NotNull
    public static String getHexFromColor(@NotNull Color color) {
        if (color == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(8);
        }
        String string = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        if (string == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getDocumentationTextColorHex() {
        TextAttributes documentationAttributes = RubyHighlighter.DOCUMENTATION_TEXT.getDefaultAttributes();
        Color documentationTextColor = documentationAttributes != null ? documentationAttributes.getForegroundColor() : null;
        return documentationTextColor != null ? RubyDocumentationUtil.getHexFromColor(documentationTextColor) : RubyDocumentationUtil.getHexFromColor(RubyDocumentationUtil.getEditorFontColor().darker());
    }

    @NotNull
    private static Color getEditorBackgroundColor() {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = colorsScheme.getDefaultBackground();
        if (color == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(10);
        }
        return color;
    }

    @NotNull
    private static Color getEditorFontColor() {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = colorsScheme.getDefaultForeground();
        if (color == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(11);
        }
        return color;
    }

    public static boolean isDocumentationLineComment(@NotNull PsiComment comment) {
        IElementType elementType;
        if (comment == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(12);
        }
        if (RubyPsiUtilCore.isPragmaComment((PsiComment)comment)) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)comment, RContainer.class) instanceof RMethod) {
            return false;
        }
        PsiComment element = comment;
        while (!(RubySpaceUtil.isSoftNewLine((IElementType)(elementType = PsiUtilCore.getElementType((PsiElement)element))) ? RubySpaceUtil.hasMultipleNewLines((PsiElement)element) : !(element instanceof PsiComment) && elementType != RubyTokenTypes.tWHITE_SPACE)) {
            element = element.getNextSibling();
        }
        return element instanceof RMethod || element instanceof RModule || element instanceof RClass;
    }

    public static int getIndent(@NotNull String line) {
        if (line == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(13);
        }
        return StringUtil.skipWhitespaceForward((CharSequence)line, (int)0);
    }

    @NotNull
    public static String getFirstWord(@NotNull String line) {
        int i;
        if (line == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(14);
        }
        line = line.trim();
        for (i = 0; i < line.length() && !Character.isWhitespace(line.charAt(i)); ++i) {
        }
        String string = line.substring(0, i);
        if (string == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String trimLineBreaks(@NotNull String text) {
        if (text == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(16);
        }
        int left = 0;
        while (text.startsWith(LINE_BREAK, left)) {
            if ((left += LINE_BREAK.length()) >= text.length() || text.charAt(left) != '\n') continue;
            ++left;
        }
        int right = text.length();
        while (text.startsWith(LINE_BREAK, right - LINE_BREAK.length())) {
            if ((right -= LINE_BREAK.length()) <= 0 || text.charAt(right - 1) != '\n') continue;
            --right;
        }
        String string = text.substring(left, right);
        if (string == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void ensurePaddingAfterUpperElement(List<String> lines) {
        int lineBreakBeforeCount;
        if (lines.isEmpty()) {
            return;
        }
        if (StringUtil.isEmpty((String)lines.get(lines.size() - 1))) {
            return;
        }
        String lastLine = lines.get(lines.size() - 1);
        if (lastLine.endsWith("</ul>") || lastLine.endsWith("</pre>")) {
            lineBreakBeforeCount = 1;
        } else {
            for (lineBreakBeforeCount = 0; lineBreakBeforeCount < 2 && lines.size() > lineBreakBeforeCount && lines.get(lines.size() - 1 - lineBreakBeforeCount).equals(LINE_BREAK); ++lineBreakBeforeCount) {
            }
        }
        while (lineBreakBeforeCount < 2) {
            lines.add(LINE_BREAK);
            ++lineBreakBeforeCount;
        }
    }

    @NotNull
    public static List<String> handleLineBreaks(@NotNull List<String> lines) {
        if (lines == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(18);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.isEmpty() && i > 0) {
                if (!result.isEmpty() && !LINE_BREAK.equals(result.get(result.size() - 1))) {
                    result.add(LINE_BREAK);
                }
                result.add(LINE_BREAK);
                continue;
            }
            result.add(line);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public static List<String> cutCommonIndent(@NotNull List<String> lines) {
        if (lines == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(20);
        }
        ArrayList<String> result = new ArrayList<String>();
        int minIndent = RubyDocumentationUtil.computeCommonIndent(lines);
        if (minIndent < 0) {
            return result;
        }
        for (String line : lines) {
            if (line.length() >= minIndent) {
                line = line.substring(minIndent);
            }
            result.add(line);
        }
        return result;
    }

    public static int computeCommonIndent(@NotNull List<String> lines) {
        if (lines == null) {
            RubyDocumentationUtil.$$$reportNull$$$0(21);
        }
        int minIndent = -1;
        for (String line : lines) {
            int indent;
            if (StringUtil.isEmptyOrSpaces((String)line) || (indent = RubyDocumentationUtil.getIndent(line)) >= minIndent && minIndent != -1) continue;
            minIndent = indent;
        }
        return minIndent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9, 10, 11, 15, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextComment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimNewLinesAtTheEnd";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHexFromColor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorBackgroundColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFontColor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstWord";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLineBreaks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "handleLineBreaks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimNewLinesAtTheEnd";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isListBlockStarts";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnorderedListItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOrderedListItem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLabeledListItem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCommentFollows";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHexFromColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentationLineComment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFirstWord";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trimLineBreaks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleLineBreaks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cutCommonIndent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeCommonIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9, 10, 11, 15, 17, 19 -> new IllegalStateException(string);
        };
    }
}

