/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyPsiLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RDocFormat;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.psi.VirtualBlockDocumentationComment;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.psi.VirtualDocumentationComment;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.psi.VirtualLineDocumentationComment;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public final class RubyDocumentationProvider
implements DocumentationProvider {
    private static final Logger LOG = Logger.getInstance(RubyDocumentationProvider.class);
    private static final String BASE_EXTERNAL_URL = "http://rubydoc.info/";

    @Nls
    public String getQuickNavigateInfo(@NotNull PsiElement targetElement, PsiElement elementAtCursorOrReferenceOwner) {
        RPsiElement targetRPsiElement;
        if (targetElement == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(0);
        }
        if ((targetRPsiElement = RubyDocumentationProvider.findCoveringRPsiElement(targetElement)) == null) {
            return null;
        }
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)targetElement, (PsiElement)elementAtCursorOrReferenceOwner, (String)RubyHelpUtil.getSimpleInfo(targetRPsiElement, elementAtCursorOrReferenceOwner, true));
    }

    public List<String> getUrlFor(PsiElement targetElement, PsiElement elementAtCursor) {
        Symbol symbol;
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)targetElement);
        if (vFile == null) {
            return null;
        }
        FQN fqn = FQN.INVALID;
        if (targetElement instanceof RContainer && (symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)targetElement))) != null) {
            fqn = symbol.getFQNWithNesting();
            VirtualFile parent = vFile.getParent();
            if (parent != null && parent.getName().startsWith("rubystubs")) {
                for (PsiElement declaration : symbol.getAllDeclarations(null)) {
                    VirtualFile declFile = declaration.getContainingFile().getVirtualFile();
                    if (declFile == null || declFile.getParent().getName().startsWith("rubystubs")) continue;
                    vFile = declFile;
                }
            }
        }
        ArrayList sdksToQuery = new ArrayList();
        Optional.ofNullable(elementAtCursor).map(ModuleUtilCore::findModuleForPsiElement).map(module -> ModuleRootManager.getInstance((Module)module).getSdk()).ifPresent(sdksToQuery::add);
        sdksToQuery.addAll(ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)RubySdkType.getInstance()));
        StringBuilder url = new StringBuilder(BASE_EXTERNAL_URL);
        for (Sdk sdk : sdksToQuery) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)vFile, (boolean)false)) continue;
                url.append("stdlib/");
                VirtualFile current = vFile;
                while (!Comparing.equal((Object)current.getParent(), (Object)root)) {
                    current = current.getParent();
                }
                String path = current.getNameWithoutExtension();
                url.append(root.getName().startsWith("rubystubs") ? "core" : path).append("/");
                String version = sdk.getVersionString();
                if (version != null) {
                    if (version.contains("1.8.7")) {
                        url.append("1.8.7/");
                    } else if (version.contains("1.8.6")) {
                        url.append("1.8.6/");
                    } else if (version.contains("1.9.2")) {
                        url.append("1.9.2/");
                    } else if (version.contains("1.9.3")) {
                        url.append("1.9.3/");
                    }
                }
                RubyDocumentationProvider.appendSymbolUrl(fqn, url);
                return Collections.singletonList(url.toString());
            }
            Collection<GemInfo> gems = GemManager.getInstance().getAllGems(sdk, ModuleUtilCore.findModuleForPsiElement((PsiElement)targetElement));
            for (GemInfo gem : gems) {
                VirtualFile gemFile = gem.getFile();
                if (gemFile == null || !gemFile.isValid() || !VfsUtilCore.isAncestor((VirtualFile)gemFile, (VirtualFile)vFile, (boolean)false)) continue;
                url.append("gems/").append(gem.getName()).append("/").append(gem.getVersion()).append("/");
                RubyDocumentationProvider.appendSymbolUrl(fqn, url);
                return Collections.singletonList(url.toString());
            }
        }
        return null;
    }

    private static void appendSymbolUrl(FQN fqn, StringBuilder url) {
        if (fqn != null) {
            boolean isMethod = fqn.getFullPath().contains(".");
            boolean isSingleton = false;
            FQN callerFQN = fqn.getCallerFQN();
            if ("$$SINGLETON$$".equals(callerFQN.getShortName())) {
                callerFQN = callerFQN.getCallerFQN();
                isSingleton = true;
            }
            url.append(callerFQN.getFullPath().replace("::", "/"));
            if (!isMethod) {
                url.append('/').append(fqn.getShortName());
            } else {
                url.append("#").append(fqn.getShortName());
                if (!isSingleton) {
                    url.append("-instance_method");
                } else {
                    url.append("-class_method");
                }
            }
        }
    }

    @Nls
    public String generateDoc(PsiElement targetElement, @Nullable PsiElement elementAtCursor) {
        if (targetElement instanceof RPsiElement) {
            if (elementAtCursor == null) {
                LOG.debug("original element is null for ", new Object[]{targetElement});
            }
            RPsiElement rPsiElementAtCursor = RubyDocumentationProvider.findCoveringRPsiElement(elementAtCursor);
            if (elementAtCursor != null && rPsiElementAtCursor == null) {
                LOG.debug("corresponding element is null for ", new Object[]{elementAtCursor, "; targetElement=", targetElement});
            }
            if (rPsiElementAtCursor != null && !rPsiElementAtCursor.isValid()) {
                LOG.debug("Invalid origin element ", new Object[]{rPsiElementAtCursor});
                return null;
            }
            return RubyHelpUtil.getHelpByElement(elementAtCursor, rPsiElementAtCursor, (RPsiElement)targetElement);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof RubyPsiLookupElement) {
            return ((RubyPsiLookupElement)object).getPsiElement();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return RubyHelpUtil.getElementByLink(link, psiManager);
    }

    @Nullable
    private static RPsiElement findCoveringRPsiElement(@Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        if (originalElement instanceof RPsiElement) {
            return (RPsiElement)originalElement;
        }
        RPsiElement coveringRPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)originalElement);
        if (coveringRPsiElement != null && originalElement.getTextRange() != null && coveringRPsiElement.getTextRange().getStartOffset() == originalElement.getTextRange().getStartOffset()) {
            return coveringRPsiElement;
        }
        int prevOffset = originalElement.getTextOffset() - 1;
        if (prevOffset >= 0) {
            RPsiElement prevCoveringRPsiElement;
            PsiElement prevElement = originalElement.getContainingFile().findElementAt(prevOffset);
            RPsiElement rPsiElement = prevCoveringRPsiElement = prevElement != null ? RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)prevElement) : null;
            if (prevCoveringRPsiElement != null && prevCoveringRPsiElement.getTextOffset() == prevElement.getTextOffset()) {
                return prevCoveringRPsiElement;
            }
        }
        return null;
    }

    private static void processDocComments(@NotNull Collection<? extends PsiComment> comments, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (comments == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(2);
        }
        PsiComment startingComment = null;
        PsiComment lastComment = null;
        for (PsiComment psiComment : comments) {
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)psiComment);
            if (elementType != RubyTokenTypes.TLINE_COMMENT || !RubyDocumentationUtil.isDocumentationLineComment(psiComment)) {
                if (startingComment != null) {
                    sink.accept(RubyDocumentationProvider.createVirtualDocumentationBlockComment(startingComment, lastComment));
                }
                startingComment = null;
                lastComment = null;
                if (elementType != RubyTokenTypes.tBLOCK_COMMENT) continue;
                sink.accept(RubyDocumentationProvider.createVirtualDocumentationBlockComment(psiComment));
                continue;
            }
            if (startingComment == null) {
                startingComment = psiComment;
                lastComment = psiComment;
                continue;
            }
            if (!RubyDocumentationUtil.isCommentFollows(lastComment, psiComment)) {
                sink.accept(RubyDocumentationProvider.createVirtualDocumentationBlockComment(startingComment, lastComment));
                startingComment = psiComment;
            }
            lastComment = psiComment;
        }
        if (lastComment != null) {
            sink.accept(RubyDocumentationProvider.createVirtualDocumentationBlockComment(startingComment, lastComment));
        }
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(4);
        }
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiComment.class);
        RubyDocumentationProvider.processDocComments(comments, sink);
    }

    private static VirtualDocumentationComment createVirtualDocumentationBlockComment(@NotNull PsiComment startingComment, @NotNull PsiComment lastComment) {
        if (startingComment == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (lastComment == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(6);
        }
        TextRange range = new TextRange(startingComment.getTextRange().getStartOffset(), lastComment.getTextRange().getEndOffset());
        RContainer target = (RContainer)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)lastComment), RContainer.class);
        return new VirtualLineDocumentationComment(startingComment.getParent(), range, target);
    }

    private static VirtualDocumentationComment createVirtualDocumentationBlockComment(@NotNull PsiComment comment) {
        if (comment == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(7);
        }
        TextRange range = new TextRange(0, comment.getTextLength());
        return new VirtualBlockDocumentationComment((PsiElement)comment, range);
    }

    @Nls
    @NotNull
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        String renderedText;
        RContainer rContainer;
        if (comment == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (!(comment instanceof VirtualDocumentationComment)) {
            return "";
        }
        VirtualDocumentationComment virtualDocumentationComment = (VirtualDocumentationComment)comment;
        if (comment instanceof VirtualLineDocumentationComment) {
            VirtualLineDocumentationComment lineComment = (VirtualLineDocumentationComment)comment;
            rContainer = lineComment.getTarget();
        } else {
            rContainer = null;
        }
        RContainer target = rContainer;
        String documentationColorHex = RubyDocumentationUtil.getDocumentationTextColorHex();
        if (RubyHelpUtil.getRDocFormat(comment.getContainingFile()) == RDocFormat.MARKDOWN) {
            String text = (String)ObjectUtils.coalesce((Object)RubyHelpUtil.filterRDocDirectives(String.join((CharSequence)"\n", virtualDocumentationComment.getCommentLines())), (Object)"");
            renderedText = DocMarkdownToHtmlConverter.convert((Project)comment.getProject(), (String)text, (Language)RubyLanguage.INSTANCE);
        } else {
            renderedText = RubyHelpUtil.getRenderedDocumentation(virtualDocumentationComment.getCommentLines(), comment.getProject(), target);
        }
        String string = String.format("<html><head><style></style></head><body><div class='content' style='color:%s'>", documentationColorHex) + renderedText + "</div></body></html>";
        if (string == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public PsiDocCommentBase findDocComment(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (range == null) {
            RubyDocumentationProvider.$$$reportNull$$$0(11);
        }
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiElement element = file.findElementAt(range.getStartOffset()); element != null && element.getTextRange().getStartOffset() < range.getEndOffset(); element = element.getNextSibling()) {
            if (!(element instanceof PsiComment)) continue;
            comments.add((PsiComment)element);
        }
        Ref docComment = new Ref();
        RubyDocumentationProvider.processDocComments(comments, base -> docComment.set(base));
        return (PsiDocCommentBase)docComment.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingComment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastComment";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRenderedDoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processDocComments";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDocComments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualDocumentationBlockComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateRenderedDoc";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

