/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.utils.MarkupConstants;

public class RubyDocumentationMarkupUtil
implements MarkupConstants {
    @NonNls
    private static final String FONT_SUFFIX = "</font>";

    @NotNull
    public static String applyHighlightingToLine(@NonNls @NotNull String line, @Nullable Symbol target) {
        IElementType tokenType;
        if (line == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(0);
        }
        Colorer colorer = new Colorer();
        StringBuilder builder2 = new StringBuilder();
        RDocLexer rDocLexer = new RDocLexer(true, true);
        rDocLexer.start((CharSequence)line);
        IElementType prevTokenType = null;
        IElementType prevPrevTokenType = null;
        String prevTokenText = "";
        while ((tokenType = rDocLexer.getTokenType()) != null) {
            String tokenText = rDocLexer.getTokenText();
            if (tokenType == RDocTokenTypes.DIRECTIVE) {
                builder2.append(colorer.getDirectivePrefix()).append(Matcher.quoteReplacement(tokenText.substring(1, tokenText.length() - 1))).append(FONT_SUFFIX);
            } else if (tokenType == RDocTokenTypes.VAR) {
                builder2.append("<b>").append("<em>").append("<code>").append(colorer.getFieldsPrefix()).append(tokenText).append(FONT_SUFFIX).append("</code>").append("</em>").append("</b>");
            } else if (tokenType == RDocTokenTypes.GVAR) {
                builder2.append("<b>").append("<code>").append(colorer.getGvarsPrefix()).append(tokenText).append(FONT_SUFFIX).append("</code>").append("</b>");
            } else if (tokenType == RDocTokenTypes.SYMBOL) {
                builder2.append("<b>").append("<code>").append(colorer.getSymbolsPrefix()).append(tokenText).append(FONT_SUFFIX).append("</code>").append("</b>");
            } else if (tokenType == RDocTokenTypes.PARAM || tokenType == RDocTokenTypes.RETURN) {
                builder2.append("<b>").append("<code>").append(colorer.getReswordsPrefix()).append(tokenText).append(FONT_SUFFIX).append("</code>").append("</b>");
            } else if (tokenType == RDocTokenTypes.EMAIL) {
                builder2.append(Matcher.quoteReplacement("<a href=\"mailto:" + tokenText + "\">" + tokenText + "</a>"));
            } else if (!(target == null || tokenType != RDocTokenTypes.TYPE && tokenType != RDocTokenTypes.CID || prevTokenText.equals("\\"))) {
                boolean isUppercased = Character.isUpperCase(tokenText.charAt(0));
                Symbol symbol = RubyDocumentationMarkupUtil.findSymbolInContext(target, tokenText, isUppercased);
                if (symbol != null && (isUppercased || prevTokenType == RDocTokenTypes.DELIMITER)) {
                    boolean classModuleOnly = (prevPrevTokenType != RDocTokenTypes.CID || prevTokenType != RDocTokenTypes.HASH) && prevTokenType != RDocTokenTypes.DELIMITER;
                    builder2.append(RubyHelpUtil.createRefText(symbol, !classModuleOnly ? symbol.getName() : RContainerPresentationUtil.getPresentableSymbolName((Symbol)symbol, (PsiElement)symbol.getPsiElement())));
                } else {
                    builder2.append(tokenText);
                }
            } else {
                builder2.append(tokenText);
            }
            rDocLexer.advance();
            prevPrevTokenType = prevTokenType;
            prevTokenType = tokenType;
            prevTokenText = tokenText;
        }
        String string = builder2.toString();
        if (string == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void appendBold(@NotNull StringBuilder builder2, @Nullable String s) {
        if (builder2 == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(2);
        }
        builder2.append("<b>").append(s).append("</b>");
    }

    public static void appendCode(@NotNull StringBuilder builder2, @Nullable String s) {
        if (builder2 == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(3);
        }
        builder2.append("<code>").append(s).append("</code>");
    }

    public static void appendBoldCode(@NotNull StringBuilder builder2, @Nullable String s) {
        if (builder2 == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(4);
        }
        builder2.append("<b>").append("<code>").append(s).append("</code>").append("</b>");
    }

    @NotNull
    public static String escapeTags(@NotNull String text) {
        if (text == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(5);
        }
        String result = RubyDocumentationMarkupUtil.escapeSpecialTags(text);
        result = StringUtil.escapeXmlEntities((String)result);
        String string = RubyDocumentationMarkupUtil.unescapeSpecialTags(result);
        if (string == null) {
            RubyDocumentationMarkupUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static String escapeSpecialTags(String text) {
        text = ((String)text).replaceAll("<b>", "\fB_OPEN_TAG\f");
        text = ((String)text).replaceAll("</b>", "\fB_CLOSE_TAG\f");
        text = ((String)text).replaceAll("<em>", "\fEM_OPEN_TAG\f");
        text = ((String)text).replaceAll("</em>", "\fEM_CLOSE_TAG\f");
        text = ((String)text).replaceAll("<i>", "\fEM_OPEN_TAG\f");
        text = ((String)text).replaceAll("</i>", "\fEM_CLOSE_TAG\f");
        text = ((String)text).replaceAll("<tt>", "\fTT_OPEN_TAG\f");
        text = ((String)text).replaceAll("</tt>", "\fTT_CLOSE_TAG\f");
        text = ((String)text).replaceAll("<code>", "\fCODE_OPEN_TAG\f");
        text = ((String)text).replaceAll("</code>", "\fCODE_CLOSE_TAG\f");
        text = ((String)text).replaceAll("<h1>", "\fH_OPEN_TAG_ONE\f");
        text = ((String)text).replaceAll("</h1>", "\fH_CLOSE_TAG_ONE\f");
        text = ((String)text).replaceAll("<h2>", "\fH_OPEN_TAG_TWO\f");
        text = ((String)text).replaceAll("</h2>", "\fH_CLOSE_TAG_TWO\f");
        text = ((String)text).replaceAll("<h3>", "\fH_OPEN_TAG_THREE\f");
        text = ((String)text).replaceAll("</h3>", "\fH_CLOSE_TAG_THREE\f");
        text = ((String)text).replaceAll("<h4>", "\fH_OPEN_TAG_FOUR\f");
        text = ((String)text).replaceAll("</h4>", "\fH_CLOSE_TAG_FOUR\f");
        text = ((String)text).replaceAll("<a href=\"", "\fH_OPEN_HYPERLINK\f");
        int i = ((String)text).indexOf("\fH_OPEN_HYPERLINK\f");
        while (i >= 0) {
            int closingBracketIndex = ((String)text).indexOf("\">", i);
            text = ((String)text).substring(0, closingBracketIndex) + "\fH_OPEN_HYPERLINK_CLOSING_BRACKET\f" + ((String)text).substring(closingBracketIndex + 2);
            i = ((String)text).indexOf("\fH_OPEN_HYPERLINK\f", i + 1);
        }
        text = ((String)text).replaceAll("</a>", "\fH_CLOSE_HYPERLINK\f");
        return text;
    }

    private static String unescapeSpecialTags(String text) {
        text = text.replaceAll("\fB_OPEN_TAG\f", "<b>");
        text = text.replaceAll("\fB_CLOSE_TAG\f", "</b>");
        text = text.replaceAll("\fEM_OPEN_TAG\f", "<em>");
        text = text.replaceAll("\fEM_CLOSE_TAG\f", "</em>");
        text = text.replaceAll("\fTT_OPEN_TAG\f", "<tt>");
        text = text.replaceAll("\fTT_CLOSE_TAG\f", "</tt>");
        text = text.replaceAll("\fCODE_OPEN_TAG\f", "<code>");
        text = text.replaceAll("\fCODE_CLOSE_TAG\f", "</code>");
        text = text.replaceAll("\fH_OPEN_TAG_ONE\f", "<h1>");
        text = text.replaceAll("\fH_CLOSE_TAG_ONE\f", "</h1>");
        text = text.replaceAll("\fH_OPEN_TAG_TWO\f", "<h2>");
        text = text.replaceAll("\fH_CLOSE_TAG_TWO\f", "</h2>");
        text = text.replaceAll("\fH_OPEN_TAG_THREE\f", "<h3>");
        text = text.replaceAll("\fH_CLOSE_TAG_THREE\f", "</h3>");
        text = text.replaceAll("\fH_OPEN_TAG_FOUR\f", "<h4>");
        text = text.replaceAll("\fH_CLOSE_TAG_FOUR\f", "</h4>");
        text = text.replaceAll("\fH_OPEN_HYPERLINK\f", "<a href=\"");
        text = text.replaceAll("\fH_OPEN_HYPERLINK_CLOSING_BRACKET\f", "\">");
        text = text.replaceAll("\fH_CLOSE_HYPERLINK\f", "</a>");
        return text;
    }

    @Nullable
    private static Symbol findSymbolInContext(Symbol target, String tokenText, boolean classModuleOnly) {
        PsiElement element = target.getPsiElement();
        if (!(element instanceof RPsiElement)) {
            return null;
        }
        Symbol context = SymbolUtil.getScopeContext(target);
        if (context == null) {
            return null;
        }
        FQN fqn = FQN.Builder.fromString((String)tokenText);
        return classModuleOnly ? SymbolUtil.lookupConstant(context, element, fqn, Types.MODULE_OR_CLASS, element) : SymbolUtil.lookupMethod(context, fqn, SymbolUtil.getMethodTypes(), element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationMarkupUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationMarkupUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "applyHighlightingToLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyHighlightingToLine";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendBold";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendBoldCode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapeTags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }

    private static final class Colorer {
        private final String directive;
        private final String reswords;
        private final String symbols;
        private final String fields;
        private final String gvars;

        private static String getFontPrefix(TextAttributesKey textAttributesKey) {
            Color foregroundColor = (Color)ObjectUtils.doIfNotNull((Object)textAttributesKey.getDefaultAttributes(), TextAttributes::getForegroundColor);
            return foregroundColor != null ? "<font color=#" + ColorUtil.toHex((Color)foregroundColor) + ">" : "";
        }

        Colorer() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.directive = "<font color=#0000FF>";
                this.reswords = "<font color=#000066>";
                this.symbols = "<font color=#0099FF>";
                this.fields = "<font color=#9900FF>";
                this.gvars = "<font color=#000000>";
            } else {
                this.directive = Colorer.getFontPrefix(RubyHighlighter.NUMBER);
                this.reswords = Colorer.getFontPrefix(RubyHighlighter.KEYWORD);
                this.symbols = Colorer.getFontPrefix(RubyHighlighter.SYMBOL);
                this.fields = Colorer.getFontPrefix(RubyHighlighter.IVAR);
                this.gvars = Colorer.getFontPrefix(RubyHighlighter.GVAR);
            }
        }

        private String getDirectivePrefix() {
            return this.directive;
        }

        private String getReswordsPrefix() {
            return this.reswords;
        }

        private String getSymbolsPrefix() {
            return this.symbols;
        }

        private String getFieldsPrefix() {
            return this.fields;
        }

        private String getGvarsPrefix() {
            return this.gvars;
        }
    }
}

