/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDSubMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyCommentsHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.CommentDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RMethodWithPossibleInlineVisibilityModifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;

public final class RubyCommentsUtil {
    private RubyCommentsUtil() {
    }

    @NotNull
    public static List<PsiComment> getCommentsFollowing(@NotNull PsiComment comment) {
        if (comment == null) {
            RubyCommentsUtil.$$$reportNull$$$0(0);
        }
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        PsiComment next = comment;
        IElementType nextElementType = PsiUtilCore.getElementType((PsiElement)next);
        while (nextElementType == RubyTokenTypes.TLINE_COMMENT || RubySpaceUtil.isSoftSpace((IElementType)nextElementType)) {
            if (nextElementType == RubyTokenTypes.TLINE_COMMENT) {
                comments.add(next);
            } else if (RubySpaceUtil.isMultiLineSoftNewLine((PsiElement)next)) {
                ArrayList<PsiComment> arrayList = comments;
                if (arrayList == null) {
                    RubyCommentsUtil.$$$reportNull$$$0(1);
                }
                return arrayList;
            }
            next = next.getNextSibling();
            nextElementType = PsiUtilCore.getElementType((PsiElement)next);
        }
        ArrayList<PsiComment> arrayList = comments;
        if (arrayList == null) {
            RubyCommentsUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static boolean isMethodDoc(@Nullable PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        return ((StreamEx)StreamEx.iterate((Object)element, PsiTreeUtil::nextLeaf).takeWhile(it -> Objects.nonNull(it) && (!(it instanceof PsiWhiteSpace) || RubySpaceUtil.isSingleSoftNewLine((PsiElement)it)))).findFirst(it -> !(it instanceof PsiComment) && !(it instanceof PsiWhiteSpace)).map(it -> it instanceof LeafPsiElement && it.getText().equals("def") ? (RPsiStructureElement)PsiTreeUtil.getParentOfType((PsiElement)it, RMethod.class, (boolean)false) : (RPsiStructureElement)PsiTreeUtil.getParentOfType((PsiElement)it, RCall.class, (boolean)false)).filter(it -> RMethodWithPossibleInlineVisibilityModifier.from((PsiElement)it) != null).isPresent();
    }

    @NotNull
    public static List<CommentDescriptor> collectCommentDescriptorsFromStatement(@NotNull RCompoundStatement statement) {
        if (statement == null) {
            RubyCommentsUtil.$$$reportNull$$$0(3);
        }
        ArrayList accumulator = new ArrayList();
        ArrayList<Object> current = new ArrayList<PsiComment>();
        for (PsiElement child = statement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment) {
                current.add((PsiComment)child);
                continue;
            }
            if (current.isEmpty()) continue;
            if (child instanceof PsiWhiteSpace && !RubySpaceUtil.isSingleSoftNewLine((PsiElement)child) || child instanceof LeafPsiElement && child.getText().equals("end")) {
                accumulator.add(CommentDescriptor.withoutAnchor(current));
                current = new ArrayList();
                continue;
            }
            if (child.getTextRange().isEmpty() || child instanceof PsiWhiteSpace) continue;
            PsiElement anchor = child;
            while (anchor instanceof RCompoundStatement || anchor instanceof RBodyStatement) {
                anchor = anchor.getFirstChild();
            }
            accumulator.add(new CommentDescriptor(current, anchor));
            current = new ArrayList();
        }
        if (!current.isEmpty()) {
            accumulator.add(CommentDescriptor.withoutAnchor(current));
        }
        List<CommentDescriptor> list = accumulator.isEmpty() ? Collections.emptyList() : accumulator;
        if (list == null) {
            RubyCommentsUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static String getPsiHelpWithoutYARD(@NotNull PsiElement element) {
        if (element == null) {
            RubyCommentsUtil.$$$reportNull$$$0(5);
        }
        if (!element.isValid()) {
            return null;
        }
        if (element instanceof RIdentifier) {
            String helpFromTags = RubyCommentsUtilCore.getPsiHelpForIdentifier((RIdentifier)((RIdentifier)element));
            if (helpFromTags != null) {
                return helpFromTags;
            }
        } else if (element instanceof MethodNameFakePsiElement) {
            YARDSubMethodDirective tag = YARDUtil.recreateTagByFakeMethodName((MethodNameFakePsiElement)element);
            return tag != null ? tag.getDescription() : null;
        }
        List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)element);
        List yardTags = YARDParser.parse((List)comments);
        return RubyCommentsUtilCore.joinComments(YARDUtil.getCommentsWithoutYARD(comments, yardTags));
    }

    @Nullable
    public static PsiComment getEndOfLineComment(@NotNull PsiElement anchor) {
        if (anchor == null) {
            RubyCommentsUtil.$$$reportNull$$$0(6);
        }
        PsiElement sibling = anchor.getNextSibling();
        while (sibling instanceof PsiWhiteSpace && !sibling.getText().contains("\n")) {
            sibling = sibling.getNextSibling();
        }
        return (PsiComment)ObjectUtils.tryCast((Object)sibling, PsiComment.class);
    }

    @Nullable
    public static PsiComment getArrayElementComment(@NotNull PsiElement arrayElement) {
        if (arrayElement == null) {
            RubyCommentsUtil.$$$reportNull$$$0(7);
        }
        PsiElement comment = arrayElement.getNextSibling();
        while (!RubyCommentsUtil.isRubyLineComment(comment)) {
            if (comment == null) {
                return null;
            }
            ASTNode node = comment.getNode();
            if (node == null) {
                return null;
            }
            if (comment instanceof PsiWhiteSpace || RubyTokenTypes.tCOMMA == node.getElementType()) {
                comment = comment.getNextSibling();
                continue;
            }
            return null;
        }
        return (PsiComment)comment;
    }

    @Nullable
    public static PsiComment getNextComment(@NotNull PsiElement anchorElement, @NotNull IElementType commentType) {
        if (anchorElement == null) {
            RubyCommentsUtil.$$$reportNull$$$0(8);
        }
        if (commentType == null) {
            RubyCommentsUtil.$$$reportNull$$$0(9);
        }
        PsiElement comment = PsiTreeUtil.nextLeaf((PsiElement)anchorElement);
        while (PsiUtilCore.getElementType((PsiElement)comment) != commentType) {
            if (!(RubySpaceUtil.isSingleSoftNewLine((PsiElement)comment) || comment != null && comment.getLanguage() == Language.ANY)) {
                return null;
            }
            comment = PsiTreeUtil.nextLeaf((PsiElement)comment);
        }
        return (PsiComment)comment;
    }

    private static boolean isRubyLineComment(@Nullable PsiElement comment) {
        if (comment == null) {
            return false;
        }
        ASTNode node = comment.getNode();
        return node != null && node.getElementType() == RubyTokenTypes.TLINE_COMMENT;
    }

    @Nullable
    public static SerializableType getTypeFromTypeComment(@NotNull RInstanceVariable target) {
        RAssignmentExpression assignment;
        if (target == null) {
            RubyCommentsUtil.$$$reportNull$$$0(10);
        }
        if ((assignment = (RAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)target, RAssignmentExpression.class)) == null) {
            return null;
        }
        String helpWithoutSharps = RubyCommentsUtilCore.getPsiHelpWithoutLeadingSharps((PsiElement)assignment);
        if (helpWithoutSharps == null) {
            return null;
        }
        boolean isMultiAssignment = assignment instanceof RMultiAssignmentExpression;
        return RubyCommentsHelper.extractYARDVariableTypeAnnotationFromComment((String)helpWithoutSharps, (String)target.getName(), (!isMultiAssignment ? 1 : 0) != 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyCommentsUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyCommentsUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsFollowing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommentDescriptorsFromStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsFollowing";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectCommentDescriptorsFromStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiHelpWithoutYARD";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndOfLineComment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNextComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

