/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.annotator.RubyAnnotatorUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class RubySlowAnnotatorVisitor
extends RubyElementVisitor {
    private final AnnotationHolder myHolder;
    private final Set<String> myParamDefNames;
    private final Set<FQN> myFQNs;

    public RubySlowAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            RubySlowAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        this.myFQNs = ParamDefManager.getInstance().getHighlightedFQNs();
        this.myParamDefNames = ContainerUtil.map2Set(this.myFQNs, FQN::getShortName);
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            RubySlowAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        if (RCompoundStatementNavigator.isStatement((PsiElement)rIdentifier) || RBlockCallNavigator.getByCall((RPsiElement)rIdentifier) != null) {
            this.highlightCall((PsiElement)rIdentifier, rIdentifier.getName());
        }
    }

    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubySlowAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        PsiElement command = RubyAnnotatorUtil.getHighlightElementForCall((RPossibleCall)rCall);
        this.highlightCall(command, command.getText());
    }

    private void highlightParamdef(@NotNull PsiElement element) {
        String annotationText;
        if (element == null) {
            RubySlowAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        String string = annotationText = ApplicationManager.getApplication().isUnitTestMode() ? RubyHighlighter.RUBY_PARAMDEF_CALL.getExternalName() : null;
        if (annotationText == null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(RubyHighlighter.RUBY_PARAMDEF_CALL).create();
        } else {
            this.myHolder.newAnnotation(HighlightSeverity.INFORMATION, annotationText).range(element).textAttributes(RubyHighlighter.RUBY_PARAMDEF_CALL).create();
        }
    }

    private void highlightCall(@NotNull PsiElement call, @Nullable String name) {
        if (call == null) {
            RubySlowAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (name == null || !this.myParamDefNames.contains(name)) {
            return;
        }
        PsiReference psiReference = call.getReference();
        if (psiReference instanceof RPsiPolyVariantReference) {
            FQN fqn;
            RPsiPolyVariantReference reference = (RPsiPolyVariantReference)psiReference;
            SymbolResolveResult result = reference.resolveToSymbol();
            FQN fQN = fqn = result.isValidResult() ? RObjectClass.makeNonSingletonClassFqn((FQN)result.getSymbol().getFQNWithNesting()) : null;
            if (fqn == null || this.myFQNs.contains(fqn)) {
                this.highlightParamdef(call);
            }
        } else {
            this.highlightParamdef(call);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubySlowAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightParamdef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

