/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;

public final class RubyWordsScanner
extends DefaultWordsScanner
implements WordsScanner {
    private static final TokenSet ADJUSTABLE_CODE_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{Ruby19TokenTypes.tIVAR, Ruby19TokenTypes.tCVAR, Ruby19TokenTypes.tGVAR, Ruby19TokenTypes.tFID, Ruby19TokenTypes.tAID, Ruby19TokenTypes.kDEFINED});
    private static final TokenSet CODE_TOKENSET = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tVARIABLES, TokenSet.create((IElementType[])new IElementType[]{Ruby19TokenTypes.tFID, Ruby19TokenTypes.tAID}), TokenBNF.kALL_KEYWORDS}), (TokenSet)ADJUSTABLE_CODE_TOKENSET);
    private static final TokenSet LITERALS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{Ruby19TokenTypes.tSYMBOLS_CONTENT}), TokenBNF.tSTRING_LIKE_CONTENTS});
    private static final Logger LOG = Logger.getInstance(RubyWordsScanner.class);

    public RubyWordsScanner() {
        super((Lexer)new RubyLexer(), TokenSet.EMPTY, TokenSet.EMPTY, TokenSet.EMPTY);
    }

    public void processWordsUsingPsi(@NotNull FileContent inputData, @NotNull Processor<? super WordOccurrence> processor) {
        LeafElement run2;
        if (inputData == null) {
            RubyWordsScanner.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            RubyWordsScanner.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = inputData.getPsiFile();
        FileASTNode fileNode = psiFile.getNode();
        try {
            run2 = TreeUtil.findFirstLeaf((ASTNode)fileNode);
        }
        catch (StackOverflowError e) {
            LOG.warn("Could not process words in file " + psiFile.getName() + ". File text: \n" + StringUtil.shortenTextWithEllipsis((String)psiFile.getText(), (int)512, (int)256), (Throwable)e);
            return;
        }
        if (run2 == null) {
            return;
        }
        CharSequence fileText = inputData.getContentAsText();
        WordOccurrence occurrence = new WordOccurrence(fileText, 0, 0, WordOccurrence.Kind.CODE);
        while (run2 != null) {
            int startOffset = run2.getStartOffset();
            if (!RubyWordsScanner.processToken(fileText, processor, run2.getElementType(), startOffset, startOffset + run2.getTextLength(), occurrence)) {
                return;
            }
            run2 = TreeUtil.nextLeaf((LeafElement)run2);
        }
    }

    public void processWords(@NotNull CharSequence fileText, @NotNull Processor<? super WordOccurrence> processor) {
        if (fileText == null) {
            RubyWordsScanner.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            RubyWordsScanner.$$$reportNull$$$0(3);
        }
        RubyLexer lexer = new RubyLexer();
        lexer.start(fileText);
        WordOccurrence occurrence = new WordOccurrence(fileText, 0, 0, WordOccurrence.Kind.CODE);
        while (lexer.getTokenType() != null) {
            if (!RubyWordsScanner.processToken(fileText, processor, lexer.getTokenType(), lexer.getTokenStart(), lexer.getTokenEnd(), occurrence)) {
                return;
            }
            lexer.advance();
        }
    }

    private static boolean processToken(@NotNull CharSequence fileText, @NotNull Processor<? super WordOccurrence> processor, @NotNull IElementType type, int start, int end, @NotNull WordOccurrence occurrence) {
        if (fileText == null) {
            RubyWordsScanner.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            RubyWordsScanner.$$$reportNull$$$0(5);
        }
        if (type == null) {
            RubyWordsScanner.$$$reportNull$$$0(6);
        }
        if (occurrence == null) {
            RubyWordsScanner.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        if (ADJUSTABLE_CODE_TOKENSET.contains(type)) {
            if (type == Ruby19TokenTypes.tIVAR) {
                ++start;
            } else if (type == Ruby19TokenTypes.tCVAR) {
                start += 2;
            } else if (type == Ruby19TokenTypes.tGVAR) {
                ++start;
            } else if ((type == Ruby19TokenTypes.tFID || type == Ruby19TokenTypes.tAID || type == Ruby19TokenTypes.kDEFINED) && StringUtil.containsChar((String)"=?!", (char)fileText.charAt(end - 1))) {
                --end;
            }
            occurrence.init(fileText, start, end, WordOccurrence.Kind.CODE);
            if (!processor.process((Object)occurrence)) {
                return false;
            }
        } else if (CODE_TOKENSET.contains(type)) {
            occurrence.init(fileText, start, end, WordOccurrence.Kind.CODE);
            if (!processor.process((Object)occurrence)) {
                return false;
            }
        } else if (TokenBNF.tCOMMENTS.contains(type) ? !RubyWordsScanner.stripWords(processor, (CharSequence)fileText, (int)start, (int)end, (WordOccurrence.Kind)WordOccurrence.Kind.COMMENTS, (WordOccurrence)occurrence, (boolean)false) : LITERALS.contains(type) && !RubyWordsScanner.stripWords(processor, (CharSequence)fileText, (int)start, (int)end, (WordOccurrence.Kind)WordOccurrence.Kind.LITERALS, (WordOccurrence)occurrence, (boolean)false)) {
            return false;
        }
        return true;
    }

    public int getVersion() {
        return 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/RubyWordsScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processWordsUsingPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processWords";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

