/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsoleUtil;
import org.jetbrains.plugins.ruby.erb.psi.ErbFile;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals.AssignParameterToFieldFix;
import org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals.RemoveAssignmentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals.RenameToConstantFix;
import org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals.ReplaceWithWildcardFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriding.RubyOverridingMethodsSearch;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

final class RubyUnusedLocalVariableVisitor
extends RubyInspectionVisitor {
    RubyUnusedLocalVariableVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitErbFile(@NotNull ErbFile rFile) {
        if (rFile == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(1);
        }
    }

    public void visitRFile(@NotNull RFile rFile) {
        if (rFile == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(2);
        }
        this.processScopeHolder((ScopeHolder)rFile);
    }

    public void visitRModule(@NotNull RModule rModule) {
        if (rModule == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(3);
        }
        this.processScopeHolder((ScopeHolder)rModule);
    }

    public void visitRClass(@NotNull RClass rClass) {
        if (rClass == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(4);
        }
        this.processScopeHolder((ScopeHolder)rClass);
    }

    public void visitRObjectClass(@NotNull RObjectClass rsClass) {
        if (rsClass == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(5);
        }
        this.processScopeHolder((ScopeHolder)rsClass);
    }

    public void visitRMethod(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(6);
        }
        this.processScopeHolder((ScopeHolder)rMethod);
    }

    public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
        if (rsMethod == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(7);
        }
        this.processScopeHolder((ScopeHolder)rsMethod);
    }

    private void processScopeHolder(@NotNull ScopeHolder holder) {
        if (holder == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(8);
        }
        this.processScopeHolder(holder, new HashMap<String, Set<RPsiElement>>(), new HashMap<String, Set<RPsiElement>>(), true);
    }

    private void processScopeHolder(@NotNull ScopeHolder holder, @NotNull Map<String, Set<RPsiElement>> unusedMap, @NotNull Map<String, Set<RPsiElement>> usedMap, boolean reportProblems) {
        Object name;
        if (holder == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(9);
        }
        if (unusedMap == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(10);
        }
        if (usedMap == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(11);
        }
        if (holder.getContainingFile() instanceof RubyExpressionCodeFragment || RubyLanguageConsoleUtil.isInLanguageConsole((PsiElement)holder)) {
            return;
        }
        RControlFlow flow = holder.getControlFlow();
        Scope scope = holder.getScope();
        Instruction[] instructions = flow.getInstructions();
        LanguageLevel languageLevel = holder.getLanguageLevel();
        for (Instruction instruction : instructions) {
            PsiElement element = instruction.getElement();
            if (instruction instanceof ReadWriteInstruction) {
                boolean inSelfAssignment;
                if (!(element instanceof RIdentifier)) continue;
                RIdentifier identifier = (RIdentifier)element;
                name = ((ReadWriteInstruction)instruction).getName();
                ScopeVariable scopeVariable = scope.getDeclaredVariable(instruction, (String)name);
                if (RubyUnusedLocalVariableVisitor.ignoreWildcardAndField(languageLevel, (String)name, (PsiElement)identifier)) continue;
                boolean bl = inSelfAssignment = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)identifier) != null;
                if (scopeVariable != null) {
                    if (scopeVariable.isUsed() || inSelfAssignment) {
                        Collection declarations = scopeVariable.getDeclarations();
                        if (inSelfAssignment && !scopeVariable.isUsed()) {
                            RubyUnusedLocalVariableVisitor.addToMapExceptOneElement(usedMap, (String)name, declarations, (RPsiElement)identifier);
                            RubyUnusedLocalVariableVisitor.addToMap(unusedMap, (String)name, (RPsiElement)identifier);
                        } else {
                            RubyUnusedLocalVariableVisitor.addToMap(usedMap, (String)name, declarations);
                        }
                    } else {
                        RubyUnusedLocalVariableVisitor.addToMap(unusedMap, (String)name, (RPsiElement)identifier);
                    }
                }
            } else if (element instanceof RAssocList || element instanceof RCall) {
                List assocs = element instanceof RAssocList ? ((RAssocList)element).getAssocElements() : ContainerUtil.filterIsInstance((Collection)((RCall)element).getArguments(), RAssoc.class);
                name = assocs.iterator();
                while (name.hasNext()) {
                    String name2;
                    ScopeVariable variable;
                    RAssoc assoc = (RAssoc)name.next();
                    if (!(assoc.getKey() instanceof RAssocKey) || assoc.getValue() != null || (variable = scope.getDeclaredVariable(instruction, name2 = assoc.getKeyText())) == null) continue;
                    RubyUnusedLocalVariableVisitor.addToMap(usedMap, name2, variable.getDeclarations());
                }
            }
            if (element instanceof RCodeBlock) {
                this.processScopeHolder((ScopeHolder)((RCodeBlock)element), unusedMap, usedMap, false);
            }
            if (!(holder instanceof RMethod) || !(element instanceof RPseudoConstant) || RCallNavigator.getByCommand((PsiElement)element) != null || !RubyTokenTypes.kSUPER.toString().equals(element.getText())) continue;
            for (ArgumentInfo argumentInfo : ((RMethod)holder).getArgumentInfos()) {
                unusedMap.remove(argumentInfo.getName());
            }
        }
        if (!reportProblems) {
            return;
        }
        RubyUnusedLocalVariableVisitor.processUsedAndUnused(unusedMap, usedMap);
        for (Set set : unusedMap.values()) {
            HashSet<RMethod> methodWithInheritors = new HashSet<RMethod>();
            for (PsiElement element : set) {
                String message;
                ArrayList<Object> fixes;
                RIdentifier id = (RIdentifier)element;
                name = id.getName();
                if (id.isParameterDeclaration()) {
                    RMethod method;
                    if (id.isMethodParameterDeclaration() && RubyUnusedLocalVariableVisitor.cantHaveUnusedParameters(method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class), methodWithInheritors)) continue;
                    fixes = new ArrayList<Object>();
                    if (holder instanceof RMethod && holder.getParentContainer() instanceof RClass && id.isMethodParameterDeclaration()) {
                        fixes.add(new AssignParameterToFieldFix(id));
                    }
                    if (ReplaceWithWildcardFix.canBeApplied(id)) {
                        fixes.add(new ReplaceWithWildcardFix());
                    }
                    message = RBundle.message((String)(usedMap.containsKey(name) ? "inspection.unused.locals.parameter.value.is.not.used.anymore" : "inspection.unused.locals.parameter.is.not.used"), (Object[])new Object[]{name});
                    this.registerProblem(element, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    continue;
                }
                if (RCallNavigator.getByRArgument((PsiElement)element.getParent()) != null) continue;
                fixes = new ArrayList();
                message = RBundle.message((String)(usedMap.containsKey(name) ? "inspection.unused.locals.local.value.is.not.used.anymore" : "inspection.unused.locals.local.is.not.used"), (Object[])new Object[]{name});
                if (ReplaceWithWildcardFix.canBeApplied(id)) {
                    fixes.add(new ReplaceWithWildcardFix());
                }
                if (RemoveAssignmentFix.canBeApplied((PsiElement)id)) {
                    fixes.add(new RemoveAssignmentFix());
                }
                if (RenameToConstantFix.canBeApplied((RPsiElement)id)) {
                    fixes.add(new RenameToConstantFix());
                }
                this.registerProblem(element, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static boolean ignoreWildcardAndField(LanguageLevel languageLevel, String name, PsiElement element) {
        if (!(element instanceof RIdentifier) || "_".equals(name)) {
            return true;
        }
        return LanguageLevel.RUBY19.isLessThan(languageLevel) && name != null && name.startsWith("_");
    }

    private static boolean inheritsMethod(@NotNull RMethod method, @Nullable PsiElement inheritedMethod) {
        if (method == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(12);
        }
        return inheritedMethod != null && (!(inheritedMethod instanceof RMethod) || ArgumentInfoUtil.areArgumentsCompatible((List)((RMethod)inheritedMethod).getArgumentInfos(), (List)method.getArgumentInfos()));
    }

    private static boolean cantHaveUnusedParameters(@NotNull RMethod method, @NotNull Set<RMethod> methodsWithInheritors) {
        if (method == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(13);
        }
        if (methodsWithInheritors == null) {
            RubyUnusedLocalVariableVisitor.$$$reportNull$$$0(14);
        }
        if (methodsWithInheritors.contains(method)) {
            return true;
        }
        PsiElement superMethod = (PsiElement)ObjectUtils.doIfNotNull((Object)((Symbol)RubySuperMethodsSearch.search(method).findFirst()), Symbol::getPsiElement);
        if (RubyUnusedLocalVariableVisitor.inheritsMethod(method, superMethod)) {
            methodsWithInheritors.add(method);
            return true;
        }
        for (PsiElement overriddenMethod : RubyOverridingMethodsSearch.search(method).findAll()) {
            if (!RubyUnusedLocalVariableVisitor.inheritsMethod(method, overriddenMethod)) continue;
            methodsWithInheritors.add(method);
            return true;
        }
        final Ref superSeen = new Ref((Object)false);
        method.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
                if (rPseudoConstant == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RubyTokenTypes.kSUPER.toString().equals(rPseudoConstant.getText()) && RubyPsiUtilCore.getStatement((PsiElement)rPseudoConstant) == rPseudoConstant) {
                    superSeen.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rPseudoConstant", "org/jetbrains/plugins/ruby/ruby/inspections/unusedlocals/RubyUnusedLocalVariableVisitor$1", "visitRPseudoConstant"));
            }
        });
        return (Boolean)superSeen.get();
    }

    private static void processUsedAndUnused(Map<String, Set<RPsiElement>> unusedMap, Map<String, Set<RPsiElement>> usedMap) {
        for (String name : unusedMap.keySet()) {
            Collection usedElements = usedMap.get(name);
            if (usedElements == null) continue;
            RubyUnusedLocalVariableVisitor.removeFromUnused(unusedMap, name, usedElements);
        }
    }

    private static void removeFromUnused(Map<String, Set<RPsiElement>> unusedMap, String name, Collection<RPsiElement> elements) {
        Set<RPsiElement> list = unusedMap.get(name);
        if (list == null) {
            return;
        }
        list.removeAll(elements);
    }

    private static void addToMap(Map<String, Set<RPsiElement>> map, String name, RPsiElement element) {
        Set<RPsiElement> set = map.get(name);
        if (set == null) {
            set = new HashSet<RPsiElement>();
            map.put(name, set);
        }
        set.add(element);
    }

    private static void addToMap(Map<String, Set<RPsiElement>> map, String name, Collection<RPsiElement> elements) {
        Set<RPsiElement> set = map.get(name);
        if (set == null) {
            set = new HashSet<RPsiElement>();
            map.put(name, set);
        }
        set.addAll(elements);
    }

    private static void addToMapExceptOneElement(Map<String, Set<RPsiElement>> map, String name, Collection<RPsiElement> elements, RPsiElement elementNotToInclude) {
        Set<RPsiElement> set = map.get(name);
        if (set == null) {
            set = new HashSet<RPsiElement>();
            map.put(name, set);
        }
        for (RPsiElement elem : elements) {
            if (elem == elementNotToInclude) continue;
            set.add(elem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rsClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rsMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsWithInheritors";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/unusedlocals/RubyUnusedLocalVariableVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitErbFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRObjectClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSingletonMethod";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processScopeHolder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "inheritsMethod";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "cantHaveUnusedParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

