/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RemoveAssignmentFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.unused.locals.remove.assignment");
        if (string == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        RIdentifier identifier;
        RSelfAssignmentExpression selfAssignmentExpression;
        if (project == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(2);
        }
        if ((selfAssignmentExpression = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)(identifier = (RIdentifier)descriptor.getPsiElement()))) != null) {
            if (RubyPsiUtilCore.getStatement((PsiElement)selfAssignmentExpression) == selfAssignmentExpression && RemoveAssignmentFix.canBeDeleted((RAssignmentExpression)selfAssignmentExpression)) {
                selfAssignmentExpression.delete();
                return;
            }
            StringBuilder builder2 = new StringBuilder();
            builder2.append(selfAssignmentExpression.getObject().getText());
            PsiElement operation = selfAssignmentExpression.getOperation();
            if (operation == null) {
                return;
            }
            String operationText = operation.getText();
            builder2.append(operationText, 0, operationText.length() - 1);
            RPsiElement value = selfAssignmentExpression.getValue();
            if (value == null) {
                return;
            }
            builder2.append(value.getText());
            selfAssignmentExpression.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)identifier, (String)builder2.toString()));
            return;
        }
        RAssignmentExpression assignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)identifier);
        if (assignmentExpression != null && RubyPsiUtilCore.getStatement((PsiElement)assignmentExpression) == assignmentExpression) {
            RPsiElement value = assignmentExpression.getValue();
            if (!RemoveAssignmentFix.canBeDeleted(assignmentExpression) && value != null) {
                assignmentExpression.replace((PsiElement)value);
                return;
            }
            assignmentExpression.delete();
        }
    }

    private static boolean canBeDeleted(@NotNull RAssignmentExpression expression) {
        RCompoundStatement compoundStatement;
        if (expression == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(3);
        }
        if (expression.getValue() instanceof RAssignmentExpression) {
            return false;
        }
        RPsiElement parent = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{RBlockStatement.class, RCodeBlock.class, RMethod.class});
        return parent == null || (compoundStatement = RubyPsiUtilCore.getCompoundStatement((PsiElement)expression)) == null || compoundStatement.getLastChild() != expression;
    }

    public static boolean canBeApplied(PsiElement element) {
        RSelfAssignmentExpression selfAssignmentExpression = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)element);
        if (selfAssignmentExpression != null) {
            return true;
        }
        RAssignmentExpression assignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)element);
        return assignmentExpression != null && !(assignmentExpression instanceof RMultiAssignmentExpression) && RubyPsiUtilCore.getStatement((PsiElement)assignmentExpression) == assignmentExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/unusedlocals/RemoveAssignmentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/unusedlocals/RemoveAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeDeleted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

