/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.unusedlocals;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class AssignParameterToFieldFix
implements LocalQuickFix {
    @Nls
    private final String myName;
    private static final Logger LOG = Logger.getInstance(AssignParameterToFieldFix.class);

    public AssignParameterToFieldFix(RIdentifier identifier) {
        this.myName = RBundle.message((String)"intention.name.assign.parameter.to.field", (Object[])new Object[]{identifier.getText(), identifier.getText()});
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AssignParameterToFieldFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intention.assign.field.from.parameter");
        if (string == null) {
            AssignParameterToFieldFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AssignParameterToFieldFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AssignParameterToFieldFix.$$$reportNull$$$0(3);
        }
        RIdentifier identifier = (RIdentifier)descriptor.getPsiElement();
        RPsiElement assignment = RubyElementFactoryCore.createElementFromText((PsiElement)identifier, (String)("@" + identifier.getText() + " = " + identifier.getText()));
        if (identifier.isMethodParameterDeclaration()) {
            RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)identifier, RMethod.class);
            if (method != null) {
                method.getCompoundStatement().add((PsiElement)assignment);
            }
            return;
        }
        LOG.error("Parameter type is not supported for id: " + identifier.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/unusedlocals/AssignParameterToFieldFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/unusedlocals/AssignParameterToFieldFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

