/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.supercall;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassModuleCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ModuleNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyDataDefineCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;

public final class RubySuperCallWithoutSuperclassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubySuperCallWithoutSuperclassInspection.$$$reportNull$$$0(0);
        }
        return new RubySuperCallVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/supercall/RubySuperCallWithoutSuperclassInspection", "buildVisitor"));
    }

    private static class RubySuperCallVisitor
    extends RubyInspectionVisitor {
        RubySuperCallVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
            RNamespace namespace;
            if (rPseudoConstant == null) {
                RubySuperCallVisitor.$$$reportNull$$$0(0);
            }
            if (!"super".equals(rPseudoConstant.getName())) {
                return;
            }
            RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)rPseudoConstant, RMethod.class);
            if (method == null) {
                if (!RubySuperCallVisitor.isInDynamicMethodDeclaration(rPseudoConstant)) {
                    this.registerProblem((PsiElement)rPseudoConstant, RBundle.message((String)"inspection.call.super.outside.of.method"));
                }
                return;
            }
            RBlockCall rBlockCall = RubyPsiUtil.getParentBlockCall((PsiElement)rPseudoConstant, blockCall -> blockCall.getCallType() instanceof ClassModuleCallType);
            if (rBlockCall != null) {
                RubyCallType callType = rBlockCall.getCallType();
                if (callType instanceof ClassNewCallType && !rBlockCall.getCall().getArguments().isEmpty()) {
                    return;
                }
                if (callType instanceof ModuleNewCallType) {
                    return;
                }
                if (callType instanceof RubyDataDefineCallType) {
                    return;
                }
            }
            if ((namespace = (RNamespace)PsiTreeUtil.getParentOfType((PsiElement)method, (Class[])new Class[]{RClass.class, RModule.class})) instanceof RModule) {
                return;
            }
            RClass rClass = (RClass)namespace;
            List<PsiElement> superMethods = RubyOverrideImplementUtil.getOverriddenMethods(method);
            if (superMethods.isEmpty()) {
                if (rClass == null) {
                    this.registerProblem((PsiElement)rPseudoConstant, RBundle.message((String)"inspection.call.super"));
                    return;
                }
                RSuperClass superClass = rClass.getPsiSuperClass();
                RPossibleCall rPossibleCall = RubyClassResolveUtil.findCall(rClass, arg_0 -> ((RubyCallType)RubyIncludeExtendCallTypes.INCLUDE_CALL).equals(arg_0));
                if (superClass == null && rPossibleCall == null) {
                    this.registerProblem((PsiElement)rPseudoConstant, RBundle.message((String)"inspection.call.super"));
                }
            }
        }

        private static boolean isInDynamicMethodDeclaration(@NotNull RPseudoConstant constant) {
            if (constant == null) {
                RubySuperCallVisitor.$$$reportNull$$$0(1);
            }
            return RSpecUtil.isProbablyInDefiningCallScope((PsiElement)constant) || RubyPsiUtil.isInBlockCallOfType((PsiElement)constant, RubyCallTypes.DEFINE_METHOD_CALL) || RubyPsiUtil.isInBlockCallOfType((PsiElement)constant, RubyCallTypes.DEFINE_SINGLETON_METHOD_CALL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rPseudoConstant";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/supercall/RubySuperCallWithoutSuperclassInspection$RubySuperCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRPseudoConstant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInDynamicMethodDeclaration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

