/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.stringinstancevariable;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;

public final class RubyInstanceVariableToStringInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyInstanceVariableToStringInspection.$$$reportNull$$$0(0);
        }
        return new RubyInstanceVariableToStringVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/stringinstancevariable/RubyInstanceVariableToStringInspection", "buildVisitor"));
    }

    private static class RubyInstanceVariableToStringVisitor
    extends RubyInspectionVisitor {
        RubyInstanceVariableToStringVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRExpressionSubstitution(@NotNull RExpressionSubstitution rExpressionSubstitution) {
            RCompoundStatement statement;
            if (rExpressionSubstitution == null) {
                RubyInstanceVariableToStringVisitor.$$$reportNull$$$0(0);
            }
            if ((statement = rExpressionSubstitution.getCompoundStatement()) != null) {
                return;
            }
            ASTNode[] children = rExpressionSubstitution.getNode().getChildren(null);
            if (children.length != 2) {
                return;
            }
            ASTNode dvarNode = children[0];
            if (dvarNode == null || !RubyTokenTypes.tSTRING_DVAR.equals(dvarNode.getElementType())) {
                return;
            }
            ASTNode varNode = children[1];
            if (varNode == null) {
                return;
            }
            IElementType varNodeType = varNode.getElementType();
            if (RubyElementTypes.INSTANCE_VARIABLE.equals(varNodeType)) {
                this.registerProblem((PsiElement)rExpressionSubstitution, RBundle.message((String)"inspection.instance.variable.to.string"), new RubyInstanceVariableToStringFix());
            } else if (RubyElementTypes.GLOBAL.equals(varNodeType)) {
                this.registerProblem((PsiElement)rExpressionSubstitution, RBundle.message((String)"inspection.global.variable.to.string"), new RubyInstanceVariableToStringFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rExpressionSubstitution", "org/jetbrains/plugins/ruby/ruby/inspections/stringinstancevariable/RubyInstanceVariableToStringInspection$RubyInstanceVariableToStringVisitor", "visitRExpressionSubstitution"));
        }
    }

    private static class RubyInstanceVariableToStringFix
    extends RubyFix {
        private RubyInstanceVariableToStringFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            RCompoundStatement statement;
            if (project == null) {
                RubyInstanceVariableToStringFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RubyInstanceVariableToStringFix.$$$reportNull$$$0(1);
            }
            if ((statement = ((RExpressionSubstitution)(element = descriptor.getPsiElement())).getCompoundStatement()) != null) {
                return;
            }
            PsiElement string = element.getParent();
            if (string instanceof RDStringLiteralImpl) {
                String stringText = string.getText();
                String elementText = element.getText();
                PsiElement varElement = element.getLastChild();
                if (varElement == null) {
                    return;
                }
                String replacementText = "#{" + varElement.getText() + "}";
                String replacement = stringText.replace(elementText, replacementText);
                RPsiElement generated = RubyElementFactoryCore.createElementFromText((PsiElement)string, (String)replacement);
                string.replace((PsiElement)generated);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.instance.variable.to.string.fix");
            if (string == null) {
                RubyInstanceVariableToStringFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/stringinstancevariable/RubyInstanceVariableToStringInspection$RubyInstanceVariableToStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/stringinstancevariable/RubyInstanceVariableToStringInspection$RubyInstanceVariableToStringFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

