/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.simplify;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.simplify.RubySimplifyBooleanQuickFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

class RubySimplifyBooleanVisitor
extends RubyInspectionVisitor {
    static final String RUBY_TRUE = RubyTokenTypesCore.kTRUE.toString();
    static final String RUBY_FALSE = RubyTokenTypesCore.kFALSE.toString();
    static final String RUBY_NIL = RubyTokenTypesCore.kNIL.toString();

    RubySimplifyBooleanVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            RubySimplifyBooleanVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitRBoolNegExpression(@NotNull RBoolNegExpression rBoolNegExpression) {
        PsiElement grandchild;
        PsiElement parent;
        if (rBoolNegExpression == null) {
            RubySimplifyBooleanVisitor.$$$reportNull$$$0(1);
        }
        if ((parent = rBoolNegExpression.getParent()) instanceof RBoolNegExpression) {
            return;
        }
        PsiElement child = rBoolNegExpression.getLastChild();
        if (child instanceof RBoolNegExpression && RTypeUtil.isBoolType(RTypeUtil.getType(grandchild = child.getLastChild()))) {
            RExpression expression = (RExpression)grandchild;
            ControlFlowHolder holder = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)rBoolNegExpression, ControlFlowHolder.class);
            if (holder == null) {
                return;
            }
            ThreeState canBeNil = NilAnalysisUtil.getCanBeNil((RPsiElement)expression, holder);
            if (canBeNil == ThreeState.NO) {
                this.registerProblem((RPsiElement)rBoolNegExpression);
            }
        }
    }

    public void visitRBoolBinExpression(@NotNull RBoolBinExpression rBoolBinExpression) {
        RPsiElement left;
        String leftText;
        if (rBoolBinExpression == null) {
            RubySimplifyBooleanVisitor.$$$reportNull$$$0(2);
        }
        if (RUBY_TRUE.equals(leftText = (left = rBoolBinExpression.getLeftOperand()).getText()) || RUBY_FALSE.equals(leftText) || RUBY_NIL.equals(leftText) || left instanceof RLiteral) {
            this.registerProblem((RPsiElement)rBoolBinExpression);
        }
    }

    public void visitRBoolMatchingExpression(@NotNull RBoolMatchingExpression rBoolMatchingExpression) {
        RPsiElement value;
        if (rBoolMatchingExpression == null) {
            RubySimplifyBooleanVisitor.$$$reportNull$$$0(3);
        }
        RPsiElement left = rBoolMatchingExpression.getLeftOperand();
        RPsiElement right = rBoolMatchingExpression.getRightOperand();
        if (!(left instanceof RExpression) || !(right instanceof RExpression)) {
            return;
        }
        IElementType operationType = rBoolMatchingExpression.getOperationType();
        if (RubyTokenTypes.tEQQ.equals(operationType)) {
            return;
        }
        if (left instanceof RDotReference && (value = ((RDotReference)left).getValue()) != null && "should".equals(value.getName())) {
            return;
        }
        ControlFlowHolder holder = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)rBoolMatchingExpression, ControlFlowHolder.class);
        if (holder == null) {
            return;
        }
        if (RubySimplifyBooleanQuickFix.getReplacementElement((RPsiElement)rBoolMatchingExpression) == null) {
            return;
        }
        if (RubySimplifyBooleanVisitor.isPrimitiveBoolean(left) && RTypeUtil.isBoolType(RTypeUtil.getType((PsiElement)right)) && NilAnalysisUtil.getCanBeNil(right, holder) == ThreeState.NO) {
            this.registerProblem((RPsiElement)rBoolMatchingExpression);
            return;
        }
        if (RubySimplifyBooleanVisitor.isPrimitiveBoolean(right) && RTypeUtil.isBoolType(RTypeUtil.getType((PsiElement)left)) && NilAnalysisUtil.getCanBeNil(left, holder) == ThreeState.NO) {
            this.registerProblem((RPsiElement)rBoolMatchingExpression);
        }
    }

    private void registerProblem(@NotNull RPsiElement element) {
        if (element == null) {
            RubySimplifyBooleanVisitor.$$$reportNull$$$0(4);
        }
        this.registerProblem((PsiElement)element, RBundle.message((String)"inspection.simplify.name"), new RubySimplifyBooleanQuickFix(element));
    }

    private static boolean isPrimitiveBoolean(@NotNull RPsiElement element) {
        if (element == null) {
            RubySimplifyBooleanVisitor.$$$reportNull$$$0(5);
        }
        return RUBY_TRUE.equals(element.getText()) || RUBY_FALSE.equals(element.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolNegExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolBinExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolMatchingExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/simplify/RubySimplifyBooleanVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBoolNegExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBoolBinExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBoolMatchingExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrimitiveBoolean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

