/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.safeNavigation;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class ConvertOneChainedExprToSafeNavigationInspection
extends LocalInspectionTool {
    private static final TokenSet AND_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypesCore.tAND, RubyTokenTypes.kAND});
    private static final Logger LOG = Logger.getInstance(ConvertOneChainedExprToSafeNavigationInspection.class);

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(0);
        }
        if (RubyPsiUtilCore.getLanguageLevel((PsiElement)element).isLessThan(LanguageLevel.RUBY23)) {
            return true;
        }
        return super.isSuppressedFor(element);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder);
    }

    private static boolean isNotNilCheck(@NotNull RBinaryExpression expression) {
        if (expression == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(2);
        }
        if (expression.getOperationType() != RubyTokenTypes.tNEQ) {
            return false;
        }
        RPsiElement rightOperand = expression.getRightOperand();
        return rightOperand instanceof RPseudoConstant && rightOperand.textMatches((CharSequence)"nil");
    }

    @Nullable
    private static RPsiElement isKindaNonNilCallCheck(@NotNull RPsiElement callOrExpression, @Nullable RPsiElement previousQualifiedCall) {
        if (callOrExpression == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(3);
        }
        RPsiElement call = callOrExpression instanceof RBinaryExpression && ConvertOneChainedExprToSafeNavigationInspection.isNotNilCheck((RBinaryExpression)callOrExpression) ? ((RBinaryExpression)callOrExpression).getLeftOperand() : callOrExpression;
        if (previousQualifiedCall == null) {
            return call instanceof RIdentifier || call instanceof RDotReference ? call : null;
        }
        if (!(call instanceof RDotReference)) {
            return null;
        }
        if (((RDotReference)call).isSafeNavigation()) {
            return null;
        }
        RPsiElement somethingLikePreviousCall = ((RDotReference)call).getReceiver();
        if (somethingLikePreviousCall != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)somethingLikePreviousCall, (PsiElement)previousQualifiedCall)) {
            return call;
        }
        return null;
    }

    @NotNull
    private static RDotReference createSafeChainedCall(@NotNull RPsiElement firstCall, @NotNull RDotReference lastCall) {
        if (firstCall == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(4);
        }
        if (lastCall == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(5);
        }
        String text = lastCall.getText();
        int fixedPartLength = Math.min(firstCall.getTextLength(), text.length());
        String newText = text.substring(0, fixedPartLength) + StringUtil.replace((String)text.substring(fixedPartLength), (String)".", (String)"&.");
        RDotReference rDotReference = (RDotReference)RubyElementFactoryCore.createElementFromText((PsiElement)lastCall, (String)newText);
        if (rDotReference == null) {
            ConvertOneChainedExprToSafeNavigationInspection.$$$reportNull$$$0(6);
        }
        return rDotReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callOrExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstCall";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCall";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/safeNavigation/ConvertOneChainedExprToSafeNavigationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/safeNavigation/ConvertOneChainedExprToSafeNavigationInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeChainedCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNotNilCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isKindaNonNilCallCheck";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSafeChainedCall";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static class Visitor
    extends RubyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder problemsHolder) {
            if (problemsHolder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(problemsHolder);
        }

        public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
            RPsiElement theCallFound;
            RPsiElement rightOperand;
            RPsiElement leftOperand;
            if (rBinaryExpression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((leftOperand = rBinaryExpression.getLeftOperand()) == null || !AND_TOKENS.contains(rBinaryExpression.getOperationType())) {
                return;
            }
            if (leftOperand instanceof RBinaryExpression && ((RBinaryExpression)leftOperand).getOperationType() != RubyTokenTypes.tNEQ) {
                return;
            }
            RPsiElement firstCall = ConvertOneChainedExprToSafeNavigationInspection.isKindaNonNilCallCheck(leftOperand, null);
            if (firstCall == null) {
                return;
            }
            RPsiElement lastChainedCall = firstCall;
            RBinaryExpression lastSuccessfulExpression = null;
            RBinaryExpression currentExpression = rBinaryExpression;
            while (AND_TOKENS.contains(currentExpression.getOperationType()) && (rightOperand = currentExpression.getRightOperand()) != null && (theCallFound = ConvertOneChainedExprToSafeNavigationInspection.isKindaNonNilCallCheck(rightOperand, lastChainedCall)) != null) {
                lastChainedCall = theCallFound;
                lastSuccessfulExpression = currentExpression;
                PsiElement expressionParent = currentExpression.getParent();
                if (!(expressionParent instanceof RBinaryExpression)) break;
                currentExpression = (RBinaryExpression)expressionParent;
            }
            if (lastSuccessfulExpression != null && lastChainedCall instanceof RDotReference) {
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)lastSuccessfulExpression.getProject());
                this.registerProblem((PsiElement)lastSuccessfulExpression, RBundle.message((String)"inspection.ruby.one.if.to.safe.nav.problem.name"), new QuickFix((SmartPsiElementPointer<RPsiElement>)pointerManager.createSmartPsiElementPointer((PsiElement)firstCall), (SmartPsiElementPointer<RDotReference>)pointerManager.createSmartPsiElementPointer((PsiElement)((RDotReference)lastChainedCall))));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rBinaryExpression";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/safeNavigation/ConvertOneChainedExprToSafeNavigationInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRBinaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class QuickFix
    extends RubyFix {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final SmartPsiElementPointer<RPsiElement> myFirstCallPointer;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final SmartPsiElementPointer<RDotReference> myChainedCallPointer;

        QuickFix(@NotNull SmartPsiElementPointer<RPsiElement> firstCallPointer, @NotNull SmartPsiElementPointer<RDotReference> chainedCallPointer) {
            if (firstCallPointer == null) {
                QuickFix.$$$reportNull$$$0(0);
            }
            if (chainedCallPointer == null) {
                QuickFix.$$$reportNull$$$0(1);
            }
            this.myFirstCallPointer = firstCallPointer;
            this.myChainedCallPointer = chainedCallPointer;
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement psiElement;
            if (project == null) {
                QuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                QuickFix.$$$reportNull$$$0(3);
            }
            if (!((psiElement = descriptor.getPsiElement()) instanceof RBinaryExpression)) {
                LOG.error("RBinaryExpression expected, got " + String.valueOf(psiElement));
                return;
            }
            RBinaryExpression expression = (RBinaryExpression)psiElement;
            RPsiElement firstCall = (RPsiElement)this.myFirstCallPointer.getElement();
            RDotReference dotReference = (RDotReference)this.myChainedCallPointer.getElement();
            if (firstCall == null || dotReference == null) {
                return;
            }
            expression.replace((PsiElement)ConvertOneChainedExprToSafeNavigationInspection.createSafeChainedCall(firstCall, dotReference));
        }

        @NotNull
        @Nls
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.ruby.one.if.to.safe.nav.quickfix.name");
            if (string == null) {
                QuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstCallPointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainedCallPointer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/safeNavigation/ConvertOneChainedExprToSafeNavigationInspection$QuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/safeNavigation/ConvertOneChainedExprToSafeNavigationInspection$QuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

