/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public final class RubocopUtil {
    private static final Logger LOG = Logger.getInstance(RubocopUtil.class);

    private RubocopUtil() {
    }

    public static boolean containsRubocopServerStartedMessage(@NotNull String text) {
        if (text == null) {
            RubocopUtil.$$$reportNull$$$0(0);
        }
        return text.contains("RuboCop server starting");
    }

    @NotNull
    public static String dropRubocopServerMessages(@NotNull String text) {
        if (text == null) {
            RubocopUtil.$$$reportNull$$$0(1);
        }
        int start = 0;
        int end = text.length();
        while (start < end) {
            int lineEnd = text.indexOf("\n", start) + 1;
            if (lineEnd == 0) {
                lineEnd = end;
            }
            if (Strings.indexOf((CharSequence)text, (CharSequence)"RuboCop server", (int)start, (int)lineEnd) < 0) break;
            start = lineEnd;
        }
        String string = text.substring(start, end);
        if (string == null) {
            RubocopUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static RubyGemExecutionContext getExecutionContext(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName) {
        if (gemName == null) {
            RubocopUtil.$$$reportNull$$$0(3);
        }
        RubyGemExecutionContext executionContext = null;
        if (BundlerUtil.hasGemfile(module)) {
            VirtualFile gemfile = BundlerUtil.getGemfile(module);
            boolean hasMissingGems = gemfile != null && BundlerGemInfrastructure.hasMissingGems(gemfile);
            LOG.debug("Module contains a Gemfile: ", new Object[]{gemfile});
            if (!hasMissingGems) {
                LOG.debug("No gems are missing, attempting to create a gem execution context from: ", new Object[]{module});
                executionContext = RubyGemExecutionContext.tryCreate(null, module, gemName);
            }
        } else {
            LOG.debug("Module does not have a Gemfile, attempting to create a gem execution context from: ", new Object[]{sdk});
            executionContext = RubyGemExecutionContext.tryCreate(sdk, module, gemName);
        }
        return executionContext;
    }

    public static void addRubocopToGemfile(@NotNull Project project, @NotNull Module module, @NotNull RubocopLinterModel model) {
        RFile gemfile;
        if (project == null) {
            RubocopUtil.$$$reportNull$$$0(4);
        }
        if (module == null) {
            RubocopUtil.$$$reportNull$$$0(5);
        }
        if (model == null) {
            RubocopUtil.$$$reportNull$$$0(6);
        }
        if ((gemfile = BundlerUtil.getGemfilePsiFile(module)) == null) {
            return;
        }
        String gem = model.getGemName();
        String command = RBundle.message((String)"inspection.rubocop.no.gem.action.command", (Object[])new Object[]{gem});
        WriteCommandAction.runWriteCommandAction((Project)project, (String)command, null, () -> {
            int offset = BundlerUtil.addGemToGemfile(gemfile, gem, "development", "require: false");
            ApplicationManager.getApplication().invokeLater(() -> {
                VirtualFile virtualFile = gemfile.getVirtualFile();
                if (virtualFile != null) {
                    FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), true);
                }
            });
            GemRequirementsChangeWatcher.getInstance(module).addFileScan(gemfile.getVirtualFile());
        }, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    public static String getFilePathRelativeToRoot(@NotNull VirtualFile file, @Nullable VirtualFile root) {
        if (file == null) {
            RubocopUtil.$$$reportNull$$$0(7);
        }
        if (root == null) {
            String string = file.getName();
            if (string == null) {
                RubocopUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root);
        String string = relativePath == null ? file.getName() : relativePath;
        if (string == null) {
            RubocopUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dropRubocopServerMessages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathRelativeToRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsRubocopServerStartedMessage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dropRubocopServerMessages";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRubocopToGemfile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathRelativeToRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9 -> new IllegalStateException(string);
        };
    }
}

