/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptGroup;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopAutocorrectFix;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopExternalAnnotator;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopFileResultDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopGlobalInspectionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;

public final class RubocopInspection
extends GlobalSimpleInspectionTool {
    private static final Logger LOG = Logger.getInstance(RubocopInspection.class);
    static final String SHORT_NAME = new RubocopInspection().getShortName();
    private static final String RUBOCOP_SEVERITY_REFACTOR = "refactor";
    private static final String RUBOCOP_SEVERITY_CONVENTION = "convention";
    private static final String RUBOCOP_SEVERITY_WARNING = "warning";
    private static final String RUBOCOP_SEVERITY_ERROR = "error";
    private static final String RUBOCOP_SEVERITY_FATAL = "fatal";
    public String myRefactorSeverity = HighlightSeverity.WEAK_WARNING.getName();
    public String myConventionSeverity = HighlightSeverity.WEAK_WARNING.getName();
    public String myWarningSeverity = HighlightSeverity.WARNING.getName();
    public String myErrorSeverity = HighlightSeverity.ERROR.getName();
    public String myFatalSeverity = HighlightSeverity.ERROR.getName();

    @NotNull
    public Map<String, String> getSeveritiesMap() {
        Map<String, String> map = Map.of(RUBOCOP_SEVERITY_REFACTOR, this.myRefactorSeverity, RUBOCOP_SEVERITY_CONVENTION, this.myConventionSeverity, RUBOCOP_SEVERITY_WARNING, this.myWarningSeverity, RUBOCOP_SEVERITY_ERROR, this.myErrorSeverity, RUBOCOP_SEVERITY_FATAL, this.myFatalSeverity);
        if (map == null) {
            RubocopInspection.$$$reportNull$$$0(0);
        }
        return map;
    }

    public boolean showDefaultConfigurationOptions() {
        return false;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptGroup severities = OptPane.group((String)RBundle.message((String)"inspection.rubocop.severities.mapping"), (OptRegularComponent[])new OptRegularComponent[]{RubocopInspection.rubocopSeverityDropDown("myRefactorSeverity", RBundle.message((String)"inspection.rubocop.severities.refactor")), RubocopInspection.rubocopSeverityDropDown("myConventionSeverity", RBundle.message((String)"inspection.rubocop.severities.convention")), RubocopInspection.rubocopSeverityDropDown("myWarningSeverity", RBundle.message((String)"inspection.rubocop.severities.warning")), RubocopInspection.rubocopSeverityDropDown("myErrorSeverity", RBundle.message((String)"inspection.rubocop.severities.error")), RubocopInspection.rubocopSeverityDropDown("myFatalSeverity", RBundle.message((String)"inspection.rubocop.severities.fatal"))});
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{severities});
        if (optPane == null) {
            RubocopInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public void checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        RubocopGlobalInspectionContext context;
        if (psiFile == null) {
            RubocopInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            RubocopInspection.$$$reportNull$$$0(3);
        }
        if (problemsHolder == null) {
            RubocopInspection.$$$reportNull$$$0(4);
        }
        if (globalContext == null) {
            RubocopInspection.$$$reportNull$$$0(5);
        }
        if (problemDescriptionsProcessor == null) {
            RubocopInspection.$$$reportNull$$$0(6);
        }
        if ((context = RubocopInspection.getRubocopContext(globalContext)).shouldStop()) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        RubocopFileResultDescriptor fileResult = context.getFileResult(virtualFile);
        if (fileResult == null) {
            LOG.debug("No result for " + String.valueOf(virtualFile));
            return;
        }
        fileResult.annotateOffenses(psiFile, (severity, range, message, fixes) -> {
            HighlightInfo info = RubocopInspection.offenseToHighlightInfo(severity, range, message, fixes);
            if (info != null) {
                GlobalInspectionUtil.createProblem((PsiElement)psiFile, (HighlightInfo)info, (TextRange)new TextRange(info.startOffset, info.endOffset), null, (InspectionManager)manager, (ProblemDescriptionsProcessor)problemDescriptionsProcessor, (GlobalInspectionContext)globalContext);
            }
        });
    }

    @Nullable
    private static HighlightInfo offenseToHighlightInfo(@NotNull HighlightSeverity severity, @NotNull TextRange range, @NlsContexts.DetailedDescription @NotNull String message, @NotNull List<? extends RubocopAutocorrectFix> fixes) {
        if (severity == null) {
            RubocopInspection.$$$reportNull$$$0(7);
        }
        if (range == null) {
            RubocopInspection.$$$reportNull$$$0(8);
        }
        if (message == null) {
            RubocopInspection.$$$reportNull$$$0(9);
        }
        if (fixes == null) {
            RubocopInspection.$$$reportNull$$$0(10);
        }
        HighlightInfo.Builder info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfo.convertSeverity((HighlightSeverity)severity)).range(range).descriptionAndTooltip(message);
        QuickFixAction.registerQuickFixActions((HighlightInfo.Builder)info, (TextRange)range, fixes);
        return info.create();
    }

    public boolean worksInBatchModeOnly() {
        return false;
    }

    @NotNull
    static RubocopGlobalInspectionContext getRubocopContext(@NotNull GlobalInspectionContext globalContext) {
        if (globalContext == null) {
            RubocopInspection.$$$reportNull$$$0(11);
        }
        RubocopGlobalInspectionContext extension = (RubocopGlobalInspectionContext)globalContext.getExtension(RubocopGlobalInspectionContext.ID);
        assert (extension != null);
        RubocopGlobalInspectionContext rubocopGlobalInspectionContext = extension;
        if (rubocopGlobalInspectionContext == null) {
            RubocopInspection.$$$reportNull$$$0(12);
        }
        return rubocopGlobalInspectionContext;
    }

    static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            RubocopInspection.$$$reportNull$$$0(13);
        }
        return ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile().isToolEnabled(HighlightDisplayKey.find((String)SHORT_NAME));
    }

    @NotNull
    static RubocopInspection getInstance(@NotNull Project project) {
        if (project == null) {
            RubocopInspection.$$$reportNull$$$0(14);
        }
        InspectionToolWrapper toolWrapper = Objects.requireNonNull(ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile().getInspectionTool(SHORT_NAME, project));
        RubocopInspection rubocopInspection = (RubocopInspection)toolWrapper.getTool();
        if (rubocopInspection == null) {
            RubocopInspection.$$$reportNull$$$0(15);
        }
        return rubocopInspection;
    }

    @TestOnly
    @NotNull
    public static RubocopInspection getInspection(@NotNull Project project) {
        if (project == null) {
            RubocopInspection.$$$reportNull$$$0(16);
        }
        return RubocopInspection.getInstance(project);
    }

    static void disableInspection(@NotNull Project project) {
        if (project == null) {
            RubocopInspection.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("Disabled RuboCop inspection.");
            InspectionProfileManager.getInstance((Project)project).getCurrentProfile().setToolEnabled(SHORT_NAME, false);
        });
    }

    @Nullable
    public static RubocopInspection from(@NotNull Tools tool) {
        InspectionProfileEntry rubocopInspection;
        if (tool == null) {
            RubocopInspection.$$$reportNull$$$0(18);
        }
        return (rubocopInspection = tool.getTool().getTool()) instanceof RubocopInspection ? (RubocopInspection)rubocopInspection : null;
    }

    @TestOnly
    @NotNull
    public static List<HighlightInfo> computeOffensesHighlightInfos(Project project, @NotNull VirtualFile fileToCheck) {
        PsiFile psiFile;
        if (fileToCheck == null) {
            RubocopInspection.$$$reportNull$$$0(19);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(fileToCheck)) == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                RubocopInspection.$$$reportNull$$$0(20);
            }
            return list;
        }
        RubocopExternalAnnotator rubocopExternalAnnotator = new RubocopExternalAnnotator();
        RubocopInitialInformation initialInformation = rubocopExternalAnnotator.collectInformation(psiFile);
        if (initialInformation == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                RubocopInspection.$$$reportNull$$$0(21);
            }
            return list;
        }
        RubocopFileResultDescriptor resultDescriptor = rubocopExternalAnnotator.doAnnotate(initialInformation);
        if (resultDescriptor == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                RubocopInspection.$$$reportNull$$$0(22);
            }
            return list;
        }
        ArrayList<HighlightInfo> annotationHolder = new ArrayList<HighlightInfo>();
        resultDescriptor.annotateOffenses(psiFile, (severity, range, message, fixes) -> {
            HighlightInfo info = RubocopInspection.offenseToHighlightInfo(severity, range, message, fixes);
            ContainerUtil.addIfNotNull((Collection)annotationHolder, (Object)info);
            if (!fixes.isEmpty()) assert (info != null) : String.valueOf(fixes) + "; " + String.valueOf(info);
        });
        ArrayList<HighlightInfo> arrayList = annotationHolder;
        if (arrayList == null) {
            RubocopInspection.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static OptDropdown rubocopSeverityDropDown(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel) {
        if (bindId == null) {
            RubocopInspection.$$$reportNull$$$0(24);
        }
        if (splitLabel == null) {
            RubocopInspection.$$$reportNull$$$0(25);
        }
        OptDropdown.Option[] options = (OptDropdown.Option[])LevelChooserAction.getSeverities((SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar(null)).stream().map(severity -> OptPane.option((String)severity.getName(), (String)severity.getDisplayCapitalizedName())).toArray(OptDropdown.Option[]::new);
        return OptPane.dropdown((String)bindId, (String)splitLabel, (OptDropdown.Option[])options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 16, 17, 18, 19, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeveritiesMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopInspection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubocopContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOffensesHighlightInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "offenseToHighlightInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRubocopContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInspection";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "disableInspection";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeOffensesHighlightInfos";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rubocopSeverityDropDown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 16, 17, 18, 19, 24, 25 -> new IllegalArgumentException(string);
        };
    }
}

