/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;

public class RubocopFileResultDescriptor {
    private static final Logger LOG = Logger.getInstance(RubocopFileResultDescriptor.class);
    @NotNull
    private final RubocopResponse.File myFile;
    @NotNull
    private final RubyGemExecutionContext myContext;
    @NotNull
    private final Map<String, String> mySeveritiesMap;
    @NotNull
    private final RubocopLinterModel myLinterModel;

    public RubocopFileResultDescriptor(@NotNull RubocopResponse.File file, @NotNull RubyGemExecutionContext context, @NotNull Map<String, String> severitiesMap, @NotNull RubocopLinterModel linterModel) {
        if (file == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(1);
        }
        if (severitiesMap == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(2);
        }
        if (linterModel == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(3);
        }
        this.myFile = file;
        this.myContext = new RubyGemExecutionContext(context);
        this.mySeveritiesMap = severitiesMap;
        this.myLinterModel = linterModel;
    }

    public void annotateOffenses(@NotNull PsiFile psiFile, @NotNull RubocopResponse.ResponseSink holder) {
        if (psiFile == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(5);
        }
        this.myFile.annotateOffenses(psiFile, holder, this.myContext, this.createSeverityMapper(psiFile), this.myLinterModel);
    }

    @NotNull
    private Function<String, HighlightSeverity> createSeverityMapper(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(6);
        }
        SeverityRegistrar registrar = SeverityRegistrar.getSeverityRegistrar((Project)psiFile.getProject());
        Function<String, HighlightSeverity> function = rubocopSeverityName -> {
            String platformSeverityName = this.mySeveritiesMap.get(rubocopSeverityName);
            if (StringUtil.isEmpty((String)platformSeverityName)) {
                LOG.warn("Unable to map rubocop's severity: " + rubocopSeverityName + " while processing " + String.valueOf(PsiUtilCore.getVirtualFile((PsiElement)psiFile)));
                return HighlightSeverity.INFORMATION;
            }
            HighlightSeverity severity = registrar.getSeverity(platformSeverityName);
            if (severity == null) {
                LOG.warn("Unable to find severity by name: " + platformSeverityName + " mapped from rubocop's " + rubocopSeverityName);
                return HighlightSeverity.ERROR;
            }
            return severity;
        };
        if (function == null) {
            RubocopFileResultDescriptor.$$$reportNull$$$0(7);
        }
        return function;
    }

    @TestOnly
    @Nullable
    public List<?> getOffenses() {
        return this.myFile.offenses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severitiesMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterModel";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopFileResultDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopFileResultDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeverityMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotateOffenses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSeverityMapper";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

