/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopAutocorrectFix;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopFileResultDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopSetUpNotificationService;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.security.RubyTrustedProjectService;

public final class RubocopExternalAnnotator
extends ExternalAnnotator<RubocopInitialInformation, RubocopFileResultDescriptor> {
    public static final RubocopExternalAnnotator INSTANCE = new RubocopExternalAnnotator();
    public static final String FEATURE_RUBOCOP_AUTO_CHECK = "ruby.rubocop.check.background";
    public static final String FEATURE_RUBOCOP_MANUAL_CHECK = "ruby.rubocop.check.manual";
    private static final Logger LOG = Logger.getInstance(RubocopExternalAnnotator.class);

    @RequiresReadLock
    @Nullable
    public RubocopInitialInformation collectInformation(@NotNull PsiFile psiFile) {
        Module module;
        if (psiFile == null) {
            RubocopExternalAnnotator.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = psiFile.getProject();
        if (project.isDisposed()) {
            LOG.debug("Project is disposed");
            return null;
        }
        if (!RubocopInspection.isEnabled(project)) {
            LOG.debug("Rubocop inspection disabled in " + project.getName());
            return null;
        }
        RubyTrustedProjectService rubyTrustedProjectService = RubyTrustedProjectService.getInstance(project);
        if (!rubyTrustedProjectService.isTrusted() && (module = ModuleUtilCore.findModuleForFile((PsiFile)psiFile)) != null && BundlerUtil.isBundlerRuntimeEmulationEnabled(module)) {
            rubyTrustedProjectService.addTrustedProjectCallback("rubocop.external.annotator", () -> DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)this));
            LOG.debug("Rubocop unable to run in bundler context on untrusted project: ", new Object[]{project, "; module: ", module});
            return null;
        }
        RubocopInitialInformation initialInformation = RubocopExternalAnnotator.calcInitialInformation(psiFile);
        if (initialInformation == null) {
            LOG.debug("Rubocop initial information is null for: ", new Object[]{psiFile});
            return null;
        }
        if (initialInformation.getGemExecutionContext() != null) {
            return initialInformation;
        }
        RubocopSetUpNotificationService.getInstance(project).notify(RubocopLinterModel.getModel(project), initialInformation);
        return null;
    }

    @Nullable
    public RubocopFileResultDescriptor doAnnotate(RubocopInitialInformation initialInformation) {
        if (!initialInformation.isValid()) {
            return null;
        }
        RubyGemExecutionContext gemExecutionContext = initialInformation.getGemExecutionContext();
        if (gemExecutionContext == null) {
            return null;
        }
        final byte[] sourceFileBytes = (byte[])ReadAction.compute(() -> initialInformation.getSourceFileBytes());
        if (sourceFileBytes == null || sourceFileBytes.length == 0) {
            LOG.debug("RuboCop source file bytes are " + (sourceFileBytes == null ? "null" : "empty"));
            return null;
        }
        RubocopResponse rubocopResponse = RubocopResponse.computeWithArguments(gemExecutionContext, new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                try (OutputStream processInput = event.getProcessHandler().getProcessInput();){
                    if (processInput != null) {
                        processInput.write(sourceFileBytes);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator$1", "startNotified"));
            }
        });
        Project project = initialInformation.getProject();
        RubocopLinterModel model = initialInformation.getLinterModel();
        if (!rubocopResponse.isSuccess()) {
            model.showRubocopError(project, rubocopResponse);
            return null;
        }
        List<RubocopResponse.File> resultFiles = rubocopResponse.getFiles();
        if (resultFiles == null || resultFiles.isEmpty()) {
            return null;
        }
        if (!initialInformation.isValid()) {
            return null;
        }
        Map<String, String> severitiesMap = RubocopInspection.getInstance(project).getSeveritiesMap();
        return new RubocopFileResultDescriptor(resultFiles.get(0), gemExecutionContext, severitiesMap, model);
    }

    @RequiresReadLock
    public void apply(@NotNull PsiFile psiFile, @NotNull RubocopFileResultDescriptor resultDescriptor, @NotNull AnnotationHolder holder) {
        if (psiFile == null) {
            RubocopExternalAnnotator.$$$reportNull$$$0(1);
        }
        if (resultDescriptor == null) {
            RubocopExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            RubocopExternalAnnotator.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        resultDescriptor.annotateOffenses(psiFile, (severity, range, message, fixes) -> {
            AnnotationBuilder builder2 = holder.newAnnotation(severity, message).range(range);
            for (RubocopAutocorrectFix fix : fixes) {
                builder2 = builder2.withFix((IntentionAction)fix);
            }
            builder2.create();
        });
        FeatureUsageTracker.getInstance().triggerFeatureUsed(FEATURE_RUBOCOP_AUTO_CHECK);
    }

    @Nullable
    static RubocopInitialInformation calcInitialInformation(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RubocopExternalAnnotator.$$$reportNull$$$0(4);
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Computing info for: " + String.valueOf(PsiUtilCore.getVirtualFile((PsiElement)psiFile)));
        }
        if (!psiFile.getLanguage().is((Language)RubyLanguage.INSTANCE) || !virtualFile.isValid() || psiFile.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not good file: language: " + String.valueOf(psiFile.getLanguage()) + "; valid: " + virtualFile.isValid() + "; view provider: " + String.valueOf(psiFile.getViewProvider()));
            }
            return null;
        }
        Sdk fileSdk = RubySdkUtil.getFileSdk(project, virtualFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug("File sdk is " + String.valueOf(fileSdk));
        }
        return fileSdk == null ? null : new RubocopInitialInformation(fileSdk, psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calcInitialInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

