/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;

public class RubocopAutocorrectFix
implements IntentionAction,
LocalQuickFix {
    private static final String RUBOCOP_SOURCE_HEADING_DELIMITER = "====================\n";
    private static final String RUBOCOP_SOURCE_DELIMITER = "\n====================\n";
    private static final Logger LOG = Logger.getInstance(RubocopAutocorrectFix.class);
    private static final Key<Object> LOCK_KEY = Key.create((String)"rubocop.working");
    private static final Object LOCK = new Object();
    private static final NullableLazyValue<Boolean> TYPE_HANDLER_PATCHER = NullableLazyValue.atomicLazyNullable(() -> {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        TypedAction typedAction = TypedAction.getInstance();
        typedAction.setupRawHandler((TypedActionHandler)new MyRawHandler(typedAction.getRawHandler()));
        actionManager.setActionHandler("EditorBackSpace", (EditorActionHandler)new MyBackSpaceHandler(actionManager.getActionHandler("EditorBackSpace")));
        return null;
    });
    @NotNull
    private final RubyGemExecutionContext myGemExecutionContext;
    @NotNull
    private final RubocopLinterModel myLinterModel;
    @Nullable
    private final String myCopFilter;
    private final AtomicBoolean myIsExecuted;
    private boolean myIsFinished;

    public RubocopAutocorrectFix(@NotNull RubyGemExecutionContext gemExecutionContext, @NotNull RubocopLinterModel linterModel, @Nullable String copFilter) {
        if (gemExecutionContext == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(0);
        }
        if (linterModel == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(1);
        }
        this.myIsExecuted = new AtomicBoolean(false);
        this.myIsFinished = false;
        this.myGemExecutionContext = new RubyGemExecutionContext(gemExecutionContext);
        this.myCopFilter = copFilter;
        this.myLinterModel = linterModel;
    }

    @NotNull
    @Nls
    public String getText() {
        String string = StringUtil.isEmpty((String)this.myCopFilter) ? RBundle.message((String)"intention.rubocop.autocorrect") : RBundle.message((String)"intention.rubocop.autocorrect.filtered", (Object[])new Object[]{this.myCopFilter});
        if (string == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.getText();
    }

    @NotNull
    @Nls
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(7);
        }
        return new IntentionPreviewInfo.Html(RBundle.message((String)"intention.rubocop.autocorrect.preview"));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(8);
        }
        this.invokeOnce(psiFile);
    }

    private void invokeOnce(final @NotNull PsiFile psiFile) throws IncorrectOperationException {
        if (psiFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(9);
        }
        if (this.myIsExecuted.getAndSet(true)) {
            return;
        }
        String path = RubocopAutocorrectFix.getTopmostVirtualFile(psiFile.getVirtualFile()).getPath();
        Task.Backgroundable correctionTask = new Task.Backgroundable(psiFile.getProject(), RBundle.message((String)"intention.rubocop.autocorrecting.progress", (Object[])new Object[]{path}), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubocopAutocorrectFix.this.applyQuickFix(psiFile);
                RubocopAutocorrectFix.this.myIsFinished = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopAutocorrectFix$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)correctionTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyQuickFix(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(10);
        }
        if (!((Boolean)ReadAction.compute(() -> ((PsiFile)psiFile).isValid())).booleanValue()) {
            return;
        }
        Project project = psiFile.getProject();
        Document document = (Document)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getDocument(psiFile));
        if (document == null) {
            return;
        }
        try {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            ExecutionMode executionMode = RubocopAutocorrectFix.createExecutionMode(document, virtualFile, true);
            ProcessOutput processOutput = ((RubyGemExecutionContext)((RubyGemExecutionContext)this.myGemExecutionContext.withExecutionMode(executionMode)).withArguments((Collection)ReadAction.compute(() -> this.getRunArguments(project, virtualFile)))).executeScript();
            if (processOutput != null) {
                String responseText = RubocopAutocorrectFix.extractCorrectedText(processOutput, this.myGemExecutionContext);
                if (responseText != null) {
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)RBundle.message((String)"intention.rubocop.autocorrecting"), (String)"RUBOCOP", () -> {
                        PsiDocumentManagerBase.getTopLevelDocument((Document)document).setText((CharSequence)responseText);
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    }, (PsiFile[])new PsiFile[]{psiFile});
                } else {
                    LOG.warn("Unable to parse rubocop output, no warning delimiter: " + String.valueOf(processOutput));
                    RubocopLinterModel.showRubocopError(RBundle.message((String)"intention.rubocop.error.output", (Object[])new Object[]{RBundle.link((String)"https://github.com/bbatsov/rubocop/issues/2502#issuecomment-166012933", (String)"intention.rubocop.error.output.see.link.text")}), new AnAction[0]);
                }
            } else {
                RubocopLinterModel.showRubocopError(RBundle.message((String)"intention.rubocop.error.no.output"), new AnAction[0]);
            }
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        finally {
            RubocopAutocorrectFix.unlockDocument(document);
        }
    }

    @NotNull
    private List<String> getRunArguments(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(12);
        }
        ArrayList<String> args = new ArrayList<String>();
        Sdk sdk = this.myGemExecutionContext.getRubySdk();
        String gemVersion = this.myGemExecutionContext.getGemVersion();
        args.addAll(this.myLinterModel.getServerArgs(sdk, gemVersion));
        args.addAll(this.myLinterModel.getAutocorrectArgs(gemVersion));
        args.addAll(this.myLinterModel.getCopFilterArgs(this.myCopFilter));
        args.addAll(this.myLinterModel.getStdInFromFileArgs(new RubocopInitialInformation(project, virtualFile, sdk).getFileName()));
        List<String> list = Collections.unmodifiableList(args);
        if (list == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public static String extractCorrectedText(@Nullable ProcessOutput rubocopOutput, @NotNull RubyGemExecutionContext rubocopContext) {
        if (rubocopContext == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(14);
        }
        LOG.debug("Extracting output from ", new Object[]{rubocopOutput});
        if (rubocopOutput == null) {
            LOG.debug("Rubocop output is null");
            return null;
        }
        RubocopResponse.registerRubocopServer(rubocopContext);
        if (!rubocopOutput.isExitCodeSet()) {
            LOG.debug("Rubocop was interrupted or never finished: ", new Object[]{rubocopOutput});
            return null;
        }
        String stdout = rubocopOutput.getStdout();
        if (RubocopUtil.containsRubocopServerStartedMessage(stdout)) {
            stdout = RubocopUtil.dropRubocopServerMessages(stdout);
        }
        int responseStartOffset = -1;
        if (stdout.startsWith(RUBOCOP_SOURCE_HEADING_DELIMITER)) {
            responseStartOffset = RUBOCOP_SOURCE_HEADING_DELIMITER.length();
        } else {
            int sourceIndex = stdout.indexOf(RUBOCOP_SOURCE_DELIMITER);
            if (sourceIndex > -1) {
                responseStartOffset = sourceIndex + RUBOCOP_SOURCE_DELIMITER.length();
            }
        }
        return responseStartOffset < 0 ? null : stdout.substring(responseStartOffset);
    }

    @NotNull
    public static ExecutionMode createExecutionMode(@NotNull Document document, @NotNull VirtualFile virtualFile, boolean withDocumentLock) {
        if (document == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(15);
        }
        if (virtualFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(16);
        }
        return RubocopAutocorrectFix.createExecutionMode(document, virtualFile, withDocumentLock, false);
    }

    @NotNull
    public static ExecutionMode createExecutionMode(@NotNull Document document, @NotNull VirtualFile virtualFile, boolean withDocumentLock, boolean cancelable) {
        if (document == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(17);
        }
        if (virtualFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(18);
        }
        ExecutionModes.SameThreadMode executionMode = new ExecutionModes.SameThreadMode(cancelable);
        executionMode.addProcessListener(RubocopAutocorrectFix.writeToStdinListener(document, virtualFile, withDocumentLock));
        ExecutionModes.SameThreadMode sameThreadMode = executionMode;
        if (sameThreadMode == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(19);
        }
        return sameThreadMode;
    }

    public static ProcessListener writeToStdinListener(final @NotNull Document document, final @NotNull VirtualFile virtualFile, final boolean withDocumentLock) {
        if (document == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(21);
        }
        return new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                try (OutputStream processInput = event.getProcessHandler().getProcessInput();){
                    if (processInput == null) {
                        return;
                    }
                    if (withDocumentLock) {
                        RubocopAutocorrectFix.lockDocument(document);
                    }
                    String text = PsiDocumentManagerBase.getTopLevelDocument((Document)document).getText();
                    processInput.write(text.getBytes(virtualFile.getCharset()));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopAutocorrectFix$2", "startNotified"));
            }
        };
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement startElement;
        if (project == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(22);
        }
        if (descriptor == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(23);
        }
        if ((startElement = descriptor.getStartElement()) == null) {
            return;
        }
        this.invokeOnce(startElement.getContainingFile());
    }

    private static void lockDocument(@NotNull Document document) {
        if (document == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(24);
        }
        TYPE_HANDLER_PATCHER.getValue();
        LOCK_KEY.set((UserDataHolder)document, LOCK);
    }

    private static void runIfNotLocked(@NotNull Editor editor, @NotNull Runnable runnable) {
        if (editor == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(25);
        }
        if (runnable == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(26);
        }
        if (LOCK_KEY.get((UserDataHolder)editor.getDocument()) != null) {
            HintManager.getInstance().showErrorHint(editor, RBundle.message((String)"intention.rubocop.error.readonly"));
        } else {
            runnable.run();
        }
    }

    private static void unlockDocument(@NotNull Document document) {
        if (document == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(27);
        }
        LOCK_KEY.set((UserDataHolder)document, null);
    }

    @NotNull
    private static VirtualFile getTopmostVirtualFile(@NotNull VirtualFile file) {
        if (file == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(28);
        }
        while (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            RubocopAutocorrectFix.$$$reportNull$$$0(29);
        }
        return virtualFile;
    }

    @TestOnly
    @Nullable
    public String getCopFilter() {
        return this.myCopFilter;
    }

    @TestOnly
    public final boolean isFinished() {
        return this.myIsFinished;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 13, 19, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemExecutionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterModel";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopAutocorrectFix";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubocopContext";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopAutocorrectFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunArguments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionMode";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 19: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnce";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyQuickFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRunArguments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractCorrectedText";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionMode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeToStdinListener";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lockDocument";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runIfNotLocked";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "unlockDocument";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostVirtualFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 13, 19, 29 -> new IllegalStateException(string);
        };
    }

    private static class MyRawHandler
    extends TypedActionHandlerBase {
        MyRawHandler(@Nullable TypedActionHandler originalHandler) {
            super(originalHandler);
        }

        public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
            if (editor == null) {
                MyRawHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MyRawHandler.$$$reportNull$$$0(1);
            }
            if (plan == null) {
                MyRawHandler.$$$reportNull$$$0(2);
            }
            RubocopAutocorrectFix.runIfNotLocked(editor, () -> super.beforeExecute(editor, c, context, plan));
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                MyRawHandler.$$$reportNull$$$0(3);
            }
            if (dataContext == null) {
                MyRawHandler.$$$reportNull$$$0(4);
            }
            RubocopAutocorrectFix.runIfNotLocked(editor, () -> {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, charTyped, dataContext);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plan";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopAutocorrectFix$MyRawHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExecute";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyBackSpaceHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        MyBackSpaceHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                MyBackSpaceHandler.$$$reportNull$$$0(0);
            }
            RubocopAutocorrectFix.runIfNotLocked(editor, () -> {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, caret, dataContext);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopAutocorrectFix$MyBackSpaceHandler", "doExecute"));
        }
    }
}

