/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.resolve;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.MethodReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RFileReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.TextResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyClassFix;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyMethodFix;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.RubyAutoImportProvider;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.assoc.RAssocNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RAssocKeyValueReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RequireRelativeFileReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyPsiSymbolReference;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyQualifiedNameSymbolReference;
import org.jetbrains.plugins.ruby.ruby.model.util.UtilKt;

public class RubyResolveVisitor
extends RubyInspectionVisitor {
    private final boolean myWarnImplicitResults;

    public RubyResolveVisitor(@NotNull ProblemsHolder holder, boolean warnImplicitResults) {
        if (holder == null) {
            RubyResolveVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
        this.myWarnImplicitResults = warnImplicitResults;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyResolveVisitor.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        for (RubyPsiSymbolReference reference : ExtensionsKt.getSymbolReferences((PsiElement)element, RubyPsiSymbolReference.class)) {
            if (!reference.resolveReference().isEmpty()) continue;
            this.myHolder.registerProblem(element, RubyResolveVisitor.getErrorMessage(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, reference.getRangeInElement(), new LocalQuickFix[0]);
        }
    }

    @Override
    protected void registerProblem(PsiElement element, String message) {
        super.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, RubyResolveVisitor.collectUnresolvedReferenceFixes(element, null));
    }

    private static LocalQuickFix[] collectUnresolvedReferenceFixes(PsiElement element, @Nullable ContextImpl context) {
        ArrayList<CreateRubyMethodFix> result = new ArrayList<CreateRubyMethodFix>();
        PsiElement parent = element.getParent();
        if (!(parent instanceof RReference) && (element instanceof RIdentifier || element instanceof RFid || element instanceof RSymbol)) {
            String elementText;
            RContainer containingClass = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RClass.class, RModule.class});
            String string = elementText = element instanceof RSymbol ? RubyPsiUtilCore.getElementText((PsiElement)element) : element.getText();
            if (containingClass != null) {
                result.add(new CreateRubyMethodFix(element.getProject(), (RPsiElement)element, containingClass, elementText, context, null));
            } else {
                RCompoundStatement compStatement = CreateRubyMethodFix.getClosestApplicableEnclosingCompoundStatementForFix(element);
                if (compStatement != null) {
                    result.add(new CreateRubyMethodFix(element.getProject(), (RPsiElement)element, compStatement, elementText, context, null));
                }
            }
        }
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static LocalQuickFix[] collectUnresolvedQualifiedReferenceFixes(RType operandType, RQualifiedReference reference) {
        if (TextUtil.isConstId((String)reference.getCanonicalText())) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<CreateRubyMethodFix> result = new ArrayList<CreateRubyMethodFix>();
        RSymbolType symbolType = RTypeUtil.extractSymbolType(operandType);
        if (symbolType != null) {
            PsiElement declaration;
            Symbol symbol = symbolType.getSymbol();
            RPsiElement refObject = reference.getRefObject();
            if (refObject != null && ((declaration = symbol.getPsiElement()) instanceof RClass || declaration instanceof RModule)) {
                result.add(new CreateRubyMethodFix(declaration.getProject(), (RPsiElement)reference.getElement(), (RContainer)declaration, reference.getCanonicalText(), SymbolUtil.getContextRepresentingSymbol(symbolType.getSymbol()), null));
            }
        }
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public void visitRConstant(@NotNull RConstant rConstant) {
        if (rConstant == null) {
            RubyResolveVisitor.$$$reportNull$$$0(2);
        }
        if (UtilKt.isRubyModellingV2() && !rConstant.isCall()) {
            this.visitElement((PsiElement)rConstant);
            return;
        }
        if (RubyPsiUtilCore.isDeclaration((PsiElement)rConstant) || !RubyResolveVisitor.shouldInspectElement((RPsiElement)rConstant) || RCallNavigator.getByCommand((PsiElement)rConstant) != null) {
            return;
        }
        Symbol symbol = Arrays.stream(rConstant.getReferences()).map(it -> ResolveUtil.resolveToSymbolWithCaching(it, !this.myWarnImplicitResults)).filter(Objects::nonNull).findAny().orElse(null);
        if (symbol == null) {
            RubyAutoImportProvider provider;
            if (RubyResolveVisitor.isClassReference(rConstant)) {
                this.registerProblem((PsiElement)rConstant, RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{rConstant.getText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new CreateRubyClassFix(true), new CreateRubyClassFix(false));
                return;
            }
            HintAction autoImportAction = null;
            ProgressManager.checkCanceled();
            Iterator iterator = RubyAutoImportProvider.EP_NAME.getExtensionList().iterator();
            while (iterator.hasNext() && (autoImportAction = (provider = (RubyAutoImportProvider)iterator.next()).getAutoImportAction((RPsiElement)rConstant)) == null) {
            }
            this.registerProblem((PsiElement)rConstant, RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{rConstant.getText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, autoImportAction);
        }
    }

    private static boolean isClassReference(RConstant constant) {
        PsiElement parent = constant.getParent();
        if (parent instanceof RSuperClass) {
            return true;
        }
        return parent instanceof RDotReference;
    }

    public void visitRFid(@NotNull RFid rFid) {
        if (rFid == null) {
            RubyResolveVisitor.$$$reportNull$$$0(3);
        }
        if (!RubyResolveVisitor.shouldInspectElement((RPsiElement)rFid)) {
            return;
        }
        Symbol context = SymbolUtil.getScopeContextWithCaching((PsiElement)rFid);
        if (ResolveUtil.resolveToSymbolWithCaching(rFid.getReference(), this.isAcceptInvalidResults(context)) == null) {
            this.registerProblem((PsiElement)rFid, RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{rFid.getText()}));
        }
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            RubyResolveVisitor.$$$reportNull$$$0(4);
        }
        if (!RubyResolveVisitor.shouldInspectIdentifier(rIdentifier)) {
            return;
        }
        PsiReference reference = rIdentifier.getReference();
        if (reference == null) {
            return;
        }
        Symbol context = SymbolUtil.getScopeContextWithCaching((PsiElement)rIdentifier);
        if (ResolveUtil.resolveToSymbolWithCaching(reference, this.isAcceptInvalidResults(context)) == null) {
            this.registerProblem((PsiElement)rIdentifier, RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{rIdentifier.getText()}));
        }
    }

    private static boolean shouldInspectIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            RubyResolveVisitor.$$$reportNull$$$0(5);
        }
        return !rIdentifier.isConstructorLike() && !rIdentifier.isNumberedParameter() && RubyResolveVisitor.shouldInspectElement((RPsiElement)rIdentifier) && !rIdentifier.isParameterDeclaration() && !rIdentifier.isLocalVariable();
    }

    public void visitRAssocKey(@NotNull RAssocKey key) {
        RAssocKeyValueReference reference;
        RAssoc assoc;
        if (key == null) {
            RubyResolveVisitor.$$$reportNull$$$0(6);
        }
        if ((assoc = RAssocNavigator.getAssocByKey((PsiElement)key)) != null && (reference = (RAssocKeyValueReference)ContainerUtil.findInstance((Object[])key.getReferences(), RAssocKeyValueReference.class)) != null && ResolveUtil.resolveToSymbolWithCaching(reference, !this.myWarnImplicitResults) == null) {
            this.registerProblem((PsiElement)key, RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{key.getName()}));
        }
    }

    public void visitRReference(@NotNull RReference rReference) {
        if (rReference == null) {
            RubyResolveVisitor.$$$reportNull$$$0(7);
        }
        if (UtilKt.isRubyModellingV2()) {
            this.visitElement((PsiElement)rReference);
        }
        if (rReference.isConstructorLike() || !RubyResolveVisitor.shouldInspectElement((RPsiElement)rReference)) {
            return;
        }
        PsiReference psiReference = rReference.getReference();
        if (psiReference instanceof RQualifiedReference) {
            RQualifiedReference reference = (RQualifiedReference)psiReference;
            RType receiverType = reference.getRefObjectType();
            ResolveResult[] results = reference.multiResolve(false);
            if (results.length == 0) {
                if (receiverType.isTyped()) {
                    this.registerQReferenceProblem(receiverType, reference);
                } else {
                    this.registerProblem(reference.getRefValue(), RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{reference.getCanonicalText()}));
                }
                return;
            }
            if (!results[0].isValidResult() && results[0].getElement() == rReference.getValue() && receiverType.isTyped()) {
                this.registerQReferenceProblem(receiverType, reference);
            } else if (this.myWarnImplicitResults && receiverType.isTyped() && (results[0] instanceof TextResolveResult || !results[0].isValidResult())) {
                this.registerProblem(reference.getRefValue(), RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{reference.getCanonicalText()}));
            }
        }
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
        if (rBinaryExpression == null) {
            RubyResolveVisitor.$$$reportNull$$$0(8);
        }
        if (rBinaryExpression instanceof RRangeExpression || rBinaryExpression instanceof RBoolBinExpression) {
            return;
        }
        if (!RubyResolveVisitor.shouldInspectElement((RPsiElement)rBinaryExpression)) {
            return;
        }
        RPsiElement element = rBinaryExpression.getLeftOperand();
        RType leftOperandType = null;
        if (element instanceof RExpression && !(leftOperandType = RTypeUtil.getType((PsiElement)element)).isTyped()) {
            return;
        }
        PsiReference psiReference = rBinaryExpression.getReference();
        assert (psiReference instanceof RQualifiedReference) : "Unexpected reference " + String.valueOf(psiReference) + " found in binary expression";
        RQualifiedReference reference = (RQualifiedReference)psiReference;
        if (reference.multiResolve(false).length == 0) {
            this.registerQReferenceProblem(leftOperandType, reference);
        }
    }

    private void registerQReferenceProblem(RType leftOperandType, RQualifiedReference reference) {
        String presentableTypeText;
        String string = presentableTypeText = leftOperandType != null ? RFrozenType.clearFrozenStatus(leftOperandType).getPresentableName() : null;
        if (presentableTypeText != null) {
            this.registerProblem(reference.getRefValue(), RBundle.message((String)"inspection.resolve.cannot.find.in.type", (Object[])new Object[]{reference.getCanonicalText(), presentableTypeText}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, RubyResolveVisitor.collectUnresolvedQualifiedReferenceFixes(leftOperandType, reference));
        } else {
            this.registerProblem(reference.getRefValue(), RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{reference.getCanonicalText()}));
        }
    }

    public void visitRUnaryExpression(@NotNull RUnaryExpression rUnaryExpression) {
        RQualifiedReference reference;
        if (rUnaryExpression == null) {
            RubyResolveVisitor.$$$reportNull$$$0(9);
        }
        if (rUnaryExpression instanceof RBoolNegExpression) {
            return;
        }
        RPsiElement element = rUnaryExpression.getElement();
        RType operandType = null;
        if (element instanceof RExpression && !(operandType = RTypeUtil.getType((PsiElement)element)).isTyped()) {
            return;
        }
        PsiReference psiReference = rUnaryExpression.getReference();
        if (psiReference instanceof RQualifiedReference && (reference = (RQualifiedReference)psiReference).multiResolve(false).length == 0) {
            this.registerQReferenceProblem(operandType, reference);
        }
    }

    public void visitRAliasStatement(@NotNull RAliasStatement rAliasStatement) {
        if (rAliasStatement == null) {
            RubyResolveVisitor.$$$reportNull$$$0(10);
        }
        for (PsiReference reference : rAliasStatement.getReferences()) {
            if (reference.resolve() != null) continue;
            this.registerProblem((PsiElement)rAliasStatement.getPsiOldName(), RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{rAliasStatement.getOldName()}));
        }
    }

    private static boolean shouldInspectElement(@NotNull RPsiElement element) {
        if (element == null) {
            RubyResolveVisitor.$$$reportNull$$$0(11);
        }
        if (!element.isValid()) {
            return false;
        }
        if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)element) != null) {
            return false;
        }
        if (RubyPsiUtil.isClassModuleOrMethodName((PsiElement)element)) {
            return false;
        }
        return RSymbolNavigator.getSymbolByObject((PsiElement)element) == null;
    }

    @Override
    public void visitRequireCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.$$$reportNull$$$0(12);
        }
        this.visitRequireOrLoad(rCall);
    }

    @Override
    public void visitLoadCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.$$$reportNull$$$0(13);
        }
        this.visitRequireOrLoad(rCall);
    }

    @Override
    public void visitPublicCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.$$$reportNull$$$0(14);
        }
        this.visitAccessModifierCall(rCall);
    }

    @Override
    public void visitProtectedCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.$$$reportNull$$$0(15);
        }
        this.visitAccessModifierCall(rCall);
    }

    @Override
    public void visitPrivateCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.$$$reportNull$$$0(16);
        }
        this.visitAccessModifierCall(rCall);
    }

    private void visitAccessModifierCall(RCall rCall) {
        for (PsiReference reference : rCall.getReferences()) {
            if (!(reference instanceof MethodReference) || reference.resolve() != null) continue;
            PsiElement element = ((MethodReference)reference).getReferenceContent();
            this.registerProblem(element, RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{reference.getCanonicalText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, RubyResolveVisitor.collectUnresolvedReferenceFixes(element, ContextImpl.INSTANCE_PRIVATE));
        }
    }

    private void visitRequireOrLoad(RCall call) {
        List references = Arrays.stream(call.getReferences()).flatMap(it -> {
            if (it instanceof RFileReference) {
                return Stream.of((RFileReference)it);
            }
            if (it instanceof RequireRelativeFileReference) {
                return Stream.of(((RequireRelativeFileReference)((Object)it)).getRFileReference());
            }
            return null;
        }).toList();
        for (RFileReference reference : references) {
            PsiElement value = reference.getRefValue();
            if (RFileUtil.evaluateRequirement(PsiUtilCore.getVirtualFile((PsiElement)call), value) == null || !reference.multiResolveToVirtualFiles().isEmpty()) continue;
            this.registerProblem(value, RBundle.message((String)"inspection.resolve.cannot.find.required.file"));
            return;
        }
    }

    public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
        if (rInstanceVariable == null) {
            RubyResolveVisitor.$$$reportNull$$$0(17);
        }
        this.visitField((RField)rInstanceVariable);
    }

    public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
        if (rClassVariable == null) {
            RubyResolveVisitor.$$$reportNull$$$0(18);
        }
        this.visitField((RField)rClassVariable);
    }

    @InspectionMessage
    @NotNull
    private static String getErrorMessage(@NotNull PsiSymbolReference reference) {
        if (reference == null) {
            RubyResolveVisitor.$$$reportNull$$$0(19);
        }
        if (reference instanceof RubyQualifiedNameSymbolReference) {
            RubyQualifiedNameSymbolReference qualifiedNameReference = (RubyQualifiedNameSymbolReference)reference;
            String string = RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{qualifiedNameReference.getQualifiedName()});
            if (string == null) {
                RubyResolveVisitor.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = RBundle.message((String)"inspection.resolve.cannot.find", (Object[])new Object[]{PsiSymbolReference.getReferenceText((PsiSymbolReference)reference)});
        if (string == null) {
            RubyResolveVisitor.$$$reportNull$$$0(21);
        }
        return string;
    }

    private void visitField(RField field) {
        if (!RubyResolveVisitor.shouldInspectElement((RPsiElement)field) || field.isDeclaration()) {
            return;
        }
        RContainer container = field.getParentContainer();
        if (container instanceof RModule || PsiTreeUtil.getParentOfType((PsiElement)container, (Class[])new Class[]{RClass.class, RModule.class, RTopLevelContainer.class}) instanceof RModule) {
            return;
        }
        PsiReference reference = field.getReference();
        if (reference == null) {
            return;
        }
        Symbol context = SymbolUtil.getScopeContextWithCaching((PsiElement)field);
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(reference, this.isAcceptInvalidResults(context));
        if (symbol == null || !ContainerUtil.and((Iterable)symbol.getAllDeclarations((PsiElement)field), RubyPsiUtilCore::isDeclaration)) {
            this.registerProblem((PsiElement)field, RBundle.message((String)"inspection.resolve.field.cannot.find", (Object[])new Object[]{field.getText()}));
        }
    }

    private boolean isAcceptInvalidResults(@Nullable Symbol context) {
        return !this.myWarnImplicitResults || context == null || context.getFQNWithNesting().equals((Object)CoreFqns.OBJECT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFid";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBinaryExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnaryExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAliasStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rInstanceVariable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClassVariable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/RubyResolveVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/RubyResolveVisitor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitRConstant";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitRFid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitRIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspectIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssocKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitRReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitRBinaryExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnaryExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRAliasStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspectElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRequireCall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitLoadCall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitPublicCall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitProtectedCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitPrivateCall";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitRInstanceVariable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitRClassVariable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 21 -> new IllegalStateException(string);
        };
    }
}

