/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.probableBugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.probableBugs.RubyExpectedMethodSignatureProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public final class RubyDefaultExpectedMethodSignatureProvider
implements RubyExpectedMethodSignatureProvider {
    private static final Set<String> IGNORED_METHOD_NAMES = Set.of("to_s");

    @Override
    @Nullable
    public List<ArgumentInfo> getExpectedMethodSignature(@NotNull RPossibleCall call) {
        PsiReference reference;
        if (call == null) {
            RubyDefaultExpectedMethodSignatureProvider.$$$reportNull$$$0(0);
        }
        if (call instanceof RArrayIndexing || call.getPsiCommand() instanceof RArrayIndexing) {
            return null;
        }
        if (IGNORED_METHOD_NAMES.contains(ObjectUtils.coalesce((Object)RubyPsiUtil.getCallCommand((PsiElement)call), (Object)""))) {
            return null;
        }
        if (call instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)call;
            reference = (PsiReference)ObjectUtils.doIfCast((Object)assignment.getObject(), RDotReference.class, PsiElement::getReference);
        } else {
            reference = (PsiReference)ObjectUtils.coalesce((Object)call.getReference(), (Object)((PsiReference)ObjectUtils.doIfNotNull((Object)call.getPsiCommand(), PsiElement::getReference)));
        }
        if (reference == null) {
            return null;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(reference);
        if (symbol != null && symbol.getType() == Type.ALIAS) {
            symbol = SymbolUtil.getMethodSymbolByAlias(symbol);
        }
        if (!(symbol instanceof CallableSymbol)) {
            return null;
        }
        CallableSymbol callableSymbol = (CallableSymbol)symbol;
        List parameters = (List)ObjectUtils.doIfNotNull((Object)callableSymbol.getArgumentInfos(), ArrayList::new);
        if (parameters == null || symbol.isSynthetic() && parameters.isEmpty()) {
            return null;
        }
        if (!ContainerUtil.exists((Iterable)parameters, it -> it.getType().isBlock() || it.getType() == ArgumentInfo.Type.CAPTURE)) {
            for (PsiElement declaration : symbol.getAllDeclarations((PsiElement)call)) {
                RMethod method;
                boolean isInStubs = RubyPsiUtil.isLocatedInStubs(declaration);
                if (declaration instanceof RMethod && !(method = (RMethod)declaration).hasSuperCall() && !method.hasYieldCall() && !isInStubs) continue;
                parameters.add(new ArgumentInfo("", ArgumentInfo.Type.BLOCK));
                break;
            }
        }
        return parameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/ruby/ruby/inspections/probableBugs/RubyDefaultExpectedMethodSignatureProvider", "getExpectedMethodSignature"));
    }
}

