/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.parentheses.beforeArguments;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyParenthesesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyParenthesesInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/parentheses/beforeArguments/RubyParenthesesInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        @Override
        public void visitRCall(@NotNull RCall call) {
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.checkElement((RPossibleCall)call);
        }

        public void visitRYieldStatement(@NotNull RYieldStatement yieldStatement) {
            if (yieldStatement == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.checkElement((RPossibleCall)yieldStatement);
        }

        private void checkElement(@NotNull RPossibleCall possibleCall) {
            if (possibleCall == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            PsiElement command = possibleCall.getPsiCommand();
            PsiElement argument = (PsiElement)ContainerUtil.getOnlyItem((Collection)possibleCall.getArguments());
            if (command == null || !(argument instanceof RGroupedExpression)) {
                return;
            }
            if (((RGroupedExpression)argument).getExpression() == null) {
                return;
            }
            if (MyVisitor.isLeftParentheses(PsiTreeUtil.nextVisibleLeaf((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)command)))) {
                this.registerProblem((PsiElement)possibleCall, RBundle.message((String)"inspection.parentheses.warning"));
            }
        }

        private static boolean isLeftParentheses(@Nullable PsiElement element) {
            return PsiUtilCore.getElementType((PsiElement)element) == RubyTokenTypes.tLPAREN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yieldStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "possibleCall";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/parentheses/beforeArguments/RubyParenthesesInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRCall";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRYieldStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

